/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Functions {
    private static final Function<Object, Class> TO_CLASS = new Function<Object, Class>(){

        @Override
        public Class fun(Object o) {
            return o.getClass();
        }
    };
    private static final Function PAIR_FIRST = new Function<Pair<?, ?>, Object>(){

        @Override
        public Object fun(Pair<?, ?> pair) {
            return Pair.getFirst(pair);
        }
    };
    private static final Function PAIR_SECOND = new Function<Pair<?, ?>, Object>(){

        @Override
        public Object fun(Pair<?, ?> pair) {
            return Pair.getSecond(pair);
        }
    };

    public static <A> Function.Mono<A> id() {
        return (Function.Mono)Function.ID;
    }

    public static <A, B> Function<A, B> identity() {
        return Function.ID;
    }

    public static <A, B, C> Function<A, C> compose(final Function<A, B> f1, final Function<B, ? extends C> f2) {
        return new Function<A, C>(){

            @Override
            public C fun(A a) {
                return f2.fun(f1.fun(a));
            }
        };
    }
}

