/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart.xychart;

import com.twosigma.beakerx.chart.AbstractChart;
import com.twosigma.beakerx.chart.ChartToJson;
import com.twosigma.beakerx.chart.xychart.plotitem.ConstantBand;
import com.twosigma.beakerx.chart.xychart.plotitem.ConstantLine;
import com.twosigma.beakerx.chart.xychart.plotitem.Rasters;
import com.twosigma.beakerx.chart.xychart.plotitem.Text;
import com.twosigma.beakerx.chart.xychart.plotitem.XYGraphics;
import java.util.ArrayList;
import java.util.List;

public abstract class XYChart
extends AbstractChart {
    private final List<XYGraphics> xyGraphics = new ArrayList<XYGraphics>();
    private final List<ConstantLine> constantLines = new ArrayList<ConstantLine>();
    private final List<ConstantBand> constantBands = new ArrayList<ConstantBand>();
    private final List<Rasters> rasters = new ArrayList<Rasters>();
    private final List<Text> texts = new ArrayList<Text>();
    private boolean xAutoRange = true;
    private double xLowerBound;
    private double xUpperBound;
    private boolean logX = false;
    private double xLogBase = 10.0;
    private Integer lodThreshold = null;
    private boolean xTickLabelsVisible = true;
    private boolean yTickLabelsVisible = true;

    public XYChart add(XYGraphics graphics) {
        graphics.setPlotType(this.getClass());
        this.xyGraphics.add(graphics);
        this.sendModelUpdate(ChartToJson.serializeXYGraphics(this.xyGraphics));
        return this;
    }

    public XYChart leftShift(XYGraphics graphics) {
        return this.add(graphics);
    }

    public List<XYGraphics> getGraphics() {
        return this.xyGraphics;
    }

    public XYChart add(ConstantLine constantLine) {
        constantLine.setPlotType(this.getClass());
        this.constantLines.add(constantLine);
        this.sendModelUpdate(ChartToJson.serializeConstantLines(this.constantLines));
        return this;
    }

    public XYChart leftShift(ConstantLine constantLine) {
        return this.add(constantLine);
    }

    public List<ConstantLine> getConstantLines() {
        return this.constantLines;
    }

    public XYChart add(ConstantBand constantBand) {
        this.constantBands.add(constantBand);
        this.sendModelUpdate(ChartToJson.serializeConstantBands(this.constantBands));
        return this;
    }

    public XYChart leftShift(ConstantBand constantBand) {
        return this.add(constantBand);
    }

    public List<ConstantBand> getConstantBands() {
        return this.constantBands;
    }

    public XYChart add(Text text) {
        text.setPlotType(this.getClass());
        this.texts.add(text);
        this.sendModelUpdate(ChartToJson.serializeTexts(this.texts));
        return this;
    }

    public XYChart leftShift(Text text) {
        return this.add(text);
    }

    public List<Text> getTexts() {
        return this.texts;
    }

    public XYChart add(Rasters raster) {
        this.rasters.add(raster);
        this.sendModelUpdate(ChartToJson.serializeRasters(this.rasters));
        return this;
    }

    public XYChart leftShift(Rasters raster) {
        return this.add(raster);
    }

    public List<Rasters> getRasters() {
        return this.rasters;
    }

    @Override
    public XYChart add(List items) {
        for (Object o : items) {
            if (o instanceof Rasters) {
                this.add((Rasters)o);
                continue;
            }
            if (o instanceof XYGraphics) {
                this.add((XYGraphics)o);
                continue;
            }
            if (o instanceof ConstantLine) {
                this.add((ConstantLine)o);
                continue;
            }
            if (o instanceof ConstantBand) {
                this.add((ConstantBand)o);
                continue;
            }
            if (o instanceof Text) {
                this.add((Text)o);
                continue;
            }
            super.add(items);
        }
        return this;
    }

    public XYChart setXAutoRange(boolean xAutoRange) {
        this.xAutoRange = xAutoRange;
        this.sendModelUpdate(ChartToJson.serializeXAutoRange(this.xAutoRange));
        return this;
    }

    public XYChart setxAutoRange(boolean xAutoRange) {
        return this.setXAutoRange(xAutoRange);
    }

    public Boolean getXAutoRange() {
        return this.xAutoRange;
    }

    public XYChart setXBound(double lower, double upper) {
        this.xAutoRange = false;
        this.xLowerBound = lower;
        this.xUpperBound = upper;
        this.sendModelUpdate(ChartToJson.serializeXBound(this));
        return this;
    }

    public XYChart setXBound(List<Number> bound) {
        if (bound.size() != 2) {
            throw new IllegalArgumentException("to set the x bound, the list needs to be of size=2");
        }
        Number n0 = bound.get(0);
        Number n1 = bound.get(1);
        this.setXBound(n0.doubleValue(), n1.doubleValue());
        return this;
    }

    public XYChart setxBound(List<Number> bound) {
        return this.setXBound(bound);
    }

    public Double getXLowerBound() {
        return this.xLowerBound;
    }

    public Double getXUpperBound() {
        return this.xUpperBound;
    }

    public XYChart setYAutoRange(boolean yAutoRange) {
        this.setXAutoRange(yAutoRange);
        return this;
    }

    @Override
    public XYChart setyAutoRange(boolean yAutoRange) {
        return this.setYAutoRange(yAutoRange);
    }

    public XYChart setLogX(boolean logX) {
        this.logX = logX;
        this.sendModelUpdate(ChartToJson.serializeLogX(this.logX));
        return this;
    }

    public Boolean getLogX() {
        return this.logX;
    }

    public Double getXLogBase() {
        return this.xLogBase;
    }

    public XYChart setXLogBase(double xLogBase) {
        this.xLogBase = xLogBase;
        this.sendModelUpdate(ChartToJson.serializeXLogBase(this.xLogBase));
        return this;
    }

    public XYChart setxLogBase(double xLogBase) {
        return this.setXLogBase(xLogBase);
    }

    public Integer getLodThreshold() {
        return this.lodThreshold;
    }

    public void setLodThreshold(Integer lodThreshold) {
        this.lodThreshold = lodThreshold;
        this.sendModelUpdate(ChartToJson.serializeLodThreshold(this.lodThreshold));
    }

    public boolean isxTickLabelsVisible() {
        return this.xTickLabelsVisible;
    }

    public void setxTickLabelsVisible(boolean xTickLabelsVisible) {
        this.xTickLabelsVisible = xTickLabelsVisible;
        this.sendModelUpdate(ChartToJson.serializeXTickLabelsVisible(this.xTickLabelsVisible));
    }

    public boolean isyTickLabelsVisible() {
        return this.yTickLabelsVisible;
    }

    public void setyTickLabelsVisible(boolean yTickLabelsVisible) {
        this.yTickLabelsVisible = yTickLabelsVisible;
        this.sendModelUpdate(ChartToJson.serializeYTickLabelsVisible(this.yTickLabelsVisible));
    }
}

