/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.handler;

import com.twosigma.beakerx.handler.KernelHandler;
import com.twosigma.beakerx.kernel.Code;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.commands.MagicCommand;
import com.twosigma.beakerx.kernel.commands.MagicCommandResult;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.message.Header;
import com.twosigma.beakerx.message.Message;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class ExecuteRequestHandler
extends KernelHandler<Message> {
    private MagicCommand magicCommand;
    private int executionCount = 0;
    private CompletableFuture<Boolean> syncObject;

    public ExecuteRequestHandler(KernelFunctionality kernel) {
        super(kernel);
        this.magicCommand = new MagicCommand(kernel);
    }

    @Override
    public void handle(Message message) {
        try {
            this.handleMsg(message);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void handleMsg(Message message) throws Exception {
        this.syncObject = new CompletableFuture();
        this.kernel.sendBusyMessage(message);
        ++this.executionCount;
        Code code = this.takeCodeFrom(message);
        this.announceThatWeHaveTheCode(message, code);
        if (code.isaMagicCommand()) {
            this.handleMagicCommand(message, code);
        } else {
            this.runCode(code.asString(), message);
        }
        this.syncObject.get();
    }

    private void handleMagicCommand(Message message, Code code) {
        MagicCommandResult magicCommandResult = this.magicCommand.process(code, message, this.executionCount);
        magicCommandResult.getItems().forEach(item -> {
            if (item.hasCodeToExecute()) {
                if (item.hasResult()) {
                    this.kernel.publish(item.getResult().get());
                }
            } else if (item.hasResult()) {
                this.sendMagicCommandReplyAndResult(message, item.getReply().get(), item.getResult().get());
            } else {
                this.sendMagicCommandReply(message, item.getReply().get());
            }
        });
        if (!magicCommandResult.getItems().isEmpty()) {
            magicCommandResult.getItems().get(0).getCode().ifPresent(codeToExecute -> this.runCode(codeToExecute.asString(), message));
        }
    }

    private Code takeCodeFrom(Message message) {
        String code = "";
        if (message.getContent() != null && message.getContent().containsKey("code")) {
            code = ((String)((Object)message.getContent().get("code"))).trim();
        }
        return new Code(code);
    }

    private void sendMagicCommandReply(Message message, Message replyMessage) {
        this.kernel.send(replyMessage);
        this.kernel.sendIdleMessage(message);
        this.syncObject.complete(true);
    }

    private void sendMagicCommandReplyAndResult(Message message, Message replyMessage, Message resultMessage) {
        this.kernel.publish(resultMessage);
        this.sendMagicCommandReply(message, replyMessage);
    }

    private void runCode(String code, Message message) {
        this.kernel.executeCode(code, message, this.executionCount, seo -> {
            this.kernel.sendIdleMessage(seo.getJupyterMessage());
            this.syncObject.complete(true);
        });
    }

    private void announceThatWeHaveTheCode(Message message, Code code) {
        Message reply = new Message();
        reply.setParentHeader(message.getHeader());
        reply.setIdentities(message.getIdentities());
        reply.setHeader(new Header(JupyterMessages.EXECUTE_INPUT, message.getHeader().getSession()));
        HashMap<String, Serializable> map1 = new HashMap<String, Serializable>(2);
        map1.put("execution_count", Integer.valueOf(this.executionCount));
        map1.put("code", (Serializable)((Object)code.asString()));
        reply.setContent(map1);
        this.kernel.publish(reply);
    }

    @Override
    public void exit() {
    }

    public MagicCommand getMagicCommand() {
        return this.magicCommand;
    }
}

