/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.easyform;

import com.twosigma.beakerx.easyform.EasyFormComponent;
import com.twosigma.beakerx.easyform.EasyFormView;
import com.twosigma.beakerx.easyform.ObservableMap;
import com.twosigma.beakerx.easyform.formitem.ListComponent;
import com.twosigma.beakerx.easyform.formitem.LoadValuesButton;
import com.twosigma.beakerx.easyform.formitem.SaveValuesButton;
import com.twosigma.beakerx.easyform.formitem.widgets.ButtonComponentWidget;
import com.twosigma.beakerx.easyform.formitem.widgets.CheckBoxGroupWidget;
import com.twosigma.beakerx.easyform.formitem.widgets.CheckBoxWidget;
import com.twosigma.beakerx.easyform.formitem.widgets.ComboBoxWidget;
import com.twosigma.beakerx.easyform.formitem.widgets.DatePickerComponentWidget;
import com.twosigma.beakerx.easyform.formitem.widgets.RadioButtonComponentWidget;
import com.twosigma.beakerx.easyform.formitem.widgets.SelectMultipleSingleWidget;
import com.twosigma.beakerx.easyform.formitem.widgets.SelectMultipleWidget;
import com.twosigma.beakerx.easyform.formitem.widgets.TextAreaWidget;
import com.twosigma.beakerx.easyform.formitem.widgets.TextFieldWidget;
import com.twosigma.beakerx.widgets.DOMWidget;
import com.twosigma.beakerx.widgets.DisplayableWidget;
import com.twosigma.beakerx.widgets.ValueWidget;
import com.twosigma.beakerx.widgets.Widget;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class EasyForm
extends ObservableMap<String, Object>
implements DisplayableWidget {
    public static final Integer HORIZONTAL = 1;
    public static final Integer VERTICAL = 2;
    private static final Integer AUTO_SIZE = 20;
    private final String caption;
    private Boolean ready = Boolean.FALSE;
    private Map<String, EasyFormComponent<ValueWidget<?>>> componentMap = new LinkedHashMap();
    private SaveValuesButton saveValuesButton;
    private LoadValuesButton loadValuesButton;

    public EasyForm(String caption) {
        this.caption = caption;
    }

    public void addSaveValuesButton(String path) {
        SaveValuesButton button = new SaveValuesButton();
        button.setPath(path);
        this.saveValuesButton = button;
    }

    public void addLoadValuesButton(String path) {
        LoadValuesButton button = new LoadValuesButton();
        button.setPath(path);
        this.loadValuesButton = button;
    }

    public EasyFormComponent addTextField(String label) throws Exception {
        return this.addTextField(label, -1);
    }

    public EasyFormComponent addTextField(String label, Integer size) throws Exception {
        TextFieldWidget textField = new TextFieldWidget();
        textField.setLabel(label);
        textField.setSize(size);
        return this.addComponentOrThrow(label, textField);
    }

    public EasyFormComponent addTextArea(String label) throws Exception {
        return this.addTextArea(label, null, TextAreaWidget.AUTO_WIDTH, TextAreaWidget.AUTO_HEIGHT);
    }

    public EasyFormComponent addTextArea(String label, Integer cols, Integer rows) throws Exception {
        return this.addTextArea(label, null, cols, rows);
    }

    public EasyFormComponent addTextArea(String label, String initialValue) throws Exception {
        return this.addTextArea(label, initialValue, TextAreaWidget.AUTO_WIDTH, TextAreaWidget.AUTO_HEIGHT);
    }

    public EasyFormComponent addTextArea(String label, String initialValue, Integer cols, Integer rows) throws Exception {
        TextAreaWidget textArea = new TextAreaWidget();
        textArea.registerUpdateValueCallback(textArea::fireChanged);
        textArea.setLabel(label);
        textArea.setCols(cols);
        textArea.setRows(rows);
        textArea.setValue(initialValue);
        return this.addComponentOrThrow(label, textArea);
    }

    public EasyFormComponent addCheckBox(String label) throws Exception {
        return this.addCheckBox(label, Boolean.FALSE);
    }

    public EasyFormComponent addCheckBox(String label, Boolean value) throws Exception {
        CheckBoxWidget checkBox = new CheckBoxWidget();
        checkBox.registerUpdateValueCallback(checkBox::fireChanged);
        checkBox.setLabel(label);
        checkBox.setValue(String.valueOf(value));
        return this.addComponentOrThrow(label, checkBox);
    }

    public EasyFormComponent addComboBox(String label, Collection<String> values) throws Exception {
        return this.addComboBox(label, values, Boolean.FALSE);
    }

    public EasyFormComponent addComboBox(String label, Collection<String> values, Boolean editable) throws Exception {
        return this.addComboBox(label, values, editable, AUTO_SIZE);
    }

    public EasyFormComponent addComboBox(String label, Collection<String> values, Boolean editable, Integer size) throws Exception {
        ComboBoxWidget comboBox = new ComboBoxWidget();
        comboBox.registerUpdateValueCallback(comboBox::fireChanged);
        comboBox.setLabel(label);
        comboBox.setEditable(editable);
        comboBox.setValues(values);
        comboBox.setSize(size);
        if (values != null && values.size() > 0) {
            comboBox.setValue(values.iterator().next());
        }
        return this.addComponentOrThrow(label, comboBox);
    }

    public EasyFormComponent addList(String label, Collection<String> values) throws Exception {
        return this.addList(label, values, Boolean.TRUE, values.size());
    }

    public EasyFormComponent addList(String label, Collection<String> values, Boolean multipleSelection) throws Exception {
        return this.addList(label, values, multipleSelection, values.size());
    }

    public EasyFormComponent addList(String label, Collection<String> values, Integer size) throws Exception {
        return this.addList(label, values, Boolean.TRUE, size);
    }

    public EasyFormComponent addList(String label, Collection<String> values, Boolean multipleSelection, Integer size) throws Exception {
        ListComponent list = multipleSelection != false ? this.createSelectMultipleWidget() : this.createSelectMultipleSingleWidget();
        list.setLabel(label);
        list.setSize(size);
        list.setMultipleSelection(multipleSelection);
        list.setValues(values);
        list.setValue(Collections.EMPTY_LIST);
        return this.addComponentOrThrow(label, list);
    }

    private ListComponent createSelectMultipleSingleWidget() {
        SelectMultipleSingleWidget list = new SelectMultipleSingleWidget();
        list.registerUpdateValueCallback(list::fireChanged);
        return list;
    }

    private ListComponent createSelectMultipleWidget() {
        SelectMultipleWidget list = new SelectMultipleWidget();
        list.registerUpdateValueCallback(list::fireChanged);
        return list;
    }

    public EasyFormComponent addRadioButtons(String label, Collection<String> values) throws Exception {
        return this.addRadioButtons(label, values, VERTICAL);
    }

    public EasyFormComponent addRadioButtons(String label, Collection<String> values, Integer orientation) throws Exception {
        RadioButtonComponentWidget radioButtonComponent = new RadioButtonComponentWidget(values, HORIZONTAL.equals(orientation));
        radioButtonComponent.setLabel(label);
        radioButtonComponent.registerUpdateValueCallback(radioButtonComponent::fireChanged);
        return this.addComponentOrThrow(label, radioButtonComponent);
    }

    public EasyFormComponent addCheckBoxes(String label, Collection<String> values) throws Exception {
        return this.addCheckBoxes(label, values, VERTICAL);
    }

    public EasyFormComponent addCheckBoxes(String label, Collection<String> values, Integer orientation) throws Exception {
        CheckBoxGroupWidget checkBoxGroup = new CheckBoxGroupWidget(values, HORIZONTAL.equals(orientation));
        checkBoxGroup.setLabel(label);
        checkBoxGroup.registerUpdateValueCallback(checkBoxGroup::fireChanged);
        return this.addComponentOrThrow(label, checkBoxGroup);
    }

    public EasyFormComponent addDatePicker(String label) throws Exception {
        DatePickerComponentWidget datePickerComponent = new DatePickerComponentWidget();
        datePickerComponent.registerUpdateValueCallback(datePickerComponent::fireChanged);
        datePickerComponent.setLabel(label);
        return this.addComponentOrThrow(label, datePickerComponent);
    }

    public ButtonComponentWidget addButton(String label) throws Exception {
        return this.addButton(label, null);
    }

    public ButtonComponentWidget addButton(String label, String actionCellTag) throws Exception {
        ButtonComponentWidget buttonComponent = new ButtonComponentWidget();
        buttonComponent.registerUpdateValueCallback(buttonComponent::fireChanged);
        buttonComponent.setLabel(label);
        buttonComponent.setTag(actionCellTag);
        this.addComponentOrThrow(label, buttonComponent);
        return buttonComponent;
    }

    public EasyFormComponent<ValueWidget<?>> addWidget(String label, ValueWidget<?> widget) throws Exception {
        EasyFormComponent ret = new EasyFormComponent(widget);
        this.addComponentOrThrow(label, ret);
        return ret;
    }

    private EasyFormComponent<ValueWidget<?>> addComponentOrThrow(String label, EasyFormComponent component) throws Exception {
        if (this.getComponentMap().containsKey(label)) {
            throw new Exception(String.format("EasyForm already contains component with such label: %s.", label));
        }
        this.getComponentMap().put(label, component);
        return component;
    }

    public Map<String, EasyFormComponent<ValueWidget<?>>> getComponentMap() {
        return this.componentMap;
    }

    public DOMWidget getWidget(String key) {
        return this.getComponentMap().get(key).getWidget();
    }

    public List<Widget> getCommFunctionalities() {
        return this.componentMap.values().stream().map(EasyFormComponent::getWidget).collect(Collectors.toList());
    }

    public boolean hasComponents() {
        return this.getComponentMap().size() > 0;
    }

    public boolean hasSaveValuesButton() {
        return this.saveValuesButton != null;
    }

    public boolean hasLoadValuesButton() {
        return this.loadValuesButton != null;
    }

    public SaveValuesButton getSaveValuesButton() {
        return this.saveValuesButton;
    }

    public LoadValuesButton getLoadValuesButton() {
        return this.loadValuesButton;
    }

    public String getCaption() {
        return this.caption;
    }

    private HashMap<String, Object> getValuesMap() {
        return this.mapInstance;
    }

    @Override
    public Object get(Object key) {
        this.checkComponentExists((String)key);
        return this.getComponentMap().get(key).getValue();
    }

    @Override
    public String put(String key, Object value) {
        this.checkComponentExists(key);
        EasyFormComponent<ValueWidget<?>> component = this.getComponentMap().get(key);
        if (!component.checkValue(value)) {
            throw new IllegalArgumentException(String.format("\"%s\" is not a valid option for %s \"%s\".", value, component.getClass().getSimpleName(), key));
        }
        String currentValue = component.formatValue(value);
        String previousValue = component.getValue() == null ? "" : component.getValue().toString();
        component.setValue(currentValue);
        this.getValuesMap().put(key, currentValue);
        this.setChanged();
        this.notifyObservers();
        component.fireChanged();
        return previousValue;
    }

    private void checkComponentExists(String key) {
        if (!this.componentExists(key)) {
            throw new IllegalArgumentException(String.format("The requested component \"%s\" does not exist.", key));
        }
    }

    private boolean componentExists(String key) {
        return this.getComponentMap().containsKey(key);
    }

    public void setEnabled(String label, Boolean enabled) {
        if (StringUtils.isNotEmpty((CharSequence)label) && this.componentMap.containsKey(label)) {
            this.componentMap.get(label).setEnabled(enabled);
            this.setChanged();
            this.notifyObservers();
        }
    }

    public Boolean isReady() {
        return this.ready;
    }

    public void setReady() {
        this.ready = Boolean.TRUE;
        for (EasyFormComponent<ValueWidget<?>> component : this.getComponentMap().values()) {
            if (!component.isButton()) {
                this.getValuesMap().put(component.getLabel(), component.getValue());
            }
            component.fireInit();
        }
    }

    public void setNotReady() {
        this.ready = Boolean.FALSE;
    }

    @Override
    public void display() {
        this.setReady();
        EasyFormView easyFormView = new EasyFormView(this.getCommFunctionalities());
        easyFormView.setEasyFormName(this.getCaption());
        easyFormView.display();
    }
}

