/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kotlin.evaluator;

import com.twosigma.beakerx.NamespaceClient;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.evaluator.WorkerThread;
import com.twosigma.beakerx.kotlin.evaluator.KotlinCodeRunner;
import com.twosigma.beakerx.kotlin.evaluator.KotlinEvaluator;
import com.twosigma.beakerx.kotlin.evaluator.ReplWithClassLoaderFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.jetbrains.kotlin.cli.common.repl.ReplClassLoader;
import org.jetbrains.kotlin.cli.jvm.repl.ReplInterpreter;

class KotlinWorkerThread
extends WorkerThread {
    private static final String WRAPPER_CLASS_NAME = "BeakerWrapperClass1261714175";
    private KotlinEvaluator kotlinEvaluator;
    protected boolean exit;
    protected boolean updateLoader;
    private ReplInterpreter repl;

    public KotlinWorkerThread(KotlinEvaluator kotlinEvaluator) {
        super("kotlin worker");
        this.kotlinEvaluator = kotlinEvaluator;
        this.exit = false;
        this.updateLoader = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ReplClassLoader loader = null;
        JobDescriptor j = null;
        NamespaceClient nc = null;
        while (!this.exit) {
            try {
                this.syncObject.acquire();
                if (loader == null || this.updateLoader) {
                    ReplWithClassLoaderFactory.ReplWithClassLoader replWithClassLoader = ReplWithClassLoaderFactory.createReplWithClassLoader(this.kotlinEvaluator);
                    this.repl = replWithClassLoader.getRepl();
                    loader = replWithClassLoader.getLoader();
                    this.updateLoader = false;
                }
                if ((j = (JobDescriptor)this.jobQueue.poll()) == null) continue;
                nc = NamespaceClient.getBeaker((String)this.kotlinEvaluator.getSessionId());
                nc.setOutputObj(j.outputObject);
                j.outputObject.started();
                try {
                    if (!this.kotlinEvaluator.executeTask(new KotlinCodeRunner(j.outputObject, (ClassLoader)loader, this.repl, j.codeToBeExecuted))) {
                        j.outputObject.error((Object)BaseEvaluator.INTERUPTED_MSG);
                    }
                    if (nc != null) {
                        nc.setOutputObj(null);
                        nc = null;
                    }
                }
                catch (Exception e) {
                    j.outputObject.error((Object)e);
                }
                j = null;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                if (nc == null) continue;
                nc.setOutputObj(null);
                nc = null;
            }
        }
        NamespaceClient.delBeaker((String)this.kotlinEvaluator.getSessionId());
    }

    public void updateLoader() {
        this.updateLoader = true;
    }

    public void doExit() {
        this.exit = true;
        this.removeKtFile();
    }

    private void removeKtFile() {
        try {
            Files.deleteIfExists(new File(this.kotlinEvaluator.getOutDir() + "\\" + WRAPPER_CLASS_NAME + ".kt").toPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

