/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.comm;

import com.twosigma.beakerx.handler.KernelHandler;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.message.Header;
import com.twosigma.beakerx.message.Message;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHandler<T>
extends KernelHandler<Message> {
    private static final Logger logger = LoggerFactory.getLogger(BaseHandler.class);

    public BaseHandler(KernelFunctionality kernel) {
        super(kernel);
    }

    protected Map<String, T> getData(Message message) {
        HashMap ret = null;
        if (message != null) {
            Map<String, Serializable> commMap = message.getContent();
            ret = (HashMap)commMap.get("data");
        } else {
            logger.info("Comm message contend is null");
        }
        return ret;
    }

    protected T getValueFromData(Message message, String key) {
        Object okObject;
        Object ret = null;
        Map<String, T> data = this.getData(message);
        Object object = okObject = data != null ? (Object)data.get(key) : null;
        if (okObject != null && okObject.getClass().isAssignableFrom(okObject.getClass())) {
            ret = okObject;
        }
        return (T)ret;
    }

    protected Message createReplyMessage(Message message, Serializable responceData) {
        Message ret = null;
        if (message != null) {
            ret = new Message();
            Map<String, Serializable> commMap = message.getContent();
            ret.setHeader(new Header(JupyterMessages.COMM_MSG, message.getHeader().getSession()));
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            map.put("comm_id", (Serializable)((Object)BaseHandler.getString(commMap, "comm_id")));
            map.put("data", responceData);
            ret.setContent(map);
        }
        return ret;
    }

    public static String getString(Map<String, Serializable> map, String name) {
        String ret = null;
        if (map != null && name != null && map.containsKey(name)) {
            ret = (String)((Object)map.get(name));
        }
        return ret;
    }

    public abstract String getHandlerCommand();
}

