/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.sql.evaluator;

import com.twosigma.beakerx.NamespaceClient;
import com.twosigma.beakerx.autocomplete.AutocompleteResult;
import com.twosigma.beakerx.autocomplete.ClasspathScanner;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.evaluator.TempFolderFactory;
import com.twosigma.beakerx.evaluator.TempFolderFactoryImpl;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.jvm.threads.BeakerCellExecutor;
import com.twosigma.beakerx.jvm.threads.CellExecutor;
import com.twosigma.beakerx.kernel.Classpath;
import com.twosigma.beakerx.kernel.KernelParameters;
import com.twosigma.beakerx.kernel.PathToJar;
import com.twosigma.beakerx.sql.ConnectionStringBean;
import com.twosigma.beakerx.sql.ConnectionStringHolder;
import com.twosigma.beakerx.sql.JDBCClient;
import com.twosigma.beakerx.sql.QueryExecutor;
import com.twosigma.beakerx.sql.ReadVariableException;
import com.twosigma.beakerx.sql.autocomplete.SQLAutocomplete;
import com.twosigma.beakerx.sql.evaluator.SQLWorkerThread;
import com.twosigma.beakerx.sql.kernel.SQLKernelParameters;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLEvaluator
extends BaseEvaluator {
    private static final Logger logger = LoggerFactory.getLogger((String)SQLEvaluator.class.getName());
    Map<String, ConnectionStringHolder> namedConnectionString = new HashMap<String, ConnectionStringHolder>();
    ConnectionStringHolder defaultConnectionString;
    private final String packageId = "com.twosigma.beaker.sql.bkr" + this.shellId.split("-")[0];
    private ClasspathScanner cps;
    private SQLAutocomplete sac;
    private final QueryExecutor queryExecutor;
    private final JDBCClient jdbcClient = new JDBCClient();
    private SQLWorkerThread workerThread;

    public SQLEvaluator(String id, String sId) {
        this(id, sId, (CellExecutor)new BeakerCellExecutor("sql"), (TempFolderFactory)new TempFolderFactoryImpl());
    }

    public SQLEvaluator(String id, String sId, CellExecutor cellExecutor, TempFolderFactory tempFolderFactory) {
        super(id, sId, cellExecutor, tempFolderFactory);
        this.cps = new ClasspathScanner();
        this.sac = this.createSqlAutocomplete(this.cps);
        this.queryExecutor = new QueryExecutor(this.jdbcClient);
        this.workerThread = new SQLWorkerThread(this);
        this.workerThread.start();
    }

    public void evaluate(SimpleEvaluationObject seo, String code) {
        this.workerThread.add(new JobDescriptor(code, seo));
    }

    public void exit() {
        super.exit();
        this.workerThread.doExit();
        this.cancelExecution();
    }

    public void cancelExecution() {
        super.cancelExecution();
        this.queryExecutor.cancel();
    }

    public void killAllThreads() {
        super.killAllThreads();
        this.queryExecutor.cancel();
    }

    public void resetEnvironment() {
        this.killAllThreads();
        this.jdbcClient.loadDrivers(this.classPath.getPathsAsStrings());
        this.sac = this.createSqlAutocomplete(this.cps);
    }

    protected void doResetEnvironment() {
        this.workerThread.halt();
    }

    private SQLAutocomplete createSqlAutocomplete(ClasspathScanner c) {
        return new SQLAutocomplete(c, this.jdbcClient, this.sessionId, this.defaultConnectionString, this.namedConnectionString);
    }

    public AutocompleteResult autocomplete(String code, int caretPosition) {
        return this.sac.doAutocomplete(code, caretPosition);
    }

    protected void configure(KernelParameters kernelParameters) {
        SQLKernelParameters params = new SQLKernelParameters(kernelParameters);
        Optional<Collection<String>> cp = params.getClassPath();
        if (cp.isPresent()) {
            if (cp.get() == null || cp.get().isEmpty()) {
                this.classPath = new Classpath();
            } else {
                for (String line : cp.get()) {
                    if (line.trim().isEmpty()) continue;
                    this.addJar(new PathToJar(line));
                }
            }
            this.jdbcClient.loadDrivers(this.classPath.getPathsAsStrings());
        }
        if (params.defaultDatasource().isPresent()) {
            this.defaultConnectionString = new ConnectionStringHolder(params.defaultDatasource().orElse(""), this.jdbcClient);
        }
        if (params.datasources().isPresent()) {
            this.namedConnectionString = new HashMap<String, ConnectionStringHolder>();
            Scanner sc = new Scanner(params.datasources().orElse(""));
            while (sc.hasNext()) {
                String line;
                line = sc.nextLine();
                int i = line.indexOf(61);
                if (i < 1 || i == line.length() - 1) {
                    logger.warn("Error in datasource line, this line will be ignored: {}.", (Object)line);
                    continue;
                }
                String name = line.substring(0, i).trim();
                String value = line.substring(i + 1).trim();
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                }
                this.namedConnectionString.put(name, new ConnectionStringHolder(value, this.jdbcClient));
            }
        }
    }

    public void setShellUserPassword(String namedConnection, String user, String password) {
        if (namedConnection != null && !namedConnection.isEmpty()) {
            ConnectionStringHolder holder;
            if (this.namedConnectionString != null && (holder = this.namedConnectionString.get(namedConnection)) != null) {
                if (password != null && !password.isEmpty()) {
                    holder.setPassword(password);
                }
                if (user != null && !user.isEmpty()) {
                    holder.setUser(user);
                }
                holder.setShowDialog(password == null || password.isEmpty() || user == null || user.isEmpty());
            }
        } else {
            if (password != null && !password.isEmpty()) {
                this.defaultConnectionString.setPassword(password);
            }
            if (user != null && !user.isEmpty()) {
                this.defaultConnectionString.setUser(user);
            }
            this.defaultConnectionString.setShowDialog(password == null || password.isEmpty() || user == null || user.isEmpty());
        }
        this.resetEnvironment();
    }

    public List<ConnectionStringBean> getListOfConnectiononWhoNeedDialog() {
        ArrayList<ConnectionStringBean> ret = new ArrayList<ConnectionStringBean>();
        if (this.defaultConnectionString.isShowDialog()) {
            ret.add(new ConnectionStringBean(null, this.defaultConnectionString.getConnectionString(), this.defaultConnectionString.getUser()));
        }
        if (this.namedConnectionString != null) {
            for (Map.Entry<String, ConnectionStringHolder> cbh : this.namedConnectionString.entrySet()) {
                if (!cbh.getValue().isShowDialog()) continue;
                ret.add(new ConnectionStringBean(cbh.getKey(), cbh.getValue().getConnectionString(), cbh.getValue().getUser()));
            }
        }
        return ret;
    }

    public Object executeQuery(String expression, NamespaceClient namespaceClient, ConnectionStringHolder defaultConnectionString, Map<String, ConnectionStringHolder> namedConnectionString) throws SQLException, IOException, ReadVariableException {
        return this.queryExecutor.executeQuery(expression, namespaceClient, defaultConnectionString, namedConnectionString);
    }
}

