/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitor;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.LabelResolver;
import org.jetbrains.kotlin.types.expressions.PreliminaryLoopVisitor;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

public class ControlStructureTypingVisitor
extends ExpressionTypingVisitor {
    public static final String RETURN_NOT_ALLOWED_MESSAGE = "Return not allowed";

    protected ControlStructureTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        if (facade == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(0);
        }
        super(facade);
    }

    @NotNull
    private DataFlowInfo checkCondition(@NotNull LexicalScope scope, @Nullable KtExpression condition, ExpressionTypingContext context) {
        if (scope == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(1);
        }
        if (condition != null) {
            ExpressionTypingContext conditionContext = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context.replaceScope(scope)).replaceExpectedType(this.components.builtIns.getBooleanType())).replaceContextDependency(ContextDependency.INDEPENDENT);
            KotlinTypeInfo typeInfo = this.facade.getTypeInfo(condition, conditionContext);
            DataFlowInfo dataFlowInfo = this.components.dataFlowAnalyzer.checkType(typeInfo, condition, (ResolutionContext)conditionContext).getDataFlowInfo();
            if (dataFlowInfo == null) {
                ControlStructureTypingVisitor.$$$reportNull$$$0(2);
            }
            return dataFlowInfo;
        }
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        if (dataFlowInfo == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(3);
        }
        return dataFlowInfo;
    }

    @Override
    public KotlinTypeInfo visitIfExpression(@NotNull KtIfExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(4);
        }
        return this.visitIfExpression(expression2, context, false);
    }

    public KotlinTypeInfo visitIfExpression(KtIfExpression ifExpression, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        DataFlowInfo resultDataFlowInfo;
        this.components.dataFlowAnalyzer.recordExpectedType(contextWithExpectedType.trace, ifExpression, contextWithExpectedType.expectedType);
        ExpressionTypingContext context = (ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        KtExpression condition = ifExpression.getCondition();
        DataFlowInfo conditionDataFlowInfo = this.checkCondition(context.scope, condition, context);
        boolean loopBreakContinuePossibleInCondition = condition != null && this.containsJumpOutOfLoop(condition, context);
        KtExpression elseBranch = ifExpression.getElse();
        KtExpression thenBranch = ifExpression.getThen();
        LexicalWritableScope thenScope = ExpressionTypingUtils.newWritableScopeImpl(context, LexicalScopeKind.THEN, this.components.overloadChecker);
        LexicalWritableScope elseScope = ExpressionTypingUtils.newWritableScopeImpl(context, LexicalScopeKind.ELSE, this.components.overloadChecker);
        DataFlowInfo thenInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(condition, true, context).and(conditionDataFlowInfo);
        DataFlowInfo elseInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(condition, false, context).and(conditionDataFlowInfo);
        if (elseBranch == null) {
            if (thenBranch != null) {
                KotlinTypeInfo result2 = this.getTypeInfoWhenOnlyOneBranchIsPresent(thenBranch, thenScope, thenInfo, elseInfo, contextWithExpectedType, ifExpression);
                return result2.getJumpOutPossible() ? result2.replaceJumpOutPossible(true).replaceJumpFlowInfo(conditionDataFlowInfo) : result2;
            }
            return TypeInfoFactoryKt.createTypeInfo((KotlinType)this.components.builtIns.getUnitType(), thenInfo.or(elseInfo));
        }
        if (thenBranch == null) {
            return this.getTypeInfoWhenOnlyOneBranchIsPresent(elseBranch, elseScope, elseInfo, thenInfo, contextWithExpectedType, ifExpression);
        }
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory(ifExpression, false);
        KtBlockExpression thenBlock = psiFactory.wrapInABlockWrapper(thenBranch);
        KtBlockExpression elseBlock = psiFactory.wrapInABlockWrapper(elseBranch);
        Call callForIf = ControlStructureTypingUtils.createCallForSpecialConstruction(ifExpression, ifExpression, Lists.newArrayList(thenBlock, elseBlock));
        MutableDataFlowInfoForArguments dataFlowInfoForArguments = ControlStructureTypingUtils.createDataFlowInfoForArgumentsForIfCall(callForIf, conditionDataFlowInfo, thenInfo, elseInfo);
        ResolvedCall<FunctionDescriptor> resolvedCall2 = this.components.controlStructureTypingUtils.resolveSpecialConstructionAsCall(callForIf, ControlStructureTypingUtils.ResolveConstruct.IF, Lists.newArrayList("thenBranch", "elseBranch"), Lists.newArrayList(false, false), contextWithExpectedType, dataFlowInfoForArguments);
        BindingContext bindingContext = context.trace.getBindingContext();
        KotlinTypeInfo thenTypeInfo = BindingContextUtils.getRecordedTypeInfo(thenBranch, bindingContext);
        KotlinTypeInfo elseTypeInfo = BindingContextUtils.getRecordedTypeInfo(elseBranch, bindingContext);
        assert (thenTypeInfo != null || elseTypeInfo != null) : "Both branches of if expression were not processed: " + ifExpression.getText();
        KotlinType resultType = resolvedCall2.getResultingDescriptor().getReturnType();
        boolean loopBreakContinuePossible = loopBreakContinuePossibleInCondition;
        if (elseTypeInfo == null) {
            loopBreakContinuePossible |= thenTypeInfo.getJumpOutPossible();
            resultDataFlowInfo = thenTypeInfo.getDataFlowInfo();
        } else if (thenTypeInfo == null) {
            loopBreakContinuePossible |= elseTypeInfo.getJumpOutPossible();
            resultDataFlowInfo = elseTypeInfo.getDataFlowInfo();
        } else {
            boolean jumpInElse;
            KotlinType thenType = thenTypeInfo.getType();
            KotlinType elseType = elseTypeInfo.getType();
            DataFlowInfo thenDataFlowInfo = thenTypeInfo.getDataFlowInfo();
            DataFlowInfo elseDataFlowInfo = elseTypeInfo.getDataFlowInfo();
            if (resultType != null && thenType != null && elseType != null) {
                DataFlowValue resultValue = DataFlowValueFactory.createDataFlowValue(ifExpression, resultType, context);
                DataFlowValue thenValue = DataFlowValueFactory.createDataFlowValue(thenBranch, thenType, context);
                thenDataFlowInfo = thenDataFlowInfo.assign(resultValue, thenValue, this.components.languageVersionSettings);
                DataFlowValue elseValue = DataFlowValueFactory.createDataFlowValue(elseBranch, elseType, context);
                elseDataFlowInfo = elseDataFlowInfo.assign(resultValue, elseValue, this.components.languageVersionSettings);
            }
            loopBreakContinuePossible |= thenTypeInfo.getJumpOutPossible() || elseTypeInfo.getJumpOutPossible();
            boolean jumpInThen = thenType != null && KotlinBuiltIns.isNothing(thenType);
            boolean bl = jumpInElse = elseType != null && KotlinBuiltIns.isNothing(elseType);
            resultDataFlowInfo = thenType == null && elseType == null ? thenDataFlowInfo.or(elseDataFlowInfo) : (thenType == null || jumpInThen && !jumpInElse ? elseDataFlowInfo : (elseType == null || jumpInElse && !jumpInThen ? thenDataFlowInfo : thenDataFlowInfo.or(elseDataFlowInfo)));
            if (thenType == null && jumpInElse || elseType == null && jumpInThen) {
                return TypeInfoFactoryKt.noTypeInfo(resultDataFlowInfo);
            }
        }
        return TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkType(resultType, (KtExpression)ifExpression, (ResolutionContext)contextWithExpectedType), resultDataFlowInfo, loopBreakContinuePossible, loopBreakContinuePossibleInCondition ? context.dataFlowInfo : conditionDataFlowInfo);
    }

    @NotNull
    private KotlinTypeInfo getTypeInfoWhenOnlyOneBranchIsPresent(@NotNull KtExpression presentBranch, @NotNull LexicalWritableScope presentScope, @NotNull DataFlowInfo presentInfo, @NotNull DataFlowInfo otherInfo, @NotNull ExpressionTypingContext context, @NotNull KtIfExpression ifExpression) {
        if (presentBranch == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(5);
        }
        if (presentScope == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(6);
        }
        if (presentInfo == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(7);
        }
        if (otherInfo == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(8);
        }
        if (context == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(9);
        }
        if (ifExpression == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(10);
        }
        ExpressionTypingContext newContext = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context.replaceDataFlowInfo(presentInfo)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        KotlinTypeInfo typeInfo = this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(presentScope, Collections.singletonList(presentBranch), CoercionStrategy.NO_COERCION, newContext);
        KotlinType type2 = typeInfo.getType();
        DataFlowInfo dataFlowInfo = type2 != null && KotlinBuiltIns.isNothing(type2) ? otherInfo : typeInfo.getDataFlowInfo().or(otherInfo);
        KotlinTypeInfo kotlinTypeInfo = this.components.dataFlowAnalyzer.checkType(typeInfo.replaceType(this.components.builtIns.getUnitType()), (KtExpression)ifExpression, (ResolutionContext)context).replaceDataFlowInfo(dataFlowInfo);
        if (kotlinTypeInfo == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(11);
        }
        return kotlinTypeInfo;
    }

    @Override
    public KotlinTypeInfo visitWhileExpression(@NotNull KtWhileExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(12);
        }
        return this.visitWhileExpression(expression2, context, false);
    }

    public KotlinTypeInfo visitWhileExpression(KtWhileExpression expression2, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        KotlinTypeInfo bodyTypeInfo;
        if (!isStatement) {
            DataFlowAnalyzer cfr_ignored_0 = this.components.dataFlowAnalyzer;
            return DataFlowAnalyzer.illegalStatementType(expression2, contextWithExpectedType, this.facade);
        }
        ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        PreliminaryLoopVisitor loopVisitor = PreliminaryLoopVisitor.visitLoop(expression2);
        context = (ExpressionTypingContext)context.replaceDataFlowInfo(loopVisitor.clearDataFlowInfoForAssignedLocalVariables(context.dataFlowInfo, this.components.languageVersionSettings));
        KtExpression condition = expression2.getCondition();
        DataFlowInfo dataFlowInfo = this.checkCondition(context.scope, condition, context);
        KtExpression body = expression2.getBody();
        DataFlowInfo conditionInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(condition, true, context).and(dataFlowInfo);
        if (body != null) {
            LexicalWritableScope scopeToExtend = ExpressionTypingUtils.newWritableScopeImpl(context, LexicalScopeKind.WHILE_BODY, this.components.overloadChecker);
            bodyTypeInfo = this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(scopeToExtend, Collections.singletonList(body), CoercionStrategy.NO_COERCION, (ExpressionTypingContext)context.replaceDataFlowInfo(conditionInfo));
        } else {
            bodyTypeInfo = TypeInfoFactoryKt.noTypeInfo(conditionInfo);
        }
        if (!this.containsJumpOutOfLoop(expression2, context)) {
            dataFlowInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(condition, false, context).and(dataFlowInfo);
        }
        if (body != null && KtPsiUtil.isTrueConstant(condition)) {
            dataFlowInfo = dataFlowInfo.and(loopVisitor.clearDataFlowInfoForAssignedLocalVariables(bodyTypeInfo.getJumpFlowInfo(), this.components.languageVersionSettings));
        }
        return this.components.dataFlowAnalyzer.checkType(bodyTypeInfo.replaceType(this.components.builtIns.getUnitType()), (KtExpression)expression2, (ResolutionContext)contextWithExpectedType).replaceDataFlowInfo(dataFlowInfo);
    }

    private boolean containsJumpOutOfLoop(final @NotNull KtExpression expression2, final ExpressionTypingContext context) {
        if (expression2 == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(13);
        }
        final boolean[] result2 = new boolean[]{false};
        expression2.accept(new KtTreeVisitor<List<KtLoopExpression>>(){

            @Override
            public Void visitBreakExpression(@NotNull KtBreakExpression breakExpression, List<KtLoopExpression> outerLoops) {
                KtSimpleNameExpression targetLabel;
                PsiElement element;
                if (breakExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                PsiElement psiElement = element = (targetLabel = breakExpression.getTargetLabel()) != null ? context.trace.get(BindingContext.LABEL_TARGET, targetLabel) : null;
                if (outerLoops.isEmpty() || element == expression2 || targetLabel == null && outerLoops.get(outerLoops.size() - 1) == expression2) {
                    result2[0] = true;
                }
                return null;
            }

            @Override
            public Void visitContinueExpression(@NotNull KtContinueExpression expression22, List<KtLoopExpression> outerLoops) {
                PsiElement element;
                KtSimpleNameExpression targetLabel;
                if (expression22 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((targetLabel = expression22.getTargetLabel()) != null && (element = context.trace.get(BindingContext.LABEL_TARGET, targetLabel)) instanceof KtLoopExpression && !outerLoops.contains(element)) {
                    result2[0] = true;
                }
                return null;
            }

            @Override
            public Void visitLoopExpression(@NotNull KtLoopExpression loopExpression, List<KtLoopExpression> outerLoops) {
                if (loopExpression == null) {
                    1.$$$reportNull$$$0(2);
                }
                ArrayList<KtLoopExpression> newOuterLoops = Lists.newArrayList(outerLoops);
                newOuterLoops.add(loopExpression);
                return (Void)super.visitLoopExpression(loopExpression, newOuterLoops);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "breakExpression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "loopExpression";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitBreakExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitContinueExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLoopExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, expression2 instanceof KtLoopExpression ? Lists.newArrayList((KtLoopExpression)expression2) : Lists.newArrayList());
        return result2[0];
    }

    @Override
    public KotlinTypeInfo visitDoWhileExpression(@NotNull KtDoWhileExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(14);
        }
        return this.visitDoWhileExpression(expression2, context, false);
    }

    public KotlinTypeInfo visitDoWhileExpression(KtDoWhileExpression expression2, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        KotlinTypeInfo bodyTypeInfo;
        if (!isStatement) {
            DataFlowAnalyzer cfr_ignored_0 = this.components.dataFlowAnalyzer;
            return DataFlowAnalyzer.illegalStatementType(expression2, contextWithExpectedType, this.facade);
        }
        ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        KtExpression body = expression2.getBody();
        LexicalScope conditionScope = context.scope;
        PreliminaryLoopVisitor loopVisitor = PreliminaryLoopVisitor.visitLoop(expression2);
        context = (ExpressionTypingContext)context.replaceDataFlowInfo(loopVisitor.clearDataFlowInfoForAssignedLocalVariables(context.dataFlowInfo, this.components.languageVersionSettings));
        if (body instanceof KtLambdaExpression) {
            bodyTypeInfo = this.facade.getTypeInfo(body, (ExpressionTypingContext)context.replaceScope(context.scope));
        } else if (body != null) {
            LexicalWritableScope writableScope = ExpressionTypingUtils.newWritableScopeImpl(context, LexicalScopeKind.DO_WHILE_BODY, this.components.overloadChecker);
            conditionScope = writableScope;
            List<KtExpression> block = body instanceof KtBlockExpression ? ((KtBlockExpression)body).getStatements() : Collections.singletonList(body);
            bodyTypeInfo = this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(writableScope, block, CoercionStrategy.NO_COERCION, context);
        } else {
            bodyTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        }
        KtExpression condition = expression2.getCondition();
        DataFlowInfo conditionDataFlowInfo = this.checkCondition(conditionScope, condition, context);
        DataFlowInfo dataFlowInfo = !this.containsJumpOutOfLoop(expression2, context) ? this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(condition, false, context).and(conditionDataFlowInfo) : context.dataFlowInfo;
        if (body != null) {
            dataFlowInfo = dataFlowInfo.and(loopVisitor.clearDataFlowInfoForAssignedLocalVariables(bodyTypeInfo.getJumpFlowInfo(), this.components.languageVersionSettings));
        }
        return this.components.dataFlowAnalyzer.checkType(bodyTypeInfo.replaceType(this.components.builtIns.getUnitType()), (KtExpression)expression2, (ResolutionContext)contextWithExpectedType).replaceDataFlowInfo(dataFlowInfo);
    }

    @Override
    public KotlinTypeInfo visitForExpression(@NotNull KtForExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(15);
        }
        return this.visitForExpression(expression2, context, false);
    }

    public KotlinTypeInfo visitForExpression(KtForExpression expression2, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        KtExpression body;
        KotlinTypeInfo loopRangeInfo;
        if (!isStatement) {
            DataFlowAnalyzer cfr_ignored_0 = this.components.dataFlowAnalyzer;
            return DataFlowAnalyzer.illegalStatementType(expression2, contextWithExpectedType, this.facade);
        }
        ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        PreliminaryLoopVisitor loopVisitor = PreliminaryLoopVisitor.visitLoop(expression2);
        context = (ExpressionTypingContext)context.replaceDataFlowInfo(loopVisitor.clearDataFlowInfoForAssignedLocalVariables(context.dataFlowInfo, this.components.languageVersionSettings));
        KtExpression loopRange = expression2.getLoopRange();
        KotlinType expectedParameterType = null;
        if (loopRange != null) {
            ExpressionReceiver loopRangeReceiver = ExpressionTypingUtils.getExpressionReceiver(this.facade, loopRange, (ExpressionTypingContext)context.replaceScope(context.scope));
            loopRangeInfo = this.facade.getTypeInfo(loopRange, context);
            if (loopRangeReceiver != null) {
                expectedParameterType = this.components.forLoopConventionsChecker.checkIterableConvention(loopRangeReceiver, context);
            }
        } else {
            loopRangeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        }
        LexicalWritableScope loopScope = ExpressionTypingUtils.newWritableScopeImpl(context, LexicalScopeKind.FOR, this.components.overloadChecker);
        KtParameter loopParameter = expression2.getLoopParameter();
        if (loopParameter != null) {
            VariableDescriptor variableDescriptor = this.createLoopParameterDescriptor(loopParameter, expectedParameterType, context);
            ModifiersChecker.ModifiersCheckingProcedure modifiersCheckingProcedure = this.components.modifiersChecker.withTrace(context.trace);
            modifiersCheckingProcedure.checkModifiersForLocalDeclaration(loopParameter, variableDescriptor);
            this.components.identifierChecker.checkDeclaration(loopParameter, context.trace);
            loopScope.addVariableDescriptor(variableDescriptor);
            KtDestructuringDeclaration multiParameter = loopParameter.getDestructuringDeclaration();
            if (multiParameter != null) {
                KotlinType elementType = expectedParameterType == null ? ErrorUtils.createErrorType("Loop range has no type") : expectedParameterType;
                TransientReceiver iteratorNextAsReceiver = new TransientReceiver(elementType);
                this.components.annotationResolver.resolveAnnotationsWithArguments((LexicalScope)loopScope, loopParameter.getModifierList(), context.trace);
                this.components.destructuringDeclarationResolver.defineLocalVariablesFromDestructuringDeclaration(loopScope, multiParameter, iteratorNextAsReceiver, loopRange, context);
                modifiersCheckingProcedure.checkModifiersForDestructuringDeclaration(multiParameter);
                this.components.identifierChecker.checkDeclaration(multiParameter, context.trace);
            }
        }
        KotlinTypeInfo bodyTypeInfo = (body = expression2.getBody()) != null ? this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(loopScope, Collections.singletonList(body), CoercionStrategy.NO_COERCION, (ExpressionTypingContext)context.replaceDataFlowInfo(loopRangeInfo.getDataFlowInfo())) : loopRangeInfo;
        return this.components.dataFlowAnalyzer.checkType(bodyTypeInfo.replaceType(this.components.builtIns.getUnitType()), (KtExpression)expression2, (ResolutionContext)contextWithExpectedType).replaceDataFlowInfo(loopRangeInfo.getDataFlowInfo());
    }

    private VariableDescriptor createLoopParameterDescriptor(KtParameter loopParameter, KotlinType expectedParameterType, ExpressionTypingContext context) {
        VariableDescriptor variableDescriptor;
        this.components.modifiersChecker.withTrace(context.trace).checkParameterHasNoValOrVar(loopParameter, Errors.VAL_OR_VAR_ON_LOOP_PARAMETER);
        KtTypeReference typeReference = loopParameter.getTypeReference();
        if (typeReference != null) {
            variableDescriptor = this.components.descriptorResolver.resolveLocalVariableDescriptor(context.scope, loopParameter, context.trace);
            KotlinType actualParameterType = variableDescriptor.getType();
            if (expectedParameterType != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(expectedParameterType, actualParameterType)) {
                context.trace.report(Errors.TYPE_MISMATCH_IN_FOR_LOOP.on(typeReference, expectedParameterType, actualParameterType));
            }
        } else {
            if (expectedParameterType == null) {
                expectedParameterType = ErrorUtils.createErrorType("Error");
            }
            variableDescriptor = this.components.descriptorResolver.resolveLocalVariableDescriptor(loopParameter, expectedParameterType, context.trace, context.scope);
        }
        ExpressionTypingUtils.checkVariableShadowing(context.scope, context.trace, variableDescriptor);
        return variableDescriptor;
    }

    @Override
    public KotlinTypeInfo visitTryExpression(@NotNull KtTryExpression expression2, ExpressionTypingContext typingContext) {
        if (expression2 == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(16);
        }
        ExpressionTypingContext context = (ExpressionTypingContext)typingContext.replaceContextDependency(ContextDependency.INDEPENDENT);
        KtBlockExpression tryBlock = expression2.getTryBlock();
        List<KtCatchClause> catchClauses = expression2.getCatchClauses();
        KtFinallySection finallyBlock = expression2.getFinallyBlock();
        ArrayList<KotlinType> types = new ArrayList<KotlinType>();
        boolean nothingInAllCatchBranches = true;
        for (KtCatchClause catchClause : catchClauses) {
            KtParameter catchParameter = catchClause.getCatchParameter();
            KtExpression catchBody = catchClause.getCatchBody();
            boolean nothingInCatchBranch = false;
            if (catchParameter != null) {
                this.checkCatchParameterDeclaration(catchParameter, context);
                VariableDescriptor variableDescriptor = this.components.descriptorResolver.resolveLocalVariableDescriptor(context.scope, catchParameter, context.trace);
                KotlinType catchParameterType = variableDescriptor.getType();
                ControlStructureTypingVisitor.checkCatchParameterType(catchParameter, catchParameterType, context);
                SimpleType throwableType = this.components.builtIns.getThrowable().getDefaultType();
                this.components.dataFlowAnalyzer.checkType(catchParameterType, (KtExpression)catchParameter, (ResolutionContext)context.replaceExpectedType(throwableType));
                if (catchBody != null) {
                    LexicalWritableScope catchScope = ExpressionTypingUtils.newWritableScopeImpl(context, LexicalScopeKind.CATCH, this.components.overloadChecker);
                    catchScope.addVariableDescriptor(variableDescriptor);
                    KotlinType type2 = this.facade.getTypeInfo(catchBody, (ExpressionTypingContext)context.replaceScope(catchScope)).getType();
                    if (type2 != null) {
                        types.add(type2);
                        if (KotlinBuiltIns.isNothing(type2)) {
                            nothingInCatchBranch = true;
                        }
                    }
                }
            }
            if (nothingInCatchBranch) continue;
            nothingInAllCatchBranches = false;
        }
        KotlinTypeInfo result2 = TypeInfoFactoryKt.noTypeInfo(context);
        KotlinTypeInfo tryResult = this.facade.getTypeInfo(tryBlock, context);
        if (finallyBlock != null) {
            result2 = this.facade.getTypeInfo(finallyBlock.getFinalExpression(), (ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
        } else if (nothingInAllCatchBranches) {
            result2 = tryResult;
        }
        KotlinType type3 = tryResult.getType();
        if (type3 != null) {
            types.add(type3);
        }
        if (types.isEmpty()) {
            return result2.clearType();
        }
        return result2.replaceType(CommonSupertypes.commonSupertype(types));
    }

    private static void checkCatchParameterType(KtParameter catchParameter, KotlinType catchParameterType, ExpressionTypingContext context) {
        TypeParameterDescriptor typeParameterDescriptor = TypeUtils.getTypeParameterDescriptorOrNull(catchParameterType);
        if (typeParameterDescriptor != null) {
            if (typeParameterDescriptor.isReified()) {
                context.trace.report(Errors.REIFIED_TYPE_IN_CATCH_CLAUSE.on(catchParameter));
            } else {
                context.trace.report(Errors.TYPE_PARAMETER_IN_CATCH_CLAUSE.on(catchParameter));
            }
        }
    }

    private void checkCatchParameterDeclaration(KtParameter catchParameter, ExpressionTypingContext context) {
        this.components.identifierChecker.checkDeclaration(catchParameter, context.trace);
        ModifiersChecker.ModifiersCheckingProcedure modifiersChecking = this.components.modifiersChecker.withTrace(context.trace);
        modifiersChecking.checkParameterHasNoValOrVar(catchParameter, Errors.VAL_OR_VAR_ON_CATCH_PARAMETER);
        ModifierCheckerCore.INSTANCE.check(catchParameter, context.trace, null, this.components.languageVersionSettings);
        if (catchParameter.hasDefaultValue()) {
            context.trace.report(Errors.CATCH_PARAMETER_WITH_DEFAULT_VALUE.on(catchParameter));
        }
    }

    @Override
    public KotlinTypeInfo visitThrowExpression(@NotNull KtThrowExpression expression2, ExpressionTypingContext context) {
        KtExpression thrownExpression;
        if (expression2 == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(17);
        }
        if ((thrownExpression = expression2.getThrownExpression()) != null) {
            SimpleType throwableType = this.components.builtIns.getThrowable().getDefaultType();
            this.facade.getTypeInfo(thrownExpression, (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(throwableType)).replaceScope(context.scope)).replaceContextDependency(ContextDependency.INDEPENDENT));
        }
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(this.components.builtIns.getNothingType(), context, expression2);
    }

    @Override
    public KotlinTypeInfo visitReturnExpression(@NotNull KtReturnExpression expression2, ExpressionTypingContext context) {
        SimpleFunctionDescriptor functionDescriptor;
        if (expression2 == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(18);
        }
        KtElement labelTargetElement = LabelResolver.INSTANCE.resolveControlLabel(expression2, context);
        KtExpression returnedExpression = expression2.getReturnedExpression();
        KotlinType expectedType = TypeUtils.NO_EXPECTED_TYPE;
        SimpleType resultType = this.components.builtIns.getNothingType();
        KtDeclaration parentDeclaration = (KtDeclaration)context.getContextParentOfType(expression2, KtDeclaration.class);
        if (parentDeclaration instanceof KtParameter) {
            context.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression2));
        }
        if (expression2.getTargetLabel() == null) {
            while (parentDeclaration instanceof KtDestructuringDeclaration) {
                parentDeclaration = (KtDeclaration)context.getContextParentOfType(parentDeclaration, KtDeclaration.class);
            }
            DeclarationDescriptor declarationDescriptor = context.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, parentDeclaration);
            Pair<FunctionDescriptor, PsiElement> containingFunInfo = BindingContextUtils.getContainingFunctionSkipFunctionLiterals(declarationDescriptor, false);
            FunctionDescriptor containingFunctionDescriptor = containingFunInfo.getFirst();
            if (containingFunctionDescriptor != null) {
                if (!InlineUtil.checkNonLocalReturnUsage(containingFunctionDescriptor, expression2, context) || ControlStructureTypingVisitor.isClassInitializer(containingFunInfo)) {
                    context.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression2));
                    resultType = ErrorUtils.createErrorType(RETURN_NOT_ALLOWED_MESSAGE);
                }
                expectedType = ControlStructureTypingVisitor.getFunctionExpectedReturnType(containingFunctionDescriptor, (KtElement)containingFunInfo.getSecond(), context);
            } else {
                context.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression2));
                resultType = ErrorUtils.createErrorType(RETURN_NOT_ALLOWED_MESSAGE);
            }
        } else if (labelTargetElement != null && (functionDescriptor = context.trace.get(BindingContext.FUNCTION, labelTargetElement)) != null) {
            expectedType = ControlStructureTypingVisitor.getFunctionExpectedReturnType(functionDescriptor, labelTargetElement, context);
            if (!InlineUtil.checkNonLocalReturnUsage(functionDescriptor, expression2, context)) {
                context.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression2));
                resultType = ErrorUtils.createErrorType(RETURN_NOT_ALLOWED_MESSAGE);
            }
        }
        if (returnedExpression != null) {
            this.facade.getTypeInfo(returnedExpression, (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(expectedType)).replaceScope(context.scope)).replaceContextDependency(ContextDependency.INDEPENDENT));
        } else if (!(TypeUtils.noExpectedType(expectedType) || KotlinBuiltIns.isUnit(expectedType) || TypeUtils.isDontCarePlaceholder(expectedType))) {
            context.trace.report(Errors.RETURN_TYPE_MISMATCH.on(expression2, expectedType));
        }
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(resultType, context, expression2);
    }

    private static boolean isClassInitializer(@NotNull Pair<FunctionDescriptor, PsiElement> containingFunInfo) {
        if (containingFunInfo == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(19);
        }
        return containingFunInfo.getFirst() instanceof ConstructorDescriptor && !(containingFunInfo.getSecond() instanceof KtSecondaryConstructor);
    }

    @Override
    public KotlinTypeInfo visitBreakExpression(@NotNull KtBreakExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(20);
        }
        LabelResolver.INSTANCE.resolveControlLabel(expression2, context);
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(this.components.builtIns.getNothingType(), context, expression2).replaceJumpOutPossible(true);
    }

    @Override
    public KotlinTypeInfo visitContinueExpression(@NotNull KtContinueExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(21);
        }
        LabelResolver.INSTANCE.resolveControlLabel(expression2, context);
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(this.components.builtIns.getNothingType(), context, expression2).replaceJumpOutPossible(true);
    }

    @NotNull
    private static KotlinType getFunctionExpectedReturnType(@NotNull FunctionDescriptor descriptor2, @NotNull KtElement function2, @NotNull ExpressionTypingContext context) {
        KotlinType expectedType;
        if (descriptor2 == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(22);
        }
        if (function2 == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(23);
        }
        if (context == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(24);
        }
        if (function2 instanceof KtSecondaryConstructor) {
            expectedType = DescriptorUtilsKt.getBuiltIns(descriptor2).getUnitType();
        } else if (function2 instanceof KtFunction) {
            KtFunction ktFunction = (KtFunction)function2;
            expectedType = context.trace.get(BindingContext.EXPECTED_RETURN_TYPE, ktFunction);
            if (expectedType == null && (ktFunction.getTypeReference() != null || ktFunction.hasBlockBody())) {
                expectedType = descriptor2.getReturnType();
            }
        } else {
            expectedType = descriptor2.getReturnType();
        }
        KotlinType kotlinType = expectedType != null ? expectedType : TypeUtils.NO_EXPECTED_TYPE;
        if (kotlinType == null) {
            ControlStructureTypingVisitor.$$$reportNull$$$0(25);
        }
        return kotlinType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor";
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentBranch";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentScope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentInfo";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherInfo";
                break;
            }
            case 9: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifExpression";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFunInfo";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "checkCondition";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeInfoWhenOnlyOneBranchIsPresent";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionExpectedReturnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkCondition";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 25: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitIfExpression";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTypeInfoWhenOnlyOneBranchIsPresent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitWhileExpression";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "containsJumpOutOfLoop";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visitDoWhileExpression";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitForExpression";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visitTryExpression";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visitThrowExpression";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitReturnExpression";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isClassInitializer";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "visitBreakExpression";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "visitContinueExpression";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionExpectedReturnType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

