/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.checkers.ProtectedInSuperClassCompanionCallChecker$check$;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/ProtectedInSuperClassCompanionCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "kotlin-compiler"})
public final class ProtectedInSuperClassCompanionCallChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Intrinsics.checkParameterIsNotNull(context, "context");
        CallableDescriptor targetDescriptor = resolvedCall2.getResultingDescriptor().getOriginal();
        if (Intrinsics.areEqual(targetDescriptor.getVisibility(), Visibilities.PROTECTED) ^ true) {
            return;
        }
        if (AnnotationUtilKt.hasJvmStaticAnnotation(targetDescriptor)) {
            return;
        }
        DeclarationDescriptor containerDescriptor = targetDescriptor.getContainingDeclaration();
        if (containerDescriptor instanceof ClassDescriptor && ((ClassDescriptor)containerDescriptor).isCompanionObject()) {
            boolean bl;
            Sequence<DeclarationDescriptor> parentClassDescriptors;
            ClassDescriptor companionOwnerDescriptor;
            DeclarationDescriptor companionDescriptor;
            block9: {
                companionDescriptor = containerDescriptor;
                DeclarationDescriptor declarationDescriptor = ((ClassDescriptor)companionDescriptor).getContainingDeclaration();
                if (!(declarationDescriptor instanceof ClassDescriptor)) {
                    declarationDescriptor = null;
                }
                ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
                if (classDescriptor == null) {
                    return;
                }
                companionOwnerDescriptor = classDescriptor;
                Sequence<DeclarationDescriptor> $receiver$iv = DescriptorUtilsKt.getParentsWithSelf(context.getScope().getOwnerDescriptor());
                Sequence<DeclarationDescriptor> sequence2 = SequencesKt.filter($receiver$iv, check$$inlined$filterIsInstance$1.INSTANCE);
                if (sequence2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
                }
                parentClassDescriptors = sequence2;
                $receiver$iv = parentClassDescriptors;
                Iterator<DeclarationDescriptor> iterator2 = $receiver$iv.iterator();
                while (iterator2.hasNext()) {
                    DeclarationDescriptor element$iv = iterator2.next();
                    ClassDescriptor it = (ClassDescriptor)element$iv;
                    if (!DescriptorUtils.isSubclass(it, companionOwnerDescriptor)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
            if (!bl) {
                return;
            }
            DeclarationDescriptor declarationDescriptor = companionDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "companionDescriptor");
            if (SequencesKt.contains(parentClassDescriptors, declarationDescriptor) ^ true && SequencesKt.contains(parentClassDescriptors, companionOwnerDescriptor) ^ true) {
                context.getTrace().report(ErrorsJvm.SUBCLASS_CANT_CALL_COMPANION_PROTECTED_NON_STATIC.on(reportOn));
            }
        }
    }
}

