/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kotlin.evaluator;

import com.google.common.base.Preconditions;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.InternalVariable;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.kotlin.cli.common.repl.ReplEvalResult;
import org.jetbrains.kotlin.cli.jvm.repl.ReplInterpreter;

class KotlinCodeRunner
implements Runnable {
    private final SimpleEvaluationObject theOutput;
    private final ClassLoader loader;
    private final ReplInterpreter repl;
    private final String codeToBeExecuted;

    public KotlinCodeRunner(SimpleEvaluationObject out, ClassLoader ld, ReplInterpreter repl, String codeToBeExecuted) {
        this.theOutput = (SimpleEvaluationObject)Preconditions.checkNotNull((Object)out);
        this.loader = (ClassLoader)Preconditions.checkNotNull((Object)ld);
        this.repl = (ReplInterpreter)Preconditions.checkNotNull((Object)repl);
        this.codeToBeExecuted = codeToBeExecuted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ClassLoader oldld = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.loader);
        this.theOutput.setOutputHandler();
        InternalVariable.setValue((SimpleEvaluationObject)this.theOutput);
        try {
            InternalVariable.setValue((SimpleEvaluationObject)this.theOutput);
            ReplEvalResult eval = this.repl.eval(this.codeToBeExecuted);
            this.interpretResult(eval);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            if (e instanceof InterruptedException || e instanceof ThreadDeath) {
                this.theOutput.error((Object)BaseEvaluator.INTERUPTED_MSG);
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                this.theOutput.error((Object)sw.toString());
            }
        }
        finally {
            this.theOutput.executeCodeCallback();
        }
        this.theOutput.clrOutputHandler();
        Thread.currentThread().setContextClassLoader(oldld);
    }

    private void interpretResult(Object o) {
        if (o == null) {
            this.theOutput.finished(null);
        } else if (o instanceof ReplEvalResult.UnitResult) {
            this.theOutput.finished(null);
        } else if (o instanceof ReplEvalResult.ValueResult) {
            this.theOutput.finished(((ReplEvalResult.ValueResult)o).getValue());
        } else if (o instanceof ReplEvalResult.Error) {
            this.theOutput.error((Object)((ReplEvalResult.Error)o).getMessage());
        } else {
            this.theOutput.error(o);
        }
    }
}

