/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.sql;

import com.twosigma.beakerx.sql.JDBCClient;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class ConnectionStringHolder {
    public static final String USER_CONNECTION_KEY = "user";
    public static final String PASSWORD_CONNECTION_KEY = "password";
    public static final String KEY_FOR_DISPLAY_INPUT_DIALOG = "<prompt>";
    public static final char EQUAL_SIGN = '=';
    public static final char[] SEPARATORS = new char[]{'?', '&', ';', '/', '\\'};
    private JDBCClient jdbcClient;
    private String connectionString;
    private String user;
    private String password;
    private boolean showDialog;

    public ConnectionStringHolder(String connectionString, JDBCClient jdbcClient) {
        this.jdbcClient = jdbcClient;
        this.setConnectionString(connectionString);
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isShowDialog() {
        return this.showDialog;
    }

    public void setShowDialog(boolean showDialog) {
        this.showDialog = showDialog;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public String getActualConnectionString() {
        return ConnectionStringHolder.removeParameter(this.connectionString, USER_CONNECTION_KEY, PASSWORD_CONNECTION_KEY);
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
        if (connectionString != null && !connectionString.isEmpty()) {
            BasicDataSource ds = null;
            String user = null;
            try {
                ds = this.jdbcClient.getDataSource(connectionString);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (ds != null) {
                user = ConnectionStringHolder.getProperty(USER_CONNECTION_KEY, connectionString, ds.getDriver());
            }
            if (user == null) {
                user = ConnectionStringHolder.getProperty(USER_CONNECTION_KEY, connectionString);
            }
            if (user != null) {
                if (KEY_FOR_DISPLAY_INPUT_DIALOG.equals(user)) {
                    this.showDialog = true;
                } else {
                    this.user = user;
                }
                String password = ConnectionStringHolder.getProperty(PASSWORD_CONNECTION_KEY, connectionString);
                if (password != null) {
                    if (KEY_FOR_DISPLAY_INPUT_DIALOG.equals(password)) {
                        this.showDialog = true;
                    } else {
                        this.password = password;
                    }
                } else {
                    this.showDialog = true;
                }
            }
        }
    }

    protected static String getProperty(String property, String connectionString, Driver dbDriver) {
        String ret = null;
        if (property != null && !property.isEmpty() && dbDriver != null && connectionString != null && !connectionString.isEmpty()) {
            try {
                for (DriverPropertyInfo dpi : dbDriver.getPropertyInfo(connectionString, null)) {
                    if (!property.equalsIgnoreCase(dpi.name.trim())) continue;
                    ret = dpi.value;
                    break;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return ret;
    }

    protected static String getProperty(String property, String connectionString) {
        String ret = null;
        if (property != null && !property.isEmpty() && connectionString != null && !connectionString.isEmpty()) {
            for (NameValuePair param : URLEncodedUtils.parse((String)connectionString, (Charset)StandardCharsets.UTF_8, (char[])SEPARATORS)) {
                if (!property.equals(param.getName())) continue;
                ret = param.getValue();
                break;
            }
        }
        return ret;
    }

    protected static String removeParameter(String connectionString, String ... parameters) {
        String ret = connectionString;
        for (String parameter : parameters) {
            int index = ret.indexOf(parameter + '=');
            if (index <= -1) continue;
            int parameterEnd = ret.length();
            for (char c : SEPARATORS) {
                int temp = ret.indexOf(c, index);
                if (temp <= -1) continue;
                parameterEnd = Math.min(temp, parameterEnd);
            }
            String toRet = ret.substring(0, index);
            ret = toRet = toRet + ret.substring(parameterEnd, ret.length());
        }
        return ret;
    }
}

