/*
 * Decompiled with CFR 0.152.
 */
package jupyter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jupyter.Displayer;
import jupyter.Displayers;

class ToStringDisplayer
extends Displayer<Object> {
    private static final ToStringDisplayer INSTANCE = new ToStringDisplayer();

    ToStringDisplayer() {
    }

    public static Displayer<Object> get() {
        return INSTANCE;
    }

    @Override
    public Map<String, String> display(Object obj) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (obj.getClass().isArray()) {
            result.put("text/plain", this.displayArray(obj));
        } else {
            result.put("text/plain", obj.toString());
        }
        return result;
    }

    private String displayArray(Object obj) {
        Class<?> type = obj.getClass().getComponentType();
        if (type == Boolean.TYPE) {
            return Arrays.toString((int[])obj);
        }
        if (type == Byte.TYPE) {
            return Arrays.toString((byte[])obj);
        }
        if (type == Short.TYPE) {
            return Arrays.toString((short[])obj);
        }
        if (type == Integer.TYPE) {
            return Arrays.toString((int[])obj);
        }
        if (type == Long.TYPE) {
            return Arrays.toString((long[])obj);
        }
        if (type == Float.TYPE) {
            return Arrays.toString((float[])obj);
        }
        if (type == Double.TYPE) {
            return Arrays.toString((double[])obj);
        }
        if (type == Character.TYPE) {
            return Arrays.toString((char[])obj);
        }
        Object[] arr = (Object[])obj;
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(Displayers.display(arr[0]).get("text/plain"));
        for (int i = 1; i < arr.length; ++i) {
            String asText = Displayers.display(arr[i]).get("text/plain");
            sb.append(", ").append(asText);
        }
        sb.append("]");
        return sb.toString();
    }
}

