/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.ResizeableMappedFile;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public class MappedFileInputStream
extends InputStream {
    private final ResizeableMappedFile raf;
    private int cur;
    private long limit;

    /*
     * WARNING - void declaration
     */
    public MappedFileInputStream(@NotNull ResizeableMappedFile raf, long pos, long l) {
        void limit;
        if (raf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "raf", "com/intellij/util/io/MappedFileInputStream", "<init>"));
        }
        this.raf = raf;
        this.setup(pos, (long)limit);
    }

    public void setup(long pos, long limit) {
        this.cur = (int)pos;
        this.limit = limit;
    }

    @Override
    public int available() {
        return (int)(this.limit - (long)this.cur);
    }

    @Override
    public void close() {
    }

    @Override
    public int read() throws IOException {
        int retval = -1;
        if ((long)this.cur < this.limit) {
            retval = this.raf.get(this.cur++);
        }
        return retval;
    }

    @Override
    public int read(@NotNull byte[] b, int offset2, int length) throws IOException {
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/util/io/MappedFileInputStream", "read"));
        }
        if (length > this.available()) {
            length = this.available();
        }
        if (this.available() > 0) {
            this.raf.get(this.cur, b, offset2, length);
            this.cur += length;
        }
        return length;
    }

    @Override
    public long skip(long amountToSkip) {
        long amountSkipped = Math.min(amountToSkip, (long)this.available());
        this.cur = (int)((long)this.cur + amountSkipped);
        return amountSkipped;
    }
}

