/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kotlin.evaluator;

import com.twosigma.beakerx.autocomplete.AutocompleteResult;
import com.twosigma.beakerx.autocomplete.ClasspathScanner;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.evaluator.TempFolderFactory;
import com.twosigma.beakerx.evaluator.TempFolderFactoryImpl;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.jvm.threads.BeakerCellExecutor;
import com.twosigma.beakerx.jvm.threads.CellExecutor;
import com.twosigma.beakerx.kernel.Classpath;
import com.twosigma.beakerx.kotlin.evaluator.KotlinWorkerThread;
import java.io.File;
import java.util.ArrayList;

public class KotlinEvaluator
extends BaseEvaluator {
    private final String packageId;
    private ClasspathScanner cps;
    private KotlinWorkerThread workerThread;

    public KotlinEvaluator(String id, String sId) {
        this(id, sId, (CellExecutor)new BeakerCellExecutor("kotlin"), (TempFolderFactory)new TempFolderFactoryImpl());
    }

    public KotlinEvaluator(String id, String sId, CellExecutor cellExecutor, TempFolderFactory tempFolderFactory) {
        super(id, sId, cellExecutor, tempFolderFactory);
        this.packageId = "com.twosigma.beaker.kotlin.bkr" + this.shellId.split("-")[0];
        this.cps = new ClasspathScanner();
        this.workerThread = new KotlinWorkerThread(this);
        this.workerThread.start();
    }

    protected void doResetEnvironment() {
        String cpp = this.createClasspath(this.classPath, this.outDir);
        this.cps = new ClasspathScanner(cpp);
        this.workerThread.updateLoader();
        this.workerThread.halt();
    }

    public void exit() {
        super.exit();
        this.workerThread.doExit();
        this.cancelExecution();
        this.workerThread.halt();
    }

    public void evaluate(SimpleEvaluationObject seo, String code) {
        this.workerThread.add(new JobDescriptor(code, seo));
    }

    public AutocompleteResult autocomplete(String code, int caretPosition) {
        ArrayList ret = new ArrayList();
        return new AutocompleteResult(ret, -1);
    }

    private String createClasspath(Classpath classPath, String outDir) {
        String cpp = "";
        for (String pt : classPath.getPathsAsStrings()) {
            cpp = cpp + pt;
            cpp = cpp + File.pathSeparator;
        }
        cpp = cpp + File.pathSeparator;
        cpp = cpp + outDir;
        cpp = cpp + File.pathSeparator;
        cpp = cpp + System.getProperty("java.class.path");
        return cpp;
    }

    public String getPackageId() {
        return this.packageId;
    }
}

