/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceProviderBean;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.impl.source.resolve.reference.ProviderBinding;
import com.intellij.psi.impl.source.resolve.reference.PsiReferenceRegistrarImpl;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferenceProvidersRegistryImpl
extends ReferenceProvidersRegistry {
    private static final LanguageExtension<PsiReferenceContributor> CONTRIBUTOR_EXTENSION = new LanguageExtension(PsiReferenceContributor.EP_NAME.getName());
    private static final LanguageExtension<PsiReferenceProviderBean> REFERENCE_PROVIDER_EXTENSION = new LanguageExtension(PsiReferenceProviderBean.EP_NAME.getName());
    private final Map<Language, PsiReferenceRegistrarImpl> myRegistrars = ContainerUtil.newConcurrentMap();

    @NotNull
    private static PsiReferenceRegistrarImpl createRegistrar(Language language) {
        PsiReferenceRegistrarImpl registrar = new PsiReferenceRegistrarImpl(language);
        for (PsiReferenceContributor contributor : CONTRIBUTOR_EXTENSION.allForLanguage(language)) {
            contributor.registerReferenceProviders(registrar);
        }
        List<PsiReferenceProviderBean> referenceProviderBeans = REFERENCE_PROVIDER_EXTENSION.allForLanguage(language);
        for (final PsiReferenceProviderBean providerBean : referenceProviderBeans) {
            ElementPattern<PsiElement> pattern = providerBean.createElementPattern();
            if (pattern == null) continue;
            registrar.registerReferenceProvider(pattern, new PsiReferenceProvider(){
                PsiReferenceProvider myProvider;

                @Override
                @NotNull
                public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl$1", "getReferencesByElement"));
                    }
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl$1", "getReferencesByElement"));
                    }
                    if (this.myProvider == null) {
                        this.myProvider = providerBean.instantiate();
                        if (this.myProvider == null) {
                            this.myProvider = ReferenceProvidersRegistry.NULL_REFERENCE_PROVIDER;
                        }
                    }
                    PsiReference[] psiReferenceArray = this.myProvider.getReferencesByElement(element, context);
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl$1", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
            });
        }
        registrar.markInitialized();
        PsiReferenceRegistrarImpl psiReferenceRegistrarImpl = registrar;
        if (psiReferenceRegistrarImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl", "createRegistrar"));
        }
        return psiReferenceRegistrarImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public PsiReferenceRegistrarImpl getRegistrar(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl", "getRegistrar"));
        }
        PsiReferenceRegistrarImpl registrar = this.myRegistrars.get(language);
        if (registrar == null) {
            ReferenceProvidersRegistryImpl referenceProvidersRegistryImpl = this;
            synchronized (referenceProvidersRegistryImpl) {
                registrar = this.myRegistrars.get(language);
                if (registrar == null) {
                    registrar = ReferenceProvidersRegistryImpl.createRegistrar(language);
                    this.myRegistrars.put(language, registrar);
                }
            }
        }
        PsiReferenceRegistrarImpl psiReferenceRegistrarImpl = registrar;
        if (psiReferenceRegistrarImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl", "getRegistrar"));
        }
        return psiReferenceRegistrarImpl;
    }

    @Override
    @NotNull
    protected PsiReference[] doGetReferencesFromProviders(@NotNull PsiElement context, @NotNull PsiReferenceService.Hints hints) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl", "doGetReferencesFromProviders"));
        }
        if (hints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hints", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl", "doGetReferencesFromProviders"));
        }
        List<ProviderBinding.ProviderInfo<ProcessingContext>> providers = this.getRegistrar(context.getLanguage()).getPairsByElement(context, hints);
        MultiMap<Double, PsiReference[]> allReferencesMap = ReferenceProvidersRegistryImpl.mapNotEmptyReferencesFromProviders(context, providers);
        if (allReferencesMap.isEmpty()) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl", "doGetReferencesFromProviders"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        List<PsiReference> result2 = ContainerUtil.newSmartList();
        double maxPriority = ReferenceProvidersRegistryImpl.getMaxPriority(allReferencesMap.keySet());
        List<PsiReference> maxPriorityRefs = ReferenceProvidersRegistryImpl.collectReferences(allReferencesMap.get(maxPriority));
        ContainerUtil.addAllNotNull(result2, maxPriorityRefs);
        ContainerUtil.addAllNotNull(result2, ReferenceProvidersRegistryImpl.getLowerPriorityReferences(allReferencesMap, maxPriority, maxPriorityRefs));
        PsiReference[] psiReferenceArray = result2.toArray(new PsiReference[result2.size()]);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl", "doGetReferencesFromProviders"));
        }
        return psiReferenceArray;
    }

    @NotNull
    private static MultiMap<Double, PsiReference[]> mapNotEmptyReferencesFromProviders(@NotNull PsiElement context, @NotNull List<ProviderBinding.ProviderInfo<ProcessingContext>> providers) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl", "mapNotEmptyReferencesFromProviders"));
        }
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl", "mapNotEmptyReferencesFromProviders"));
        }
        MultiMap<Double, PsiReference[]> map2 = new MultiMap<Double, PsiReference[]>();
        for (ProviderBinding.ProviderInfo<ProcessingContext> trinity : providers) {
            PsiReference[] refs = ReferenceProvidersRegistryImpl.getReferences(context, trinity);
            if (refs.length <= 0) continue;
            map2.putValue(trinity.priority, refs);
        }
        MultiMap<Double, PsiReference[]> multiMap = map2;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl", "mapNotEmptyReferencesFromProviders"));
        }
        return multiMap;
    }

    @NotNull
    private static PsiReference[] getReferences(@NotNull PsiElement context, @NotNull ProviderBinding.ProviderInfo<ProcessingContext> providerInfo) {
        PsiReference[] psiReferenceArray;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl", "getReferences"));
        }
        if (providerInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providerInfo", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl", "getReferences"));
        }
        try {
            psiReferenceArray = providerInfo.provider.getReferencesByElement(context, (ProcessingContext)providerInfo.processingContext);
        }
        catch (IndexNotReadyException indexNotReadyException) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl", "getReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static List<PsiReference> getLowerPriorityReferences(@NotNull MultiMap<Double, PsiReference[]> allReferencesMap, double maxPriority, @NotNull List<PsiReference> list2) {
        if (allReferencesMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allReferencesMap", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl", "getLowerPriorityReferences"));
        }
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maxPriorityRefs", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl", "getLowerPriorityReferences"));
        }
        List<PsiReference> result2 = ContainerUtil.newSmartList();
        for (Map.Entry<Double, Collection<PsiReference[]>> entry : allReferencesMap.entrySet()) {
            if (maxPriority == entry.getKey()) continue;
            for (PsiReference[] references : entry.getValue()) {
                void maxPriorityRefs;
                if (!ReferenceProvidersRegistryImpl.haveNotIntersectedTextRanges((List<PsiReference>)maxPriorityRefs, references)) continue;
                ContainerUtil.addAllNotNull(result2, references);
            }
        }
        List<PsiReference> list3 = result2;
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl", "getLowerPriorityReferences"));
        }
        return list3;
    }

    private static boolean haveNotIntersectedTextRanges(@NotNull List<PsiReference> higherPriorityRefs, @NotNull PsiReference[] lowerPriorityRefs) {
        if (higherPriorityRefs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "higherPriorityRefs", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl", "haveNotIntersectedTextRanges"));
        }
        if (lowerPriorityRefs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lowerPriorityRefs", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl", "haveNotIntersectedTextRanges"));
        }
        for (PsiReference ref : lowerPriorityRefs) {
            if (ref == null) continue;
            for (PsiReference reference : higherPriorityRefs) {
                if (reference == null || !ReferenceRange.containsRangeInElement(reference, ref.getRangeInElement())) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private static List<PsiReference> collectReferences(@Nullable Collection<PsiReference[]> references) {
        if (references == null) {
            List<PsiReference> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl", "collectReferences"));
            }
            return list2;
        }
        List<PsiReference> list3 = ContainerUtil.newSmartList();
        for (PsiReference[] reference : references) {
            ContainerUtil.addAllNotNull(list3, reference);
        }
        List<PsiReference> list4 = list3;
        if (list4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl", "collectReferences"));
        }
        return list4;
    }

    private static double getMaxPriority(@NotNull Set<Double> doubles) {
        if (doubles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doubles", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl", "getMaxPriority"));
        }
        double maxPriority = -100.0;
        for (Double aDouble : doubles) {
            if (!(aDouble > maxPriority)) continue;
            maxPriority = aDouble;
        }
        return maxPriority;
    }
}

