/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.javash.evaluator;

import com.twosigma.beakerx.javash.evaluator.CompilationException;
import java.util.ArrayList;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;
import org.abstractmeta.toolbox.compilation.compiler.impl.JavaSourceCompilerImpl;
import org.abstractmeta.toolbox.compilation.compiler.impl.JavaSourceFileObject;
import org.abstractmeta.toolbox.compilation.compiler.registry.JavaFileObjectRegistry;

public class JavaSourceCompiler
extends JavaSourceCompilerImpl {
    private static final char POSITION_CHARACTER = '^';

    @Override
    protected boolean buildDiagnosticMessage(Diagnostic diagnostic, StringBuilder diagnosticBuilder, JavaFileObjectRegistry registry) {
        diagnosticBuilder.append(diagnostic.getMessage(null));
        diagnosticBuilder.append("\n");
        diagnosticBuilder.append(this.getErrorDetails(diagnostic));
        return diagnostic.getKind().equals((Object)Diagnostic.Kind.ERROR);
    }

    @Override
    protected IllegalStateException createCompilationErrorException(JavaFileObjectRegistry registry, DiagnosticCollector<JavaFileObject> diagnostics) {
        ArrayList<CompilationException.CompilationError> compilationErrors = new ArrayList<CompilationException.CompilationError>();
        for (Diagnostic<JavaFileObject> diagnostic : diagnostics.getDiagnostics()) {
            compilationErrors.add(new CompilationException.CompilationError((int)diagnostic.getLineNumber(), diagnostic.getMessage(null), this.getErrorDetails(diagnostic)));
        }
        return new CompilationException(String.format("%d compilation error(s)\n", compilationErrors.size()), compilationErrors);
    }

    private String getErrorDetails(Diagnostic diagnostic) {
        String sourceErrorDetails = "";
        CharSequence sourceCode = this.getSourceContent(diagnostic);
        if (sourceCode != null) {
            String source = sourceCode.toString();
            int startPosition = (int)diagnostic.getStartPosition();
            int endPosition = (int)diagnostic.getEndPosition();
            if (endPosition < 0 && startPosition < 0) {
                return "";
            }
            if (startPosition < 0) {
                startPosition = endPosition;
            } else if (endPosition < 0) {
                endPosition = startPosition;
            }
            int snippetStart = this.getSnippetStart(source, startPosition);
            int snippetEnd = this.getSnippetEnd(source, endPosition);
            String errorLine = source.substring(snippetStart, snippetEnd).replaceAll("\n", " ");
            StringBuilder signStringBuilder = this.getSpacesStringBuilder(errorLine.length());
            signStringBuilder.insert(startPosition -= snippetStart, '^');
            if (startPosition != (endPosition -= snippetStart)) {
                signStringBuilder.insert(endPosition, '^');
            }
            sourceErrorDetails = errorLine + "\n" + signStringBuilder.toString() + "\n\n";
        }
        return sourceErrorDetails;
    }

    private int getSnippetEnd(String source, int endPosition) {
        int lineEndPosition = this.getPositive(source.indexOf(10, endPosition));
        int nextSemicolonPosition = this.getPositive(source.indexOf(59, endPosition));
        return Math.min(Math.min(lineEndPosition, nextSemicolonPosition), Math.min(source.length(), endPosition + 30));
    }

    private int getSnippetStart(String source, int startPosition) {
        startPosition = Math.abs(startPosition - 1);
        int lineStartPosition = source.lastIndexOf(10, startPosition);
        int previousSemicolonPosition = source.lastIndexOf(59, startPosition) + 1;
        return Math.max(Math.max(lineStartPosition, previousSemicolonPosition), Math.abs(startPosition - 30));
    }

    private StringBuilder getSpacesStringBuilder(int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(' ');
        }
        return builder;
    }

    private CharSequence getSourceContent(Diagnostic diagnostic) {
        CharSequence sourceContent = null;
        Object source = diagnostic.getSource();
        if (source != null) {
            JavaSourceFileObject sourceFile = (JavaSourceFileObject)JavaSourceFileObject.class.cast(source);
            sourceContent = sourceFile.getCharContent(true);
        }
        return sourceContent;
    }

    private int getPositive(int number) {
        return number >= 0 ? number : Integer.MAX_VALUE;
    }
}

