/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kotlin.evaluator;

import com.google.common.base.Preconditions;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.InternalVariable;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class KotlinCodeRunner<T>
implements Runnable {
    private final SimpleEvaluationObject theOutput;
    private final T instance;
    private final Method theMth;
    private final ClassLoader loader;

    public KotlinCodeRunner(T instance, Method mth, SimpleEvaluationObject out, ClassLoader ld) {
        this.instance = instance;
        this.theMth = mth;
        this.theOutput = (SimpleEvaluationObject)Preconditions.checkNotNull((Object)out);
        this.loader = ld;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ClassLoader oldld = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.loader);
        this.theOutput.setOutputHandler();
        InternalVariable.setValue((SimpleEvaluationObject)this.theOutput);
        try {
            InternalVariable.setValue((SimpleEvaluationObject)this.theOutput);
            Object o = this.theMth.invoke(this.instance, (Object[])null);
            this.theOutput.finished(this.calculateResult(o));
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            if (e instanceof InterruptedException || e instanceof ThreadDeath) {
                this.theOutput.error((Object)BaseEvaluator.INTERUPTED_MSG);
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                this.theOutput.error((Object)sw.toString());
            }
        }
        finally {
            this.theOutput.executeCodeCallback();
        }
        this.theOutput.clrOutputHandler();
        Thread.currentThread().setContextClassLoader(oldld);
    }

    private Object calculateResult(Object o) {
        if (o != null && o.toString().equals("kotlin.Unit")) {
            return null;
        }
        return o;
    }
}

