/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Sets;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastManager;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastResult;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingFacade;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public class DataFlowAnalyzer {
    private final Iterable<AdditionalTypeChecker> additionalTypeCheckers;
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    private final KotlinBuiltIns builtIns;
    private final SmartCastManager smartCastManager;
    private final ExpressionTypingFacade facade;
    private final LanguageVersionSettings languageVersionSettings;

    public DataFlowAnalyzer(@NotNull Iterable<AdditionalTypeChecker> additionalTypeCheckers, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull KotlinBuiltIns builtIns, @NotNull SmartCastManager smartCastManager, @NotNull ExpressionTypingFacade facade, @NotNull LanguageVersionSettings languageVersionSettings) {
        if (additionalTypeCheckers == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(0);
        }
        if (constantExpressionEvaluator == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(1);
        }
        if (builtIns == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(2);
        }
        if (smartCastManager == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(3);
        }
        if (facade == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(4);
        }
        if (languageVersionSettings == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(5);
        }
        this.additionalTypeCheckers = additionalTypeCheckers;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.builtIns = builtIns;
        this.smartCastManager = smartCastManager;
        this.facade = facade;
        this.languageVersionSettings = languageVersionSettings;
    }

    @Nullable
    private static FunctionDescriptor getOverriddenDescriptorFromClass(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(6);
        }
        if (descriptor2.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            return descriptor2;
        }
        Collection<? extends FunctionDescriptor> overriddenDescriptors = descriptor2.getOverriddenDescriptors();
        if (overriddenDescriptors.isEmpty()) {
            return descriptor2;
        }
        for (FunctionDescriptor functionDescriptor : overriddenDescriptors) {
            DeclarationDescriptor containingDeclaration = functionDescriptor.getContainingDeclaration();
            if (!DescriptorUtils.isClass(containingDeclaration) && !DescriptorUtils.isObject(containingDeclaration)) continue;
            return DataFlowAnalyzer.getOverriddenDescriptorFromClass(functionDescriptor);
        }
        return null;
    }

    private static boolean typeHasOverriddenEquals(@NotNull KotlinType type2, @NotNull KtElement lookupElement) {
        if (type2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(7);
        }
        if (lookupElement == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(8);
        }
        Collection<SimpleFunctionDescriptor> members2 = type2.getMemberScope().getContributedFunctions(OperatorNameConventions.EQUALS, new KotlinLookupLocation(lookupElement));
        for (FunctionDescriptor functionDescriptor : members2) {
            KotlinType parameterType;
            KotlinType returnType = functionDescriptor.getReturnType();
            if (returnType == null || !KotlinBuiltIns.isBoolean(returnType) || functionDescriptor.getValueParameters().size() != 1 || !KotlinBuiltIns.isNullableAny(parameterType = functionDescriptor.getValueParameters().iterator().next().getType())) continue;
            FunctionDescriptor fromSuperClass = DataFlowAnalyzer.getOverriddenDescriptorFromClass(functionDescriptor);
            if (fromSuperClass == null) {
                return false;
            }
            ClassifierDescriptor superClassDescriptor = (ClassifierDescriptor)fromSuperClass.getContainingDeclaration();
            return !KotlinBuiltIns.isAnyOrNullableAny(superClassDescriptor.getDefaultType());
        }
        return false;
    }

    public static boolean typeHasEqualsFromAny(@NotNull KotlinType type2, @NotNull KtElement lookupElement) {
        TypeConstructor constructor;
        if (type2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(9);
        }
        if (lookupElement == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(10);
        }
        if (!(constructor = type2.getConstructor()).isFinal()) {
            return false;
        }
        return !DataFlowAnalyzer.typeHasOverriddenEquals(type2, lookupElement);
    }

    @NotNull
    public DataFlowInfo extractDataFlowInfoFromCondition(final @Nullable KtExpression condition, final boolean conditionValue, final ExpressionTypingContext context) {
        if (condition == null) {
            DataFlowInfo dataFlowInfo = context.dataFlowInfo;
            if (dataFlowInfo == null) {
                DataFlowAnalyzer.$$$reportNull$$$0(11);
            }
            return dataFlowInfo;
        }
        final Ref<Object> result2 = new Ref<Object>(null);
        condition.accept(new KtVisitorVoid(){

            @Override
            public void visitIsExpression(@NotNull KtIsExpression expression2) {
                if (expression2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (conditionValue && !expression2.isNegated() || !conditionValue && expression2.isNegated()) {
                    result2.set(context.trace.get(BindingContext.DATAFLOW_INFO_AFTER_CONDITION, expression2));
                }
            }

            @Override
            public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
                IElementType operationToken;
                if (expression2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (OperatorConventions.BOOLEAN_OPERATIONS.containsKey(operationToken = expression2.getOperationToken())) {
                    DataFlowInfo dataFlowInfo = DataFlowAnalyzer.this.extractDataFlowInfoFromCondition(expression2.getLeft(), conditionValue, context);
                    KtExpression expressionRight = expression2.getRight();
                    if (expressionRight != null) {
                        boolean and = operationToken == KtTokens.ANDAND;
                        DataFlowInfo rightInfo = DataFlowAnalyzer.this.extractDataFlowInfoFromCondition(expressionRight, conditionValue, and == conditionValue ? (ExpressionTypingContext)context.replaceDataFlowInfo(dataFlowInfo) : context);
                        dataFlowInfo = and == conditionValue ? dataFlowInfo.and(rightInfo) : dataFlowInfo.or(rightInfo);
                    }
                    result2.set(dataFlowInfo);
                } else {
                    DataFlowInfo expressionFlowInfo = DataFlowAnalyzer.this.facade.getTypeInfo(expression2, context).getDataFlowInfo();
                    KtExpression left = expression2.getLeft();
                    if (left == null) {
                        return;
                    }
                    KtExpression right = expression2.getRight();
                    if (right == null) {
                        return;
                    }
                    KotlinType lhsType = context.trace.getBindingContext().getType(left);
                    if (lhsType == null) {
                        return;
                    }
                    KotlinType rhsType = context.trace.getBindingContext().getType(right);
                    if (rhsType == null) {
                        return;
                    }
                    DataFlowValue leftValue = DataFlowValueFactory.createDataFlowValue(left, lhsType, context);
                    DataFlowValue rightValue = DataFlowValueFactory.createDataFlowValue(right, rhsType, context);
                    Boolean equals = null;
                    if (operationToken == KtTokens.EQEQ || operationToken == KtTokens.EQEQEQ) {
                        equals = true;
                    } else if (operationToken == KtTokens.EXCLEQ || operationToken == KtTokens.EXCLEQEQEQ) {
                        equals = false;
                    }
                    if (equals != null) {
                        if (equals == conditionValue) {
                            boolean identityEquals = operationToken == KtTokens.EQEQEQ || operationToken == KtTokens.EXCLEQEQEQ || DataFlowAnalyzer.typeHasEqualsFromAny(lhsType, condition);
                            result2.set(context.dataFlowInfo.equate(leftValue, rightValue, identityEquals, DataFlowAnalyzer.this.languageVersionSettings).and(expressionFlowInfo));
                        } else {
                            result2.set(context.dataFlowInfo.disequate(leftValue, rightValue, DataFlowAnalyzer.this.languageVersionSettings).and(expressionFlowInfo));
                        }
                    } else {
                        result2.set(expressionFlowInfo);
                    }
                }
            }

            @Override
            public void visitUnaryExpression(@NotNull KtUnaryExpression expression2) {
                IElementType operationTokenType;
                if (expression2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((operationTokenType = expression2.getOperationReference().getReferencedNameElementType()) == KtTokens.EXCL) {
                    KtExpression baseExpression = expression2.getBaseExpression();
                    if (baseExpression != null) {
                        result2.set(DataFlowAnalyzer.this.extractDataFlowInfoFromCondition(baseExpression, !conditionValue, context));
                    }
                } else {
                    this.visitExpression(expression2);
                }
            }

            @Override
            public void visitExpression(@NotNull KtExpression expression2) {
                if (expression2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                result2.set(DataFlowAnalyzer.this.facade.getTypeInfo(expression2, context).getDataFlowInfo());
            }

            @Override
            public void visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2) {
                KtExpression body;
                if (expression2 == null) {
                    1.$$$reportNull$$$0(4);
                }
                if ((body = expression2.getExpression()) != null) {
                    body.accept(this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "expression";
                objectArray2[1] = "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitIsExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitBinaryExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitUnaryExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitExpression";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitParenthesizedExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (result2.get() == null) {
            DataFlowInfo dataFlowInfo = context.dataFlowInfo;
            if (dataFlowInfo == null) {
                DataFlowAnalyzer.$$$reportNull$$$0(12);
            }
            return dataFlowInfo;
        }
        DataFlowInfo dataFlowInfo = context.dataFlowInfo.and(result2.get());
        if (dataFlowInfo == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(13);
        }
        return dataFlowInfo;
    }

    @Nullable
    public KotlinType checkType(@Nullable KotlinType expressionType, @NotNull KtExpression expression2, @NotNull ResolutionContext context) {
        if (expression2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(14);
        }
        if (context == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(15);
        }
        return this.checkType(expressionType, expression2, context, null);
    }

    @NotNull
    public KotlinTypeInfo checkType(@NotNull KotlinTypeInfo typeInfo, @NotNull KtExpression expression2, @NotNull ResolutionContext context) {
        if (typeInfo == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(16);
        }
        if (expression2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(17);
        }
        if (context == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(18);
        }
        KotlinTypeInfo kotlinTypeInfo = typeInfo.replaceType(this.checkType(typeInfo.getType(), expression2, context));
        if (kotlinTypeInfo == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(19);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    private KotlinType checkTypeInternal(@NotNull KotlinType expressionType, @NotNull KtExpression expression2, @NotNull ResolutionContext c, @NotNull Ref<Boolean> hasError) {
        if (expressionType == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(20);
        }
        if (expression2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(21);
        }
        if (c == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(22);
        }
        if (hasError == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(23);
        }
        if (TypeUtils.noExpectedType(c.expectedType) || !c.expectedType.getConstructor().isDenotable() || KotlinTypeChecker.DEFAULT.isSubtypeOf(expressionType, c.expectedType)) {
            KotlinType kotlinType = expressionType;
            if (kotlinType == null) {
                DataFlowAnalyzer.$$$reportNull$$$0(24);
            }
            return kotlinType;
        }
        if (expression2 instanceof KtConstantExpression) {
            ConstantValue<?> constantValue = this.constantExpressionEvaluator.evaluateToConstantValue(expression2, c.trace, c.expectedType);
            boolean error = new CompileTimeConstantChecker(c, this.builtIns, true).checkConstantExpressionType(constantValue, (KtConstantExpression)expression2, c.expectedType);
            hasError.set(error);
            KotlinType kotlinType = expressionType;
            if (kotlinType == null) {
                DataFlowAnalyzer.$$$reportNull$$$0(25);
            }
            return kotlinType;
        }
        if (expression2 instanceof KtWhenExpression) {
            KotlinType kotlinType = expressionType;
            if (kotlinType == null) {
                DataFlowAnalyzer.$$$reportNull$$$0(26);
            }
            return kotlinType;
        }
        SmartCastResult castResult = DataFlowAnalyzer.checkPossibleCast(expressionType, expression2, c);
        if (castResult != null) {
            KotlinType kotlinType = castResult.getResultType();
            if (kotlinType == null) {
                DataFlowAnalyzer.$$$reportNull$$$0(27);
            }
            return kotlinType;
        }
        if (!DiagnosticUtilsKt.reportTypeMismatchDueToTypeProjection(c, expression2, c.expectedType, expressionType) && !DiagnosticUtilsKt.reportTypeMismatchDueToScalaLikeNamedFunctionSyntax(c, expression2, c.expectedType, expressionType)) {
            c.trace.report(Errors.TYPE_MISMATCH.on(expression2, c.expectedType, expressionType));
        }
        hasError.set(true);
        KotlinType kotlinType = expressionType;
        if (kotlinType == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(28);
        }
        return kotlinType;
    }

    @Nullable
    public KotlinType checkType(@Nullable KotlinType expressionType, @NotNull KtExpression expressionToCheck, @NotNull ResolutionContext c, @Nullable Ref<Boolean> hasError) {
        if (expressionToCheck == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(29);
        }
        if (c == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(30);
        }
        if (hasError == null) {
            hasError = Ref.create(false);
        } else {
            hasError.set(false);
        }
        KtExpression expression2 = KtPsiUtil.safeDeparenthesize(expressionToCheck);
        this.recordExpectedType(c.trace, expression2, c.expectedType);
        if (expressionType == null) {
            return null;
        }
        KotlinType result2 = this.checkTypeInternal(expressionType, expression2, c, hasError);
        if (Boolean.FALSE.equals(hasError.get())) {
            for (AdditionalTypeChecker checker : this.additionalTypeCheckers) {
                checker.checkType(expression2, expressionType, result2, c);
            }
        }
        return result2;
    }

    @Nullable
    public static SmartCastResult checkPossibleCast(@NotNull KotlinType expressionType, @NotNull KtExpression expression2, @NotNull ResolutionContext c) {
        if (expressionType == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(31);
        }
        if (expression2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(32);
        }
        if (c == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(33);
        }
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(expression2, expressionType, c);
        return SmartCastManager.Companion.checkAndRecordPossibleCast(dataFlowValue, c.expectedType, expression2, c, null, false);
    }

    public void recordExpectedType(@NotNull BindingTrace trace, @NotNull KtExpression expression2, @NotNull KotlinType expectedType) {
        if (trace == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(34);
        }
        if (expression2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(35);
        }
        if (expectedType == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(36);
        }
        if (expectedType != TypeUtils.NO_EXPECTED_TYPE) {
            KotlinType normalizeExpectedType = expectedType == TypeUtils.UNIT_EXPECTED_TYPE ? this.builtIns.getUnitType() : expectedType;
            trace.record(BindingContext.EXPECTED_EXPRESSION_TYPE, expression2, normalizeExpectedType);
        }
    }

    @Nullable
    public KotlinType checkStatementType(@NotNull KtExpression expression2, @NotNull ResolutionContext context) {
        if (expression2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(37);
        }
        if (context == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(38);
        }
        if (!(TypeUtils.noExpectedType(context.expectedType) || KotlinBuiltIns.isUnit(context.expectedType) || KotlinTypeKt.isError(context.expectedType))) {
            context.trace.report(Errors.EXPECTED_TYPE_MISMATCH.on(expression2, context.expectedType));
            return null;
        }
        return this.builtIns.getUnitType();
    }

    @NotNull
    public static KotlinTypeInfo illegalStatementType(@NotNull KtExpression expression2, @NotNull ExpressionTypingContext context, @NotNull ExpressionTypingInternals facade) {
        if (expression2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(39);
        }
        if (context == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(40);
        }
        if (facade == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(41);
        }
        facade.checkStatementType(expression2, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT));
        context.trace.report(Errors.EXPRESSION_EXPECTED.on(expression2, expression2));
        KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        if (kotlinTypeInfo == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(42);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    public static Collection<KotlinType> getAllPossibleTypes(@NotNull KtExpression expression2, @NotNull KotlinType type2, @NotNull ResolutionContext c) {
        if (expression2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(43);
        }
        if (type2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(44);
        }
        if (c == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(45);
        }
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(expression2, type2, c);
        HashSet<KotlinType> possibleTypes = Sets.newHashSet(type2);
        possibleTypes.addAll(c.dataFlowInfo.getStableTypes(dataFlowValue));
        HashSet<KotlinType> hashSet = possibleTypes;
        if (hashSet == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(46);
        }
        return hashSet;
    }

    @NotNull
    public KotlinTypeInfo createCheckedTypeInfo(@Nullable KotlinType type2, @NotNull ResolutionContext<?> context, @NotNull KtExpression expression2) {
        if (context == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(47);
        }
        if (expression2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(48);
        }
        KotlinTypeInfo kotlinTypeInfo = this.checkType(TypeInfoFactoryKt.createTypeInfo(type2, context), expression2, context);
        if (kotlinTypeInfo == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(49);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    public KotlinTypeInfo createCompileTimeConstantTypeInfo(@NotNull CompileTimeConstant<?> value, @NotNull KtExpression expression2, @NotNull ExpressionTypingContext context) {
        KotlinType expressionType;
        if (value == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(50);
        }
        if (expression2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(51);
        }
        if (context == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(52);
        }
        if (value instanceof IntegerValueTypeConstant) {
            IntegerValueTypeConstant integerValueTypeConstant = (IntegerValueTypeConstant)value;
            if (context.contextDependency == ContextDependency.INDEPENDENT) {
                expressionType = integerValueTypeConstant.getType(context.expectedType);
                this.constantExpressionEvaluator.updateNumberType(expressionType, expression2, context.statementFilter, context.trace);
            } else {
                expressionType = integerValueTypeConstant.getUnknownIntegerType();
            }
        } else {
            expressionType = ((TypedCompileTimeConstant)value).getType();
        }
        KotlinTypeInfo kotlinTypeInfo = this.createCheckedTypeInfo(expressionType, context, expression2);
        if (kotlinTypeInfo == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(53);
        }
        return kotlinTypeInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 42: 
            case 46: 
            case 49: 
            case 53: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 42: 
            case 46: 
            case 49: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalTypeCheckers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constantExpressionEvaluator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtIns";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smartCastManager";
                break;
            }
            case 4: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageVersionSettings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: 
            case 9: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupElement";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 42: 
            case 46: 
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer";
                break;
            }
            case 14: 
            case 17: 
            case 21: 
            case 32: 
            case 35: 
            case 37: 
            case 39: 
            case 43: 
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 15: 
            case 18: 
            case 38: 
            case 40: 
            case 47: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeInfo";
                break;
            }
            case 20: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionType";
                break;
            }
            case 22: 
            case 30: 
            case 33: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hasError";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionToCheck";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "extractDataFlowInfoFromCondition";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "checkType";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "checkTypeInternal";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "illegalStatementType";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPossibleTypes";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "createCheckedTypeInfo";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompileTimeConstantTypeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOverriddenDescriptorFromClass";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "typeHasOverriddenEquals";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "typeHasEqualsFromAny";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 42: 
            case 46: 
            case 49: 
            case 53: {
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "checkType";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkTypeInternal";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "checkPossibleCast";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "recordExpectedType";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "checkStatementType";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "illegalStatementType";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getAllPossibleTypes";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createCheckedTypeInfo";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createCompileTimeConstantTypeInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 42: 
            case 46: 
            case 49: 
            case 53: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

