/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.addRemoveModifier.AddRemoveModifierKt;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtPlaceHolderStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\b\u0016\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J=\u0010\b\u001a\n \n*\u0004\u0018\u0001H\tH\t\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\u000b0\r2\u0006\u0010\u000e\u001a\u0002H\u000bH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "Lorg/jetbrains/kotlin/psi/KtConstructor;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "stub", "Lorg/jetbrains/kotlin/psi/stubs/KotlinPlaceHolderStub;", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinPlaceHolderStub;)V", "accept", "R", "kotlin.jvm.PlatformType", "D", "visitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "data", "(Lorg/jetbrains/kotlin/psi/KtVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "addAnnotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "annotationEntry", "addModifier", "", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "getContainingClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getOrCreateConstructorKeyword", "Lcom/intellij/psi/PsiElement;", "removeModifier", "kotlin-compiler"})
public final class KtPrimaryConstructor
extends KtConstructor<KtPrimaryConstructor> {
    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
        return visitor2.visitPrimaryConstructor(this, data2);
    }

    @Override
    @NotNull
    public KtClassOrObject getContainingClassOrObject() {
        PsiElement psiElement = this.getParent();
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
        }
        return (KtClassOrObject)psiElement;
    }

    private final PsiElement getOrCreateConstructorKeyword() {
        PsiElement psiElement = this.getConstructorKeyword();
        if (psiElement == null) {
            PsiElement psiElement2 = KtPsiFactoryKt.KtPsiFactory$default(this, false, 2, null).createConstructorKeyword();
            KtParameterList ktParameterList = this.getValueParameterList();
            if (ktParameterList == null) {
                Intrinsics.throwNpe();
            }
            PsiElement psiElement3 = this.addBefore(psiElement2, ktParameterList);
            psiElement = psiElement3;
            Intrinsics.checkExpressionValueIsNotNull(psiElement3, "addBefore(KtPsiFactory(t\u2026(), valueParameterList!!)");
        }
        return psiElement;
    }

    @Override
    public void addModifier(@NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkParameterIsNotNull(modifier, "modifier");
        KtModifierList modifierList = this.getModifierList();
        if (modifierList != null) {
            AddRemoveModifierKt.addModifier(modifierList, modifier);
            if (this.getModifierList() == null) {
                PsiElement psiElement = this.getConstructorKeyword();
                if (psiElement != null) {
                    psiElement.delete();
                }
            }
        } else {
            if (Intrinsics.areEqual(modifier, KtTokens.PUBLIC_KEYWORD)) {
                return;
            }
            KtModifierList newModifierList = KtPsiFactoryKt.KtPsiFactory$default(this, false, 2, null).createModifierList(modifier);
            this.addBefore(newModifierList, this.getOrCreateConstructorKeyword());
        }
    }

    @Override
    public void removeModifier(@NotNull KtModifierKeywordToken modifier) {
        block1: {
            Intrinsics.checkParameterIsNotNull(modifier, "modifier");
            super.removeModifier(modifier);
            if (this.getModifierList() != null) break block1;
            PsiElement psiElement = this.getConstructorKeyword();
            if (psiElement != null) {
                psiElement.delete();
            }
        }
    }

    @Override
    @NotNull
    public KtAnnotationEntry addAnnotationEntry(@NotNull KtAnnotationEntry annotationEntry) {
        KtAnnotationEntry ktAnnotationEntry;
        Intrinsics.checkParameterIsNotNull(annotationEntry, "annotationEntry");
        KtModifierList modifierList = this.getModifierList();
        if (modifierList != null) {
            PsiElement psiElement = modifierList.addBefore(annotationEntry, modifierList.getFirstChild());
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnnotationEntry");
            }
            ktAnnotationEntry = (KtAnnotationEntry)psiElement;
        } else {
            KtParameterList ktParameterList = this.getValueParameterList();
            if (ktParameterList == null) {
                Intrinsics.throwNpe();
            }
            KtParameterList parameterList = ktParameterList;
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull(project, "project");
            KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
            String string = annotationEntry.getText();
            Intrinsics.checkExpressionValueIsNotNull(string, "annotationEntry.text");
            KtModifierList newModifierList = ktPsiFactory.createModifierList(string);
            PsiElement psiElement = this.addBefore(newModifierList, parameterList);
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtModifierList");
            }
            KtAnnotationEntry ktAnnotationEntry2 = CollectionsKt.first(((KtModifierList)psiElement).getAnnotationEntries());
            Intrinsics.checkExpressionValueIsNotNull(ktAnnotationEntry2, "(addBefore(newModifierLi\u2026annotationEntries.first()");
            ktAnnotationEntry = ktAnnotationEntry2;
        }
        return ktAnnotationEntry;
    }

    public KtPrimaryConstructor(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        super(node);
    }

    public KtPrimaryConstructor(@NotNull KotlinPlaceHolderStub<KtPrimaryConstructor> stub) {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        KtPlaceHolderStubElementType<KtPrimaryConstructor> ktPlaceHolderStubElementType = KtStubElementTypes.PRIMARY_CONSTRUCTOR;
        Intrinsics.checkExpressionValueIsNotNull(ktPlaceHolderStubElementType, "KtStubElementTypes.PRIMARY_CONSTRUCTOR");
        super(stub, ktPlaceHolderStubElementType);
    }
}

