/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.lang.ref.SoftReference;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReflectProperties {
    @NotNull
    public static <T> LazyVal<T> lazy(@NotNull Function0<T> initializer2) {
        return new LazyVal<T>(initializer2);
    }

    @NotNull
    public static <T> LazySoftVal<T> lazySoft(@Nullable T initialValue, @NotNull Function0<T> initializer2) {
        return new LazySoftVal<T>(initialValue, initializer2);
    }

    @NotNull
    public static <T> LazySoftVal<T> lazySoft(@NotNull Function0<T> initializer2) {
        return ReflectProperties.lazySoft(null, initializer2);
    }

    public static class LazySoftVal<T>
    extends Val<T> {
        private final Function0<T> initializer;
        private SoftReference<Object> value = null;

        public LazySoftVal(@Nullable T initialValue, @NotNull Function0<T> initializer2) {
            this.initializer = initializer2;
            if (initialValue != null) {
                this.value = new SoftReference<Object>(this.escape(initialValue));
            }
        }

        @Override
        public T invoke() {
            Object result2;
            SoftReference<Object> cached = this.value;
            if (cached != null && (result2 = cached.get()) != null) {
                return this.unescape(result2);
            }
            result2 = this.initializer.invoke();
            this.value = new SoftReference<Object>(this.escape(result2));
            return (T)result2;
        }
    }

    public static class LazyVal<T>
    extends Val<T> {
        private final Function0<T> initializer;
        private Object value = null;

        public LazyVal(@NotNull Function0<T> initializer2) {
            this.initializer = initializer2;
        }

        @Override
        public T invoke() {
            Object cached = this.value;
            if (cached != null) {
                return this.unescape(cached);
            }
            T result2 = this.initializer.invoke();
            this.value = this.escape(result2);
            return result2;
        }
    }

    public static abstract class Val<T> {
        private static final Object NULL_VALUE = new Object(){};

        public final T getValue(Object instance, Object metadata2) {
            return this.invoke();
        }

        public abstract T invoke();

        protected Object escape(T value) {
            return value == null ? NULL_VALUE : value;
        }

        protected T unescape(Object value) {
            return (T)(value == NULL_VALUE ? null : value);
        }
    }
}

