/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.mimetype;

import com.twosigma.beakerx.mimetype.MIMEContainer;
import java.io.File;

public class FileLinkContainer
extends MIMEContainer {
    public FileLinkContainer(String mime, String code) {
        super(mime, code);
    }

    public static MIMEContainer FileLink(String filePath) {
        File f = new File(filePath);
        if (f.isDirectory()) {
            return FileLinkContainer.addMimeType("text/plain", "Cannot display a directory using FileLink.");
        }
        if (!f.exists()) {
            return FileLinkContainer.addMimeType("text/html", "Path (<tt>" + f.getAbsolutePath() + "</tt>) doesn't exist. " + "It may still be in the process of " + "being generated, or you may have the " + "incorrect path.");
        }
        String htmlLink = String.format("<a href='%1$s' target='_blank'>%1$s</a><br/>", filePath);
        return FileLinkContainer.addMimeType("text/html", htmlLink);
    }

    public static MIMEContainer FileLinks(String dirPath) {
        File f = new File(dirPath);
        String result = "";
        if (!f.isDirectory()) {
            return FileLinkContainer.addMimeType("text/plain", "Cannot display a file using FileLinks.\nUse FileLink to display " + dirPath);
        }
        return FileLinkContainer.addMimeType("text/html", FileLinkContainer.listFilesForFolder(f, result));
    }

    private static String listFilesForFolder(File folder, String result) {
        File[] fileList = folder.listFiles();
        if (fileList == null) {
            return null;
        }
        for (File fileEntry : fileList) {
            if (fileEntry.isDirectory()) {
                result = result + String.format("%1$s <br/>", fileEntry.getName());
                FileLinkContainer.listFilesForFolder(fileEntry, result);
                continue;
            }
            result = result + String.format("<a href='%1$s' target='_blank'>%1$s</a><br/>", fileEntry.getPath());
        }
        return result;
    }
}

