/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.easyform.formitem.widgets;

import com.twosigma.beakerx.easyform.EasyFormComponent;
import com.twosigma.beakerx.widgets.ValueWidget;
import com.twosigma.beakerx.widgets.box.HBox;
import com.twosigma.beakerx.widgets.selections.RadioButtons;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;

public class RadioButtonComponentWidget
extends EasyFormComponent<ValueWidget<?>> {
    private RadioButtons radioButtons;
    private Boolean horizontal;

    public RadioButtonComponentWidget() {
        super(new RadioButtons());
        this.radioButtons = (RadioButtons)this.widget;
    }

    public RadioButtonComponentWidget(Collection<String> values, boolean horizontal) {
        this();
        this.setValues(values);
        this.setHorizontal(horizontal);
    }

    public void setHorizontal(Boolean horizontal) {
        this.horizontal = horizontal;
    }

    public Boolean getHorizontal() {
        return this.horizontal;
    }

    @Override
    public String getLabel() {
        return this.radioButtons.getDescription();
    }

    @Override
    public void setLabel(String label) {
        this.radioButtons.setDescription(label);
    }

    @Override
    public String getValue() {
        return (String)this.radioButtons.getValue();
    }

    @Override
    public void setValue(Object value) {
        this.radioButtons.setValue(value);
    }

    public void setValues(Collection<String> values) {
        this.radioButtons.setOptions(values.toArray(new String[0]));
    }

    public Collection<String> getValues() {
        return Arrays.stream(this.radioButtons.getOptions()).collect(Collectors.toList());
    }

    @Override
    public ValueWidget<?> getWidget() {
        if (this.getHorizontal().booleanValue()) {
            return new HBox(Collections.singletonList(this.radioButtons));
        }
        return this.radioButtons;
    }
}

