/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.twosigma.beakerx.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beakerx.jvm.serialization.ObjectSerializer;
import com.twosigma.beakerx.table.TableDisplay;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Iterable;
import scala.collection.JavaConversions;
import scala.collection.Map;
import scala.collection.immutable.Seq;

public class ScalaListOfPrimitiveTypeMapsSerializer
implements ObjectSerializer {
    private static final Logger logger = LoggerFactory.getLogger((String)ScalaListOfPrimitiveTypeMapsSerializer.class.getName());
    private final BeakerObjectConverter parent;

    public ScalaListOfPrimitiveTypeMapsSerializer(BeakerObjectConverter p) {
        this.parent = p;
    }

    public boolean canBeUsed(Object obj, boolean expand) {
        if (!expand) {
            return false;
        }
        if (!(obj instanceof Seq)) {
            return false;
        }
        Collection col = JavaConversions.asJavaCollection((Iterable)((Iterable)obj));
        if (col.isEmpty()) {
            return false;
        }
        for (Object o : col) {
            if (!(o instanceof Map)) {
                return false;
            }
            java.util.Map m = JavaConversions.mapAsJavaMap((Map)((Map)o));
            Set keys = m.keySet();
            for (Object key : keys) {
                if (key != null && !this.parent.isPrimitiveType(key.getClass().getName())) {
                    return false;
                }
                Object val = m.get(key);
                if (val == null || this.parent.isPrimitiveType(val.getClass().getName())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean writeObject(Object obj, JsonGenerator jgen, boolean expand) throws JsonProcessingException, IOException {
        logger.debug("list of maps");
        Collection col = JavaConversions.asJavaCollection((Iterable)((Iterable)obj));
        ArrayList<java.util.Map> tab = new ArrayList<java.util.Map>();
        for (Object o : col) {
            java.util.Map row = JavaConversions.mapAsJavaMap((Map)((Map)o));
            tab.add(row);
        }
        TableDisplay t = new TableDisplay(tab, this.parent);
        jgen.writeObject((Object)t);
        return true;
    }
}

