/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import zmq.DecoderBase;
import zmq.EncoderBase;
import zmq.TcpAddress;
import zmq.ZMQ;

public class Options {
    int sendHwm = 1000;
    int recvHwm = 1000;
    long affinity = 0L;
    byte identitySize = 0;
    byte[] identity = null;
    String lastEndpoint;
    int rate = 100;
    int recoveryIvl = 10000;
    int multicastHops = 1;
    int sndbuf = 0;
    int rcvbuf = 0;
    int type = -1;
    int linger = -1;
    int reconnectIvl = 100;
    int reconnectIvlMax = 0;
    int backlog = 100;
    long maxMsgSize = -1L;
    int recvTimeout = -1;
    int sendTimeout = -1;
    int ipv4only = 1;
    int delayAttachOnConnect = 0;
    boolean delayOnClose = true;
    boolean delayOnDisconnect = true;
    boolean filter = false;
    boolean recvIdentity = false;
    int tcpKeepAlive = -1;
    int tcpKeepAliveCnt = -1;
    int tcpKeepAliveIdle = -1;
    int tcpKeepAliveIntvl = -1;
    final List<TcpAddress.TcpAddressMask> tcpAcceptFilters = new ArrayList<TcpAddress.TcpAddressMask>();
    int socketId = 0;
    Class<? extends DecoderBase> decoder = null;
    Class<? extends EncoderBase> encoder = null;

    public void setSocketOpt(int option, Object optval) {
        switch (option) {
            case 23: {
                this.sendHwm = (Integer)optval;
                if (this.sendHwm < 0) {
                    throw new IllegalArgumentException("sendHwm " + optval);
                }
                return;
            }
            case 24: {
                this.recvHwm = (Integer)optval;
                if (this.recvHwm < 0) {
                    throw new IllegalArgumentException("recvHwm " + optval);
                }
                return;
            }
            case 4: {
                this.affinity = (Long)optval;
                return;
            }
            case 5: {
                byte[] val;
                if (optval instanceof String) {
                    val = ((String)optval).getBytes(ZMQ.CHARSET);
                } else if (optval instanceof byte[]) {
                    val = (byte[])optval;
                } else {
                    throw new IllegalArgumentException("identity " + optval);
                }
                if (val == null || val.length > 255) {
                    throw new IllegalArgumentException("identity must not be null or less than 255 " + optval);
                }
                this.identity = Arrays.copyOf(val, val.length);
                this.identitySize = (byte)this.identity.length;
                return;
            }
            case 8: {
                this.rate = (Integer)optval;
                return;
            }
            case 9: {
                this.recoveryIvl = (Integer)optval;
                return;
            }
            case 11: {
                this.sndbuf = (Integer)optval;
                return;
            }
            case 12: {
                this.rcvbuf = (Integer)optval;
                return;
            }
            case 17: {
                this.linger = (Integer)optval;
                return;
            }
            case 18: {
                this.reconnectIvl = (Integer)optval;
                if (this.reconnectIvl < -1) {
                    throw new IllegalArgumentException("reconnectIvl " + optval);
                }
                return;
            }
            case 21: {
                this.reconnectIvlMax = (Integer)optval;
                if (this.reconnectIvlMax < 0) {
                    throw new IllegalArgumentException("reconnectIvlMax " + optval);
                }
                return;
            }
            case 19: {
                this.backlog = (Integer)optval;
                return;
            }
            case 22: {
                this.maxMsgSize = (Long)optval;
                return;
            }
            case 25: {
                this.multicastHops = (Integer)optval;
                return;
            }
            case 27: {
                this.recvTimeout = (Integer)optval;
                return;
            }
            case 28: {
                this.sendTimeout = (Integer)optval;
                return;
            }
            case 31: {
                this.ipv4only = (Integer)optval;
                if (this.ipv4only != 0 && this.ipv4only != 1) {
                    throw new IllegalArgumentException("ipv4only only accepts 0 or 1 " + optval);
                }
                return;
            }
            case 34: {
                this.tcpKeepAlive = (Integer)optval;
                if (this.tcpKeepAlive != -1 && this.tcpKeepAlive != 0 && this.tcpKeepAlive != 1) {
                    throw new IllegalArgumentException("tcpKeepAlive only accepts one of -1,0,1 " + optval);
                }
                return;
            }
            case 39: {
                this.delayAttachOnConnect = (Integer)optval;
                if (this.delayAttachOnConnect != 0 && this.delayAttachOnConnect != 1) {
                    throw new IllegalArgumentException("delayAttachOnConnect only accept 0 or 1 " + optval);
                }
                return;
            }
            case 35: 
            case 36: 
            case 37: {
                return;
            }
            case 38: {
                String filterStr = (String)optval;
                if (filterStr == null) {
                    this.tcpAcceptFilters.clear();
                } else {
                    if (filterStr.length() == 0 || filterStr.length() > 255) {
                        throw new IllegalArgumentException("tcp_accept_filter " + optval);
                    }
                    TcpAddress.TcpAddressMask filter = new TcpAddress.TcpAddressMask();
                    filter.resolve(filterStr, this.ipv4only == 1);
                    this.tcpAcceptFilters.add(filter);
                }
                return;
            }
            case 1001: {
                if (optval instanceof String) {
                    try {
                        this.encoder = Class.forName((String)optval).asSubclass(EncoderBase.class);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException(e);
                    }
                } else if (optval instanceof Class) {
                    this.encoder = (Class)optval;
                } else {
                    throw new IllegalArgumentException("encoder " + optval);
                }
                return;
            }
            case 1002: {
                if (optval instanceof String) {
                    try {
                        this.decoder = Class.forName((String)optval).asSubclass(DecoderBase.class);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException(e);
                    }
                } else if (optval instanceof Class) {
                    this.decoder = (Class)optval;
                } else {
                    throw new IllegalArgumentException("decoder " + optval);
                }
                return;
            }
        }
        throw new IllegalArgumentException("Unknown Option " + option);
    }

    public Object getsockopt(int option) {
        switch (option) {
            case 23: {
                return this.sendHwm;
            }
            case 24: {
                return this.recvHwm;
            }
            case 4: {
                return this.affinity;
            }
            case 5: {
                return this.identity;
            }
            case 8: {
                return this.rate;
            }
            case 9: {
                return this.recoveryIvl;
            }
            case 11: {
                return this.sndbuf;
            }
            case 12: {
                return this.rcvbuf;
            }
            case 16: {
                return this.type;
            }
            case 17: {
                return this.linger;
            }
            case 18: {
                return this.reconnectIvl;
            }
            case 21: {
                return this.reconnectIvlMax;
            }
            case 19: {
                return this.backlog;
            }
            case 22: {
                return this.maxMsgSize;
            }
            case 25: {
                return this.multicastHops;
            }
            case 27: {
                return this.recvTimeout;
            }
            case 28: {
                return this.sendTimeout;
            }
            case 31: {
                return this.ipv4only;
            }
            case 34: {
                return this.tcpKeepAlive;
            }
            case 39: {
                return this.delayAttachOnConnect;
            }
            case 35: 
            case 36: 
            case 37: {
                return 0;
            }
            case 32: {
                return this.lastEndpoint;
            }
        }
        throw new IllegalArgumentException("option=" + option);
    }
}

