/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.evaluator;

import com.twosigma.beakerx.NamespaceClient;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.evaluator.WorkerThread;
import com.twosigma.beakerx.scala.evaluator.ScalaCodeRunner;
import com.twosigma.beakerx.scala.evaluator.ScalaEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScalaWorkerThread
extends WorkerThread {
    private static final Logger logger = LoggerFactory.getLogger((String)ScalaWorkerThread.class.getName());
    private ScalaEvaluator scalaEvaluator;
    private boolean exit;
    private boolean updateLoader;

    public ScalaWorkerThread(ScalaEvaluator scalaEvaluator) {
        super("scala worker");
        this.scalaEvaluator = scalaEvaluator;
        this.exit = false;
        this.updateLoader = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        JobDescriptor j = null;
        NamespaceClient nc = null;
        while (!this.exit) {
            logger.debug("looping");
            try {
                this.syncObject.acquire();
                if (this.updateLoader) {
                    this.scalaEvaluator.clearShell();
                }
                if ((j = (JobDescriptor)this.jobQueue.poll()) == null) continue;
                if (this.scalaEvaluator.getShell() == null) {
                    this.updateLoader = false;
                    this.scalaEvaluator.newEvaluator();
                }
                j.outputObject.started();
                nc = NamespaceClient.getBeaker((String)this.scalaEvaluator.getSessionId());
                nc.setOutputObj(j.outputObject);
                if (!this.scalaEvaluator.executeTask(new ScalaCodeRunner(this.scalaEvaluator, j.codeToBeExecuted, j.outputObject))) {
                    j.outputObject.error((Object)BaseEvaluator.INTERUPTED_MSG);
                }
                if (nc == null) continue;
                nc.setOutputObj(null);
                nc = null;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                if (nc != null) {
                    nc.setOutputObj(null);
                    nc = null;
                }
                if (j == null || j.outputObject == null) continue;
                j.outputObject.executeCodeCallback();
            }
        }
        NamespaceClient.delBeaker((String)this.scalaEvaluator.getSessionId());
    }

    public void updateLoader() {
        this.updateLoader = true;
    }

    public void doExit() {
        this.exit = true;
    }
}

