/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.tools.analyser;

import java.io.File;
import java.util.ArrayList;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.resolver.util.FileURLLister;
import org.apache.ivy.plugins.resolver.util.ResolverHelper;
import org.apache.ivy.tools.analyser.JarModule;
import org.apache.ivy.util.Message;

public class JarModuleFinder {
    private String pattern;
    private String filePattern;

    public JarModuleFinder(String pattern) {
        this.pattern = "file:///" + pattern;
        this.filePattern = pattern;
    }

    public JarModule[] findJarModules() {
        ArrayList<JarModule> ret = new ArrayList<JarModule>();
        FileURLLister lister = new FileURLLister();
        try {
            String[] orgs = ResolverHelper.listTokenValues(lister, this.pattern, "organisation");
            for (int i = 0; i < orgs.length; ++i) {
                String orgPattern = IvyPatternHelper.substituteToken(this.pattern, "organisation", orgs[i]);
                String[] modules = ResolverHelper.listTokenValues(lister, orgPattern, "module");
                for (int j = 0; j < modules.length; ++j) {
                    String modPattern = IvyPatternHelper.substituteToken(orgPattern, "module", modules[j]);
                    String[] revs = ResolverHelper.listTokenValues(lister, modPattern, "revision");
                    for (int k = 0; k < revs.length; ++k) {
                        File jar = new File(IvyPatternHelper.substitute(this.filePattern, orgs[i], modules[j], revs[k], modules[j], "jar", "jar"));
                        if (!jar.exists()) continue;
                        ret.add(new JarModule(ModuleRevisionId.newInstance(orgs[i], modules[j], revs[k]), jar));
                    }
                }
            }
        }
        catch (Exception e) {
            Message.debug(e);
        }
        return ret.toArray(new JarModule[ret.size()]);
    }

    public static void main(String[] args) {
        JarModule[] mods = new JarModuleFinder("D:/temp/test2/ivyrep/[organisation]/[module]/[revision]/[artifact].[ext]").findJarModules();
        for (int i = 0; i < mods.length; ++i) {
            System.out.println(mods[i]);
        }
    }
}

