/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel;

import com.google.common.base.Preconditions;
import com.twosigma.beakerx.kernel.PathToJar;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Classpath {
    public static final String DELIMITER = System.lineSeparator();
    private List<PathToJar> paths = new ArrayList<PathToJar>();

    public boolean add(PathToJar path) {
        Preconditions.checkNotNull((Object)path);
        if (!this.paths.contains(path)) {
            return this.paths.add(path);
        }
        return false;
    }

    public List<String> getPathsAsStrings() {
        return this.paths.stream().map(PathToJar::getPath).collect(Collectors.toList());
    }

    public int size() {
        return this.paths.size();
    }

    public String get(int index) {
        return this.paths.get(index).getPath();
    }

    public boolean isEmpty() {
        return this.paths.isEmpty();
    }

    public String toString() {
        return this.paths.stream().map(PathToJar::getPath).collect(Collectors.joining(DELIMITER));
    }
}

