/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public abstract class ResolveScopeManager {
    @NotNull
    public abstract GlobalSearchScope getResolveScope(@NotNull PsiElement var1);

    public abstract GlobalSearchScope getDefaultResolveScope(VirtualFile var1);

    @NotNull
    public abstract GlobalSearchScope getUseScope(@NotNull PsiElement var1);

    public static ResolveScopeManager getInstance(Project project) {
        return ServiceManager.getService(project, ResolveScopeManager.class);
    }

    @NotNull
    public static GlobalSearchScope getElementUseScope(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/ResolveScopeManager", "getElementUseScope"));
        }
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getInstance(element.getProject()).getUseScope(element);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/ResolveScopeManager", "getElementUseScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getElementResolveScope(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/ResolveScopeManager", "getElementResolveScope"));
        }
        PsiFile file2 = element.getContainingFile();
        if (file2 != null) {
            GlobalSearchScope globalSearchScope = ResolveScopeManager.getInstance(file2.getProject()).getResolveScope(file2);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/ResolveScopeManager", "getElementResolveScope"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getInstance(element.getProject()).getResolveScope(element);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/ResolveScopeManager", "getElementResolveScope"));
        }
        return globalSearchScope;
    }
}

