/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.clojure.kernel;

import clojure.lang.LazySeq;
import com.twosigma.beakerx.clojure.evaluator.ClojureEvaluator;
import com.twosigma.beakerx.clojure.handlers.ClojureCommOpenHandler;
import com.twosigma.beakerx.clojure.handlers.ClojureKernelInfoHandler;
import com.twosigma.beakerx.clojure.kernel.ClojureDefaultVariables;
import com.twosigma.beakerx.evaluator.Evaluator;
import com.twosigma.beakerx.handler.KernelHandler;
import com.twosigma.beakerx.kernel.ConfigurationFile;
import com.twosigma.beakerx.kernel.Kernel;
import com.twosigma.beakerx.kernel.KernelConfigurationFile;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.KernelParameters;
import com.twosigma.beakerx.kernel.KernelRunner;
import com.twosigma.beakerx.kernel.KernelSocketsFactory;
import com.twosigma.beakerx.kernel.KernelSocketsFactoryImpl;
import com.twosigma.beakerx.kernel.Utils;
import com.twosigma.beakerx.kernel.handler.CommOpenHandler;
import com.twosigma.beakerx.message.Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jupyter.Displayer;
import jupyter.Displayers;

public class Clojure
extends Kernel {
    public Clojure(String sessionId, Evaluator evaluator, KernelSocketsFactory kernelSocketsFactory) {
        super(sessionId, evaluator, kernelSocketsFactory);
    }

    public CommOpenHandler getCommOpenHandler(Kernel kernel) {
        return new ClojureCommOpenHandler((KernelFunctionality)kernel);
    }

    public KernelHandler<Message> getKernelInfoHandler(Kernel kernel) {
        return new ClojureKernelInfoHandler((KernelFunctionality)kernel);
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        KernelRunner.run(() -> {
            String id = Utils.uuid();
            KernelSocketsFactoryImpl kernelSocketsFactory = new KernelSocketsFactoryImpl((ConfigurationFile)new KernelConfigurationFile(args));
            return new Clojure(id, (Evaluator)new ClojureEvaluator(id, id), (KernelSocketsFactory)kernelSocketsFactory);
        });
    }

    protected void configureJvmRepr() {
        Displayers.register(LazySeq.class, (Displayer)new Displayer<LazySeq>(){

            public Map<String, String> display(final LazySeq value) {
                return new HashMap<String, String>(){
                    {
                        List collect = Arrays.stream(value.toArray()).map(Object::toString).collect(Collectors.toList());
                        this.put("text/plain", new ArrayList(collect).toString());
                    }
                };
            }
        });
    }

    public KernelParameters getKernelParameters() {
        HashMap<String, Collection> kernelParameters = new HashMap<String, Collection>();
        kernelParameters.put("imports", new ClojureDefaultVariables().getImports());
        return new KernelParameters(kernelParameters);
    }
}

