/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.jvm.threads;

import com.twosigma.beakerx.jvm.threads.BeakerOutputHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public class BeakerStdOutErrHandler {
    private static BeakerStdOutErrHandler instance;
    private PrintStream orig_out;
    private PrintStream orig_err;
    private Map<Long, threadOutputHandler> thrHandlers = new HashMap<Long, threadOutputHandler>();
    private BeakerOutputHandler def_out;
    private BeakerOutputHandler def_err;

    public static synchronized void init() {
        if (instance == null) {
            instance = new BeakerStdOutErrHandler();
            instance.theinit();
        }
    }

    public static synchronized void fini() {
        if (instance != null) {
            instance.thefini();
            instance = null;
        }
    }

    public static synchronized void setOutputHandler(BeakerOutputHandler out, BeakerOutputHandler err) {
        if (instance != null) {
            instance.theSetOutputHandler(out, err);
        }
    }

    public static synchronized void setDefaultOutputHandler(BeakerOutputHandler out, BeakerOutputHandler err) {
        if (instance != null) {
            instance.theSetDefaultOutputHandler(out, err);
        }
    }

    public static synchronized void clrOutputHandler() {
        if (instance != null) {
            instance.theClrOutputHandler();
        }
    }

    public static synchronized PrintStream out() {
        if (instance != null && BeakerStdOutErrHandler.instance.orig_out != null) {
            return BeakerStdOutErrHandler.instance.orig_out;
        }
        return System.out;
    }

    public static synchronized PrintStream err() {
        if (instance != null && BeakerStdOutErrHandler.instance.orig_err != null) {
            return BeakerStdOutErrHandler.instance.orig_err;
        }
        return System.err;
    }

    private void theinit() {
        this.orig_out = System.out;
        this.orig_err = System.err;
        System.setOut(new PrintStream(new MyOutputStream(true)));
        System.setErr(new PrintStream(new MyOutputStream(false)));
    }

    private void thefini() {
        System.setOut(this.orig_out);
        System.setErr(this.orig_err);
    }

    private synchronized void theSetOutputHandler(BeakerOutputHandler out, BeakerOutputHandler err) {
        threadOutputHandler t;
        long id = Thread.currentThread().getId();
        if (!this.thrHandlers.containsKey(id)) {
            t = new threadOutputHandler();
            this.thrHandlers.put(id, t);
        } else {
            t = this.thrHandlers.get(id);
        }
        t.out_handler = out;
        t.err_handler = err;
    }

    private synchronized void theSetDefaultOutputHandler(BeakerOutputHandler out, BeakerOutputHandler err) {
        this.def_out = out;
        this.def_err = err;
    }

    private synchronized void theClrOutputHandler() {
        long id = Thread.currentThread().getId();
        this.thrHandlers.remove(id);
    }

    private BeakerOutputHandler getHandler(boolean out) {
        long id = Thread.currentThread().getId();
        if (this.thrHandlers.containsKey(id)) {
            threadOutputHandler t = this.thrHandlers.get(id);
            if (out) {
                return t.out_handler;
            }
            return t.err_handler;
        }
        if (this.def_out != null || this.def_err != null) {
            threadOutputHandler t = new threadOutputHandler();
            t.out_handler = this.def_out;
            t.err_handler = this.def_err;
            this.thrHandlers.put(id, t);
        }
        if (out) {
            return this.def_out;
        }
        return this.def_err;
    }

    private synchronized void write(boolean isout, int b) throws IOException {
        BeakerOutputHandler hdl = this.getHandler(isout);
        if (hdl != null) {
            hdl.write(b);
        } else if (isout) {
            this.orig_out.write(b);
        } else {
            this.orig_err.write(b);
        }
    }

    private synchronized void write(boolean isout, byte[] b) throws IOException {
        BeakerOutputHandler hdl = this.getHandler(isout);
        if (hdl != null) {
            hdl.write(b);
        } else if (isout) {
            this.orig_out.write(b);
        } else {
            this.orig_err.write(b);
        }
    }

    private synchronized void write(boolean isout, byte[] b, int off, int len) throws IOException {
        BeakerOutputHandler hdl = this.getHandler(isout);
        if (hdl != null) {
            hdl.write(b, off, len);
        } else if (isout) {
            this.orig_out.write(b, off, len);
        } else {
            this.orig_err.write(b, off, len);
        }
    }

    private class threadOutputHandler {
        public BeakerOutputHandler out_handler;
        public BeakerOutputHandler err_handler;

        private threadOutputHandler() {
        }
    }

    private class MyOutputStream
    extends OutputStream {
        private boolean is_out;

        public MyOutputStream(boolean isout) {
            this.is_out = isout;
        }

        @Override
        public void write(int b) throws IOException {
            instance.write(this.is_out, b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            instance.write(this.is_out, b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            instance.write(this.is_out, b, off, len);
        }
    }
}

