/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.javash.evaluator;

import java.util.Deque;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.translate.AggregateTranslator;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.UnicodeUnescaper;

public class ParserUtil {
    public static final CharSequenceTranslator UNICODE_UNESCAPER = new AggregateTranslator(new CharSequenceTranslator[]{new UnicodeUnescaper()});

    public static String removeComments(String javaCode) {
        ParserState parserState = new ParserState();
        State state = State.CODE;
        StringBuffer inBlock = null;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < javaCode.length(); ++i) {
            char c = javaCode.charAt(i);
            switch (state) {
                case CODE: {
                    if (!parserState.isLastChar('/') && c == '/') {
                        state = State.CAN_BE_COMMENT_START;
                    } else if (c == '\"') {
                        state = State.IN_STRING;
                    } else if (c == '\'') {
                        state = State.IN_CHAR;
                    }
                    builder.append(c);
                    break;
                }
                case CAN_BE_COMMENT_START: {
                    if (parserState.isLastChar('/') && c == '/') {
                        if (builder.length() > 0) {
                            builder.setLength(builder.length() - 1);
                        }
                        state = State.IN_LINE_COMMENT;
                        break;
                    }
                    if (parserState.isLastChar('/') && c == '*') {
                        if (builder.length() > 0) {
                            builder.setLength(builder.length() - 1);
                        }
                        state = State.IN_BLOCK_COMMENT;
                        inBlock = new StringBuffer();
                        break;
                    }
                    state = State.CODE;
                    builder.append(c);
                    break;
                }
                case IN_LINE_COMMENT: {
                    if (c != '\n' && c != '\r') break;
                    state = State.CODE;
                    break;
                }
                case IN_BLOCK_COMMENT: {
                    assert (inBlock != null);
                    if (parserState.isLastChar('*') && c == '/' && (!parserState.isSecondToLastChar('/') || inBlock.length() > 0)) {
                        state = State.CODE;
                        break;
                    }
                    inBlock.append(c == '\r' ? (char)'\n' : (char)c);
                    break;
                }
                case IN_STRING: {
                    if (!parserState.isLastChar('\\') && c == '\"') {
                        state = State.CODE;
                    }
                    builder.append(c);
                    break;
                }
                case IN_CHAR: {
                    if (!parserState.isLastChar('\\') && c == '\'') {
                        state = State.CODE;
                    }
                    builder.append(c);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected");
                }
            }
            if (state == State.IN_STRING && parserState.isLastChar('\\') && c == '\\') {
                parserState.reset();
                continue;
            }
            parserState.update(c);
        }
        return builder.toString();
    }

    public static String normalizeCode(String code) {
        String normalizedCode = ParserUtil.removeComments(UNICODE_UNESCAPER.translate((CharSequence)code));
        return StringUtils.isNotBlank((CharSequence)normalizedCode) ? normalizedCode : "";
    }

    static class ParserState {
        private Deque prevTwoChars = new LinkedList();

        ParserState() {
        }

        boolean isLastChar(char expectedChar) {
            return this.prevTwoChars.size() >= 1 && this.prevTwoChars.peekLast().equals(Character.valueOf(expectedChar));
        }

        public boolean isSecondToLastChar(char expectedChar) {
            return this.prevTwoChars.size() >= 1 && this.prevTwoChars.peekFirst().equals(Character.valueOf(expectedChar));
        }

        public void update(char c) {
            if (this.prevTwoChars.size() == 2) {
                this.prevTwoChars.remove();
            }
            this.prevTwoChars.add(Character.valueOf(c));
        }

        public void reset() {
            while (!this.prevTwoChars.isEmpty()) {
                this.prevTwoChars.removeFirst();
            }
        }
    }

    private static enum State {
        CODE,
        CAN_BE_COMMENT_START,
        IN_LINE_COMMENT,
        IN_BLOCK_COMMENT,
        IN_STRING,
        IN_CHAR;

    }
}

