/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.javash.evaluator;

import com.twosigma.beakerx.NamespaceClient;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.evaluator.WorkerThread;
import com.twosigma.beakerx.javash.evaluator.CompilationException;
import com.twosigma.beakerx.javash.evaluator.JavaCodeRunner;
import com.twosigma.beakerx.javash.evaluator.JavaEvaluator;
import com.twosigma.beakerx.javash.evaluator.JavaSourceCompiler;
import com.twosigma.beakerx.javash.evaluator.ParserUtil;
import com.twosigma.beakerx.jvm.classloader.DynamicClassLoaderSimple;
import com.twosigma.beakerx.kernel.ImportPath;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.abstractmeta.toolbox.compilation.compiler.JavaSourceCompiler;
import org.apache.commons.lang3.StringUtils;

class JavaWorkerThread
extends WorkerThread {
    private JavaEvaluator javaEvaluator;
    private boolean exit;
    private boolean updateLoader;

    public JavaWorkerThread(JavaEvaluator javaEvaluator) {
        super("javash worker");
        this.javaEvaluator = javaEvaluator;
        this.exit = false;
        this.updateLoader = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DynamicClassLoaderSimple loader = null;
        JobDescriptor j = null;
        JavaSourceCompiler javaSourceCompiler = new JavaSourceCompiler();
        NamespaceClient nc = null;
        while (!this.exit) {
            try {
                this.syncObject.acquire();
                if (loader == null || this.updateLoader) {
                    loader = new DynamicClassLoaderSimple(ClassLoader.getSystemClassLoader());
                    loader.addJars(this.javaEvaluator.getClasspath().getPathsAsStrings());
                    loader.addDynamicDir(this.javaEvaluator.getOutDir());
                }
                if ((j = (JobDescriptor)this.jobQueue.poll()) == null) continue;
                nc = NamespaceClient.getBeaker((String)this.javaEvaluator.getSessionId());
                nc.setOutputObj(j.outputObject);
                j.outputObject.started();
                String pname = this.javaEvaluator.getPackageId();
                JavaSourceCompiler.CompilationUnit compilationUnit = javaSourceCompiler.createCompilationUnit(new File(this.javaEvaluator.getOutDir()));
                String classpath = System.getProperty("java.class.path");
                String[] classpathEntries = classpath.split(File.pathSeparator);
                if (classpathEntries != null && classpathEntries.length > 0) {
                    compilationUnit.addClassPathEntries(Arrays.asList(classpathEntries));
                }
                if (!this.javaEvaluator.getClasspath().isEmpty()) {
                    compilationUnit.addClassPathEntries(this.javaEvaluator.getClasspath().getPathsAsStrings());
                }
                compilationUnit.addClassPathEntry(this.javaEvaluator.getOutDir());
                String code = ParserUtil.normalizeCode(j.codeToBeExecuted);
                String[] codev = code.split("\n");
                int ci = 0;
                ci = this.skipBlankLines(codev, ci);
                HashMap<Integer, Integer> lineNumbersMapping = new HashMap<Integer, Integer>();
                LineBrakingStringBuilderWrapper javaSourceCode = new LineBrakingStringBuilderWrapper();
                Pattern p = Pattern.compile("\\s*package\\s+((?:[a-zA-Z]\\w*)(?:\\.[a-zA-Z]\\w*)*);.*");
                Matcher m = p.matcher(codev[ci]);
                if (m.matches()) {
                    pname = m.group(1);
                    lineNumbersMapping.put(1, ci);
                    ci = this.skipBlankLines(codev, ci + 1);
                }
                javaSourceCode.append("package ");
                javaSourceCode.append(pname);
                javaSourceCode.append(";\n");
                for (ImportPath i : this.javaEvaluator.getImports().getImportPaths()) {
                    javaSourceCode.append("import ");
                    javaSourceCode.append(i.asString());
                    javaSourceCode.append(";\n");
                }
                p = Pattern.compile("\\s*import(\\s+static)?\\s+((?:[a-zA-Z]\\w*)(?:\\.[a-zA-Z]\\w*)*(?:\\.\\*)?);.*");
                m = p.matcher(codev[ci]);
                while (m.matches()) {
                    String impstr = m.group(2);
                    String staticModifier = m.group(1);
                    javaSourceCode.append("import ");
                    if (staticModifier != null) {
                        javaSourceCode.append("static ");
                    }
                    javaSourceCode.append(impstr);
                    javaSourceCode.append(";\n");
                    lineNumbersMapping.put(javaSourceCode.getLinesCount(), ci);
                    ci = this.skipBlankLines(codev, ci + 1);
                    m = p.matcher(codev[ci]);
                }
                p = Pattern.compile("(?:^|.*\\s+)(?:(?:class)|(?:interface))\\s+([a-zA-Z]\\w*).*");
                m = p.matcher(codev[ci]);
                if (m.matches()) {
                    String cname = m.group(1);
                    this.addTheRestOfCode(codev, ci, javaSourceCode, lineNumbersMapping);
                    compilationUnit.addJavaSource(pname + "." + cname, javaSourceCode.toString());
                    try {
                        javaSourceCompiler.compile(compilationUnit, new String[0]);
                        javaSourceCompiler.persistCompiledClasses(compilationUnit);
                        j.outputObject.finished((Object)(pname + "." + cname));
                    }
                    catch (CompilationException e) {
                        j.outputObject.error((Object)this.buildErrorMessage(e, lineNumbersMapping));
                    }
                    catch (Exception e) {
                        j.outputObject.error((Object)("ERROR: " + e.toString()));
                    }
                    finally {
                        if (j.outputObject != null) {
                            j.outputObject.executeCodeCallback();
                        }
                    }
                } else {
                    String ret = "void";
                    if (codev[codev.length - 1].matches("(^|.*\\s+)return\\s+.*")) {
                        ret = "Object";
                    }
                    javaSourceCode.append("public class BeakerWrapperClass1261714175 {\n");
                    javaSourceCode.append("public static ");
                    javaSourceCode.append(ret);
                    javaSourceCode.append(" beakerRun() throws Exception {\n");
                    this.addTheRestOfCode(codev, ci, javaSourceCode, lineNumbersMapping);
                    javaSourceCode.append("}\n");
                    javaSourceCode.append("}\n");
                    compilationUnit.addJavaSource(pname + "." + "BeakerWrapperClass1261714175", javaSourceCode.toString());
                    try {
                        javaSourceCompiler.compile(compilationUnit, new String[0]);
                        javaSourceCompiler.persistCompiledClasses(compilationUnit);
                        Class fooClass = loader.loadClass(pname + "." + "BeakerWrapperClass1261714175");
                        Method mth = fooClass.getDeclaredMethod("beakerRun", null);
                        if (!this.javaEvaluator.executeTask(new JavaCodeRunner(mth, j.outputObject, ret.equals("Object"), (ClassLoader)loader))) {
                            j.outputObject.error((Object)BaseEvaluator.INTERUPTED_MSG);
                        }
                        if (nc != null) {
                            nc.setOutputObj(null);
                            nc = null;
                        }
                    }
                    catch (CompilationException e) {
                        j.outputObject.error((Object)this.buildErrorMessage(e, lineNumbersMapping));
                    }
                    catch (Exception e) {
                        j.outputObject.error((Object)("ERROR: " + e.toString()));
                    }
                    finally {
                        if (j.outputObject != null) {
                            j.outputObject.executeCodeCallback();
                        }
                    }
                }
                j = null;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                if (nc == null) continue;
                nc.setOutputObj(null);
                nc = null;
            }
        }
        NamespaceClient.delBeaker((String)this.javaEvaluator.getSessionId());
    }

    private int skipBlankLines(String[] lines, int ci) {
        while (ci < lines.length - 1 && StringUtils.isBlank((CharSequence)lines[ci])) {
            ++ci;
        }
        return ci;
    }

    private String buildErrorMessage(CompilationException exception, Map<Integer, Integer> lineNumbersMapping) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ERROR: ").append(exception.getMessage()).append('\n');
        for (CompilationException.CompilationError compilationError : exception.getCompilationErrors()) {
            stringBuilder.append("error at line ").append(this.mapLineNumber(lineNumbersMapping, compilationError.getLineNumber())).append(": ").append(this.prepareForFrontend(compilationError.getErrorMessage())).append('\n').append(compilationError.getCode());
        }
        return stringBuilder.toString();
    }

    private String prepareForFrontend(String errorMessage) {
        return errorMessage.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    private Integer mapLineNumber(Map<Integer, Integer> lineNumbersMapping, int ourNumber) {
        Integer usersNumber = lineNumbersMapping.get(ourNumber);
        return usersNumber == null ? ourNumber : usersNumber + 1;
    }

    private void addTheRestOfCode(String[] codev, int ci, LineBrakingStringBuilderWrapper javaSourceCode, Map<Integer, Integer> lineNumbersMapping) {
        while (ci < codev.length) {
            javaSourceCode.append(codev[ci]);
            javaSourceCode.append("\n");
            lineNumbersMapping.put(javaSourceCode.getLinesCount(), ci);
            ++ci;
        }
    }

    public void updateLoader() {
        this.updateLoader = true;
    }

    public void doExit() {
        this.exit = true;
    }

    private static class LineBrakingStringBuilderWrapper {
        private static final String LINE_BREAK = "\n";
        private StringBuilder delegate = new StringBuilder();
        private int linesCount = 0;

        public void append(String string) {
            this.delegate.append(string);
            this.linesCount += StringUtils.countMatches((CharSequence)string, (CharSequence)LINE_BREAK);
        }

        public int getLinesCount() {
            return this.linesCount;
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

