/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widgets;

import com.twosigma.beakerx.widgets.DOMWidget;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public abstract class ValueWidget<T extends Serializable>
extends DOMWidget {
    protected T value;
    protected Boolean disabled = false;
    protected Boolean visible = true;
    protected String description = "";
    protected Integer msg_throttle = 3;

    public T getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = this.getValueFromObject(value);
        this.sendUpdate("value", value);
    }

    @Override
    public void updateValue(Object input) {
        this.value = this.getValueFromObject(input);
    }

    public abstract T getValueFromObject(Object var1);

    public Boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(Object disabled) {
        this.disabled = this.getBoolean(disabled);
        this.sendUpdate("disabled", disabled);
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public void setVisible(Object visible) {
        this.visible = this.getBoolean(visible);
        this.sendUpdate("visible", visible);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(Object description) {
        this.description = this.getString(description);
        this.sendUpdate("description", description);
    }

    public Integer getMsg_throttle() {
        return this.msg_throttle;
    }

    public void setMsg_throttle(Object msg_throttle) {
        this.msg_throttle = this.getInteger(msg_throttle);
        this.sendUpdate("msg_throttle", msg_throttle);
    }

    @Override
    protected HashMap<String, Serializable> content(HashMap<String, Serializable> content) {
        super.content(content);
        content.put("description", (Serializable)((Object)this.description));
        content.put("disabled", this.disabled);
        content.put("visible", this.visible);
        content.put("msg_throttle", this.msg_throttle);
        return content;
    }

    public Integer getInteger(Object input) {
        Integer ret = 0;
        if (input != null) {
            Object[] array;
            if (input instanceof Double) {
                ret = ((Double)input).intValue();
            } else if (input instanceof Integer) {
                ret = (Integer)input;
            } else if (input instanceof String) {
                try {
                    ret = Integer.parseInt((String)input);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (input instanceof Object[] && (array = (Object[])input).length > 0) {
                ret = this.getInteger(array[0]);
            }
        }
        return ret;
    }

    public Double getDouble(Object input) {
        Double ret = 0.0;
        if (input != null) {
            Object[] array;
            if (input instanceof Integer) {
                ret = ((Integer)input).doubleValue();
            } else if (input instanceof Double) {
                ret = (Double)input;
            } else if (input instanceof String) {
                try {
                    ret = Double.parseDouble((String)input);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (input instanceof Object[] && (array = (Object[])input).length > 0) {
                ret = this.getDouble(array[0]);
            }
        }
        return ret;
    }

    protected Integer[] getArrayOfInteger(Object input, Integer lowerDefault, Integer upperDefault) {
        Integer[] ret = new Integer[]{lowerDefault, upperDefault};
        if (input != null) {
            if (input instanceof Object[]) {
                Object[] array = (Object[])input;
                if (array.length == 1) {
                    ret[0] = this.getInteger(array[0]);
                } else if (array.length > 1) {
                    ret[0] = this.getInteger(array[0]);
                    ret[1] = this.getInteger(array[1]);
                }
            } else if (input instanceof Collection) {
                Collection coll = (Collection)input;
                if (coll.size() == 1) {
                    ret[0] = this.getInteger(coll.toArray()[0]);
                } else if (coll.size() > 1) {
                    ret[0] = this.getInteger(coll.toArray()[0]);
                    ret[1] = this.getInteger(coll.toArray()[1]);
                }
            } else {
                ret[0] = this.getInteger(input);
            }
        }
        return ret;
    }

    protected Double[] getArrayOfDouble(Object input, Double lowerDefault, Double upperDefault) {
        Double[] ret = new Double[]{lowerDefault, upperDefault};
        if (input != null) {
            if (input instanceof Object[]) {
                Object[] array = (Object[])input;
                if (array.length == 1) {
                    ret[0] = this.getDouble(array[0]);
                } else if (array.length > 1) {
                    ret[0] = this.getDouble(array[0]);
                    ret[1] = this.getDouble(array[1]);
                }
            } else if (input instanceof Collection) {
                Collection coll = (Collection)input;
                if (coll.size() == 1) {
                    ret[0] = this.getDouble(coll.toArray()[0]);
                } else if (coll.size() > 1) {
                    ret[0] = this.getDouble(coll.toArray()[0]);
                    ret[1] = this.getDouble(coll.toArray()[1]);
                }
            } else {
                ret[0] = this.getDouble(input);
            }
        }
        return ret;
    }

    public String getString(Object input) {
        String ret = "";
        if (input != null) {
            ret = input instanceof String ? (String)input : (input instanceof byte[] ? new String((byte[])input) : input.toString());
        }
        return ret;
    }

    public String[] getStringArray(Object input) {
        ArrayList<String> ret = new ArrayList<String>();
        if (input != null) {
            if (input instanceof Object[]) {
                Object[] array;
                for (Object o : array = (Object[])input) {
                    ret.add(this.getString(o));
                }
            } else if (input instanceof Collection) {
                Collection array = (Collection)input;
                for (Object o : array) {
                    ret.add(this.getString(o));
                }
            } else {
                ret.add(this.getString(input));
            }
        }
        return (String[])ret.stream().toArray(String[]::new);
    }

    public Boolean getBoolean(Object input) {
        Boolean ret = false;
        if (input != null) {
            if (input instanceof Boolean) {
                ret = (Boolean)input;
            } else if (input instanceof String) {
                ret = new Boolean((String)input);
            }
        }
        return ret;
    }
}

