/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widgets;

import com.twosigma.beakerx.SerializeToString;
import com.twosigma.beakerx.evaluator.InternalVariable;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.kernel.KernelManager;
import com.twosigma.beakerx.kernel.msg.MessageCreator;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.mimetype.MIMEContainer;
import com.twosigma.beakerx.widgets.CommActions;
import com.twosigma.beakerx.widgets.Widget;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompiledCodeRunner {
    private static final Logger logger = LoggerFactory.getLogger(CompiledCodeRunner.class);

    static void runCommEvent(Message message, CommActions action, Widget.ActionPerformed handlerAction) {
        Object contentObject;
        Serializable data;
        if (message.getContent() != null && (data = message.getContent().get("data")) != null && data instanceof LinkedHashMap && (contentObject = ((LinkedHashMap)data).get("content")) instanceof LinkedHashMap) {
            LinkedHashMap content = (LinkedHashMap)contentObject;
            if (handlerAction != null) {
                SimpleEvaluationObject seo = CompiledCodeRunner.initOutput(message);
                handlerAction.executeAction(content, message);
                seo.clrOutputHandler();
            }
        }
    }

    public static void runCompiledCode(Message message, ExecuteCompiledCode handler, Object ... params) {
        SimpleEvaluationObject seo = CompiledCodeRunner.initOutput(message);
        InternalVariable.setValue(seo);
        try {
            Object result = handler.executeCode(params);
            if (result != null) {
                SerializeToString.doit(result);
            }
        }
        catch (Exception e) {
            CompiledCodeRunner.printError(message, seo, e);
        }
        seo.clrOutputHandler();
    }

    public static void runCompiledCodeAndPublish(Message message, ExecuteCompiledCode handler, Object ... params) {
        MessageCreator mc = new MessageCreator(KernelManager.get());
        SimpleEvaluationObject seo = CompiledCodeRunner.initOutput(message);
        InternalVariable.setValue(seo);
        KernelManager.get().publish(mc.buildClearOutput(message, true));
        try {
            Object result = handler.executeCode(params);
            if (result != null) {
                List<MIMEContainer> resultString = SerializeToString.doit(result);
                KernelManager.get().publish(mc.buildDisplayData(message, resultString));
            }
        }
        catch (Exception e) {
            CompiledCodeRunner.printError(message, seo, e);
        }
        seo.clrOutputHandler();
    }

    private static SimpleEvaluationObject initOutput(Message message) {
        SimpleEvaluationObject seo = new SimpleEvaluationObject("", seoResult -> {});
        seo.setJupyterMessage(message);
        seo.setOutputHandler();
        seo.addObserver(KernelManager.get().getExecutionResultSender());
        return seo;
    }

    private static void printError(Message message, SimpleEvaluationObject seo, Exception e) {
        if (message != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            seo.error(sw.toString());
        } else {
            logger.info("Execution result ERROR: \n" + e);
        }
    }

    public static interface ExecuteCompiledCode {
        public Object executeCode(Object ... var1) throws Exception;
    }
}

