/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.security;

import com.google.common.base.Preconditions;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashedMessageAuthenticationCode {
    private static final String TYPE = "HmacSHA256";
    private static final String INVALID_HMAC_EXCEPTION = "Invalid key exception while converting to HmacSHA256";
    private static Logger logger = LoggerFactory.getLogger(HashedMessageAuthenticationCode.class);
    private SecretKeySpec spec;

    public HashedMessageAuthenticationCode(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"No key specified");
        logger.debug("Using signing hmac: {}", (Object)key);
        this.spec = new SecretKeySpec(key.getBytes(), TYPE);
    }

    public String sign(List<String> msg) {
        List<byte[]> collect = msg.stream().map(String::getBytes).collect(Collectors.toList());
        return this.signBytes(collect);
    }

    public String signBytes(List<byte[]> msg) {
        try {
            Mac mac = Mac.getInstance(TYPE);
            mac.init(this.spec);
            msg.forEach(it -> mac.update((byte[])it));
            byte[] digest = mac.doFinal();
            return this.toHex(digest);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(INVALID_HMAC_EXCEPTION, e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public String toHex(byte[] buffer) {
        return Hex.encodeHexString((byte[])buffer);
    }
}

