/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.commands;

import com.twosigma.beakerx.kernel.Code;
import com.twosigma.beakerx.kernel.commands.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.commands.item.MagicCommandItemWithResult;
import com.twosigma.beakerx.kernel.commands.item.MagicCommandType;
import com.twosigma.beakerx.kernel.msg.MessageCreator;
import com.twosigma.beakerx.message.Message;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.text.StrTokenizer;

public class MagicCommandFinder {
    private List<MagicCommandItemWithResult> errors = new ArrayList<MagicCommandItemWithResult>();
    private LinkedHashMap<String, MagicCommandFunctionality> functionalitiesToRun = new LinkedHashMap();

    private MagicCommandFinder(LinkedHashMap<String, MagicCommandFunctionality> functionalityToRun, List<MagicCommandItemWithResult> errors) {
        this.errors = errors;
        this.functionalitiesToRun = new LinkedHashMap<String, MagicCommandFunctionality>(functionalityToRun);
    }

    public static MagicCommandFinder find(Code code, List<MagicCommandType> commands, Message message, int executionCount, MessageCreator messageCreator) {
        ArrayList<MagicCommandItemWithResult> errors = new ArrayList<MagicCommandItemWithResult>();
        LinkedHashMap<String, MagicCommandFunctionality> functionalityToRun = new LinkedHashMap<String, MagicCommandFunctionality>();
        code.getCommands().forEach(command -> {
            if (command.startsWith("%%") && MagicCommandFinder.isCellmagicHeadNonEmpty(command)) {
                errors.add(MagicCommandFinder.processIllegalCommand("Cell magic head contains data, move it to body.", message, executionCount, messageCreator));
                return;
            }
            if (command.contains("\"")) {
                int indexOfFirstQuote = command.indexOf("\"");
                command = command.substring(0, indexOfFirstQuote).replaceAll("\\s+", " ").concat(command.substring(indexOfFirstQuote, command.length()));
            } else {
                command = command.replaceAll("\\s+", " ");
            }
            Optional<MagicCommandFunctionality> functionality = MagicCommandFinder.findFunctionality(commands, command);
            if (functionality.isPresent()) {
                functionalityToRun.put((String)command, functionality.get());
            } else {
                errors.add(MagicCommandFinder.processIllegalCommand("Cell magic " + command + " not found", message, executionCount, messageCreator));
            }
        });
        return new MagicCommandFinder(functionalityToRun, errors);
    }

    private static boolean isCellmagicHeadNonEmpty(String command) {
        List commands = new StrTokenizer(command).getTokenList();
        String commandWithoutOptions = MagicCommandFinder.removeOptionsFromHead(commands);
        return commandWithoutOptions.replace((CharSequence)commands.get(0), "").replace(" ", "").length() >= 1;
    }

    private static String removeOptionsFromHead(List<String> commands) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String command : commands) {
            if (command.startsWith("-r") || command.startsWith("-n") || command.startsWith("-q")) continue;
            stringBuilder.append(command);
        }
        return stringBuilder.toString();
    }

    private static Optional<MagicCommandFunctionality> findFunctionality(List<MagicCommandType> commands, String command) {
        return commands.stream().filter(c -> command.matches(c.getCommand() + " .*?") || command.matches(c.getCommand())).map(MagicCommandType::getFunctionality).findFirst();
    }

    private static MagicCommandItemWithResult processIllegalCommand(String errorMessage, Message message, int executionCount, MessageCreator messageCreator) {
        return new MagicCommandItemWithResult(messageCreator.buildOutputMessage(message, errorMessage, true), messageCreator.buildReplyWithoutStatus(message, executionCount));
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<MagicCommandItemWithResult> getErrors() {
        return this.errors;
    }

    public List<String> getCommands() {
        return new ArrayList<String>(this.functionalitiesToRun.keySet());
    }

    public MagicCommandFunctionality get(String command) {
        return this.functionalitiesToRun.get(command);
    }
}

