/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.jvm.object;

import com.twosigma.beakerx.SerializeToString;
import com.twosigma.beakerx.jvm.object.OutputContainer;
import com.twosigma.beakerx.mimetype.MIMEContainer;
import com.twosigma.beakerx.table.TableDisplay;
import com.twosigma.beakerx.widgets.Widget;
import com.twosigma.beakerx.widgets.strings.HTML;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class OutputContainerLayoutManager {
    private boolean borderDisplayed;

    public boolean isBorderDisplayed() {
        return this.borderDisplayed;
    }

    public void setBorderDisplayed(boolean borderDisplayed) {
        this.borderDisplayed = borderDisplayed;
    }

    public abstract void display(OutputContainer var1);

    protected List<Widget> getWidgets(OutputContainer container) {
        return container.getItems().stream().map(this::toWidget).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<Widget> toWidget(Object item) {
        if (item == null) {
            return this.handleNull();
        }
        TableDisplay widget = SerializeToString.getTableDisplay(item);
        if (widget != null) {
            return Optional.of(widget);
        }
        if (item instanceof Widget) {
            return Optional.of((Widget)item);
        }
        if (item instanceof MIMEContainer) {
            return Optional.of(this.createHTML(((MIMEContainer)item).getData().toString()));
        }
        return Optional.of(this.createHTML(item.toString()));
    }

    private Optional<Widget> handleNull() {
        List<MIMEContainer> mimeContainerForNull = SerializeToString.getMimeContainerForNull();
        if (mimeContainerForNull.contains(MIMEContainer.HIDDEN)) {
            return Optional.empty();
        }
        return Optional.of(this.createHTML(mimeContainerForNull.get(0).getData().toString()));
    }

    private Widget createHTML(String value) {
        HTML label = new HTML();
        label.setValue(value);
        return label;
    }
}

