/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.twosigma.beakerx.chart.Color;
import com.twosigma.beakerx.chart.xychart.NanoPlot;
import com.twosigma.beakerx.chart.xychart.plotitem.ConstantBand;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ConstantBandSerializer
extends JsonSerializer<ConstantBand> {
    public static final String TYPE = "type";

    public void serialize(ConstantBand constantBand, JsonGenerator jgen, SerializerProvider sp) throws IOException, JsonProcessingException {
        jgen.writeStartObject();
        boolean isNanoPlot = NanoPlot.class.equals((Object)constantBand.getPlotType());
        jgen.writeObjectField(TYPE, (Object)constantBand.getClass().getSimpleName());
        jgen.writeObjectField("x", isNanoPlot ? this.processLargeNumbers(constantBand.getX()) : constantBand.getX());
        jgen.writeObjectField("y", constantBand.getY());
        jgen.writeObjectField("visible", (Object)constantBand.getVisible());
        jgen.writeObjectField("yAxis", (Object)constantBand.getYAxis());
        if (constantBand.getColor() == null) {
            jgen.writeObjectField("color", (Object)new Color(0, 127, 255, 127));
        } else {
            jgen.writeObjectField("color", (Object)constantBand.getColor());
        }
        jgen.writeEndObject();
    }

    private List<String> processLargeNumbers(List<Number> list) {
        ArrayList<String> stringList = new ArrayList<String>(list.size());
        for (Number n : list) {
            if (n != null) {
                stringList.add(n.toString());
                continue;
            }
            stringList.add("");
        }
        return stringList;
    }
}

