/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.groovy.evaluator;

import com.twosigma.beakerx.NamespaceClient;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.evaluator.WorkerThread;
import com.twosigma.beakerx.groovy.evaluator.GroovyClassLoaderFactory;
import com.twosigma.beakerx.groovy.evaluator.GroovyCodeRunner;
import com.twosigma.beakerx.groovy.evaluator.GroovyEvaluator;
import com.twosigma.beakerx.groovy.evaluator.GroovyNotFoundException;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import java.net.MalformedURLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GroovyWorkerThread
extends WorkerThread {
    private static final Logger logger = LoggerFactory.getLogger((String)GroovyWorkerThread.class.getName());
    protected GroovyEvaluator groovyEvaluator;
    private GroovyClassLoader groovyClassLoader;
    private Binding scriptBinding = null;
    private boolean exit;
    private boolean updateLoader;

    GroovyWorkerThread(GroovyEvaluator groovyEvaluator) {
        super("groovy worker");
        this.groovyEvaluator = groovyEvaluator;
        this.exit = false;
        this.updateLoader = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        JobDescriptor j = null;
        NamespaceClient nc = null;
        while (!this.exit) {
            try {
                this.syncObject.acquire();
                if (this.updateLoader) {
                    if (this.groovyClassLoader != null) {
                        try {
                            this.groovyClassLoader.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.groovyClassLoader = null;
                    this.scriptBinding = null;
                }
                if ((j = (JobDescriptor)this.jobQueue.poll()) == null) continue;
                if (this.groovyClassLoader == null) {
                    this.updateLoader = false;
                    this.reloadClassloader();
                }
                if (!GroovyEvaluator.LOCAL_DEV) {
                    nc = NamespaceClient.getBeaker((String)this.groovyEvaluator.getSessionId());
                    nc.setOutputObj(j.outputObject);
                }
                j.outputObject.started();
                String code = j.codeToBeExecuted;
                if (!this.groovyEvaluator.executeTask(new GroovyCodeRunner(this, code, j.outputObject))) {
                    j.outputObject.error((Object)BaseEvaluator.INTERUPTED_MSG);
                }
                if (nc == null) continue;
                nc.setOutputObj(null);
                nc = null;
            }
            catch (Throwable e) {
                if (e instanceof GroovyNotFoundException) {
                    logger.warn(e.getLocalizedMessage());
                    if (j == null) continue;
                    j.outputObject.error((Object)e.getLocalizedMessage());
                    continue;
                }
                e.printStackTrace();
            }
            finally {
                if (nc != null) {
                    nc.setOutputObj(null);
                    nc = null;
                }
                if (j == null || j.outputObject == null) continue;
                j.outputObject.executeCodeCallback();
            }
        }
        NamespaceClient.delBeaker((String)this.groovyEvaluator.getSessionId());
    }

    private void reloadClassloader() throws MalformedURLException {
        this.groovyClassLoader = GroovyClassLoaderFactory.newEvaluator(this.groovyEvaluator.getImports(), this.groovyEvaluator.getClasspath(), this.groovyEvaluator.getOutDir());
        this.scriptBinding = new Binding();
    }

    void updateLoader() {
        this.updateLoader = true;
    }

    void doExit() {
        this.exit = true;
    }

    GroovyClassLoader getGroovyClassLoader() {
        return this.groovyClassLoader;
    }

    GroovyClassLoader getGroovyClassLoaderInstance() {
        if (this.groovyClassLoader == null) {
            try {
                this.reloadClassloader();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return this.groovyClassLoader;
    }

    Binding getScriptBinding() {
        return this.scriptBinding;
    }
}

