/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.groovy.autocomplete;

import com.twosigma.beakerx.autocomplete.AutocompleteCandidate;
import com.twosigma.beakerx.autocomplete.AutocompleteRegistry;
import com.twosigma.beakerx.autocomplete.ClassUtils;
import com.twosigma.beakerx.groovy.autocomplete.GroovyAbstractListener;
import com.twosigma.beakerx.groovy.autocomplete.GroovyParser;
import org.antlr.v4.runtime.tree.ParseTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyNameBuilder
extends GroovyAbstractListener {
    private static final Logger logger = LoggerFactory.getLogger((String)GroovyNameBuilder.class.getName());
    private AutocompleteRegistry registry;
    private ClassUtils classUtils;

    public GroovyNameBuilder(AutocompleteRegistry r, ClassUtils cu) {
        this.registry = r;
        this.classUtils = cu;
    }

    @Override
    public void exitDeclarationRule(GroovyParser.DeclarationRuleContext ctx) {
        if (ctx.getChildCount() == 4 && ctx.getChild(0) instanceof GroovyParser.TypeDeclarationContext && ctx.getChild(3) instanceof GroovyParser.ExpressionContext && ctx.getChild(3).getChildCount() > 0 && !ctx.getChild(1).getText().contains(".")) {
            if (ctx.getChild(3).getChild(0) instanceof GroovyParser.PathExpressionContext) {
                String typpen = ctx.getChild(3).getChild(0).getText().trim();
                AutocompleteCandidate c = new AutocompleteCandidate(3, ctx.getChild(1).getText());
                this.registry.addCandidate(c);
                if (this.classUtils.getVariableType(typpen) != null) {
                    this.classUtils.defineVariable(ctx.getChild(1).getText(), this.classUtils.getVariableType(typpen));
                }
            } else if (ctx.getChild(3).getChild(0) instanceof GroovyParser.NewInstanceRuleContext) {
                this.nameDeclaration(ctx);
            } else {
                String typpen = null;
                if (ctx.getChild(3) instanceof GroovyParser.ListConstructorContext) {
                    typpen = "Array";
                } else if (ctx.getChild(3) instanceof GroovyParser.MapConstructorContext) {
                    typpen = "Map";
                } else {
                    switch (((GroovyParser.ExpressionContext)ctx.getChild(3)).getStart().getType()) {
                        case 9: {
                            typpen = "String";
                            break;
                        }
                        case 16: {
                            typpen = "Integer";
                            break;
                        }
                        case 15: {
                            typpen = "Double";
                        }
                    }
                }
                AutocompleteCandidate c = new AutocompleteCandidate(3, ctx.getChild(1).getText());
                this.registry.addCandidate(c);
                if (typpen != null) {
                    this.classUtils.defineVariable(ctx.getChild(1).getText(), typpen);
                }
            }
        }
    }

    private void nameDeclaration(GroovyParser.DeclarationRuleContext ctx) {
        ParseTree t = this.findChildrenByType(ctx.getChild(3).getChild(0), GroovyParser.ClassNameExpressionContext.class);
        if (t != null) {
            String ttype = t.getText().trim();
            AutocompleteCandidate c = new AutocompleteCandidate(3, ctx.getChild(1).getText());
            this.registry.addCandidate(c);
            if (ttype != null) {
                this.classUtils.defineVariable(ctx.getChild(1).getText(), ttype);
            }
        }
    }

    @Override
    public void exitAssignmentExpression(GroovyParser.AssignmentExpressionContext ctx) {
        if (ctx.getChildCount() == 3 && ctx.getChild(1).getText().equals("=") && !ctx.getChild(0).getText().contains(".")) {
            ParseTree child = ctx.getChild(2).getChild(0);
            if (child instanceof GroovyParser.PathExpressionContext) {
                this.handlePathExpressionContext(ctx);
            } else if (child instanceof GroovyParser.NewInstanceRuleContext || child instanceof GroovyParser.NewArrayRuleContext) {
                this.handleRuleContext(ctx, child);
            } else {
                this.handleRestOfCases(ctx);
            }
        }
    }

    private void handleRestOfCases(GroovyParser.AssignmentExpressionContext ctx) {
        String typpen = null;
        switch (((GroovyParser.ExpressionContext)ctx.getChild(2)).getStart().getType()) {
            case 9: {
                typpen = "String";
                break;
            }
            case 16: {
                typpen = "Integer";
                break;
            }
            case 15: {
                typpen = "Double";
            }
        }
        AutocompleteCandidate c = new AutocompleteCandidate(3, ctx.getChild(0).getText());
        this.registry.addCandidate(c);
        if (typpen != null) {
            this.classUtils.defineVariable(ctx.getChild(0).getText(), typpen);
        }
    }

    private void handleRuleContext(GroovyParser.AssignmentExpressionContext ctx, ParseTree child) {
        ParseTree t = this.findChildrenByType(child, GroovyParser.ClassNameExpressionContext.class);
        if (t != null) {
            String ttype = t.getText().trim();
            AutocompleteCandidate c = new AutocompleteCandidate(3, ctx.getChild(0).getText());
            this.registry.addCandidate(c);
            if (ttype != null) {
                this.classUtils.defineVariable(ctx.getChild(0).getText(), ttype);
            }
        }
    }

    private void handlePathExpressionContext(GroovyParser.AssignmentExpressionContext ctx) {
        String typpen = ctx.getChild(2).getChild(0).getText().trim();
        AutocompleteCandidate c = new AutocompleteCandidate(3, ctx.getChild(0).getText());
        this.registry.addCandidate(c);
        if (this.classUtils.getVariableType(typpen) != null) {
            this.classUtils.defineVariable(ctx.getChild(0).getText(), this.classUtils.getVariableType(typpen));
        }
    }

    private ParseTree findChildrenByType(ParseTree parseTree, Class<?> classtype) {
        for (int i = 0; i < parseTree.getChildCount(); ++i) {
            ParseTree chl = parseTree.getChild(i);
            if (!chl.getClass().equals(classtype)) continue;
            return chl;
        }
        return null;
    }
}

