/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.twosigma.beakerx.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beakerx.jvm.serialization.ObjectSerializer;
import java.io.IOException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Iterable;
import scala.collection.JavaConversions;
import scala.collection.immutable.Seq;

public class ScalaCollectionSerializer
implements ObjectSerializer {
    private static final Logger logger = LoggerFactory.getLogger((String)ScalaCollectionSerializer.class.getName());
    private final BeakerObjectConverter parent;

    public ScalaCollectionSerializer(BeakerObjectConverter p) {
        this.parent = p;
    }

    public boolean canBeUsed(Object obj, boolean expand) {
        return obj instanceof Seq;
    }

    public boolean writeObject(Object obj, JsonGenerator jgen, boolean expand) throws JsonProcessingException, IOException {
        logger.debug("collection");
        Collection c = JavaConversions.asJavaCollection((Iterable)((Iterable)obj));
        jgen.writeStartArray();
        for (Object o : c) {
            if (this.parent.writeObject(o, jgen, false)) continue;
            jgen.writeObject((Object)o.toString());
        }
        jgen.writeEndArray();
        return true;
    }
}

