/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.plexus.scanners;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.component.annotations.Component;
import org.sonatype.guice.bean.reflect.ClassSpace;
import org.sonatype.guice.bean.reflect.DeferredClass;
import org.sonatype.guice.bean.reflect.Logs;
import org.sonatype.guice.bean.reflect.URLClassSpace;
import org.sonatype.guice.plexus.annotations.ComponentImpl;
import org.sonatype.guice.plexus.config.Hints;
import org.sonatype.guice.plexus.config.Roles;
import org.sonatype.guice.plexus.scanners.CloningClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PlexusTypeRegistry {
    private static final Component LOAD_ON_START_PLACEHOLDER = new ComponentImpl(Object.class, "", "load-on-start", "");
    private final Map<String, Component> components = new HashMap<String, Component>();
    private final Map<String, DeferredClass<?>> implementations = new HashMap();
    private final Set<String> deferredNames = new HashSet<String>();
    final ClassSpace space;
    private ClassSpace cloningClassSpace;
    private int cloneCounter;

    PlexusTypeRegistry(ClassSpace space) {
        this.space = space;
    }

    ClassSpace getSpace() {
        return this.space;
    }

    void loadOnStart(String role, String hint) {
        String key = Roles.canonicalRoleHint(role, hint);
        Component c = this.components.get(key);
        if (null == c) {
            this.components.put(key, LOAD_ON_START_PLACEHOLDER);
        } else if (!"load-on-start".equals(c.instantiationStrategy())) {
            this.components.put(key, new ComponentImpl(c.role(), c.hint(), "load-on-start", c.description()));
        }
    }

    String addComponent(String role, String hint, String instantiationStrategy, String description, String implementation) {
        Class<?> roleType = this.loadRole(role, implementation);
        if (null == roleType) {
            return null;
        }
        String canonicalHint = Hints.canonicalHint(hint);
        String key = Roles.canonicalRoleHint(role, canonicalHint);
        Component oldComponent = this.components.get(key);
        if (null == oldComponent) {
            this.components.put(key, new ComponentImpl(roleType, canonicalHint, instantiationStrategy, description));
        } else if (LOAD_ON_START_PLACEHOLDER == oldComponent) {
            this.components.put(key, new ComponentImpl(roleType, canonicalHint, "load-on-start", description));
        }
        Object implementationType = this.implementations.get(key);
        if (null == implementationType) {
            implementationType = this.deferredNames.add(implementation) ? this.space.deferLoadClass(implementation) : this.cloneImplementation(implementation);
            this.implementations.put(key, (DeferredClass<?>)implementationType);
            return implementationType.getName();
        }
        String oldImplementation = implementationType.getName();
        if (implementation.equals(CloningClassLoader.getRealName(oldImplementation))) {
            return oldImplementation;
        }
        Logs.debug((String)"Duplicate implementations for Plexus role: {}", (Object)key, null);
        Logs.debug((String)"Using: {} ignoring: {}", (Object)oldImplementation, (Object)implementation);
        return null;
    }

    Map<Component, DeferredClass<?>> getComponents() {
        HashMap map = new HashMap();
        for (Map.Entry<String, DeferredClass<?>> i : this.implementations.entrySet()) {
            map.put(this.components.get(i.getKey()), i.getValue());
        }
        return map;
    }

    private Class<?> loadRole(String role, String implementation) {
        try {
            return this.space.loadClass(role);
        }
        catch (Throwable e) {
            Logs.debug((String)"Ignoring Plexus role: {}", (Object)role, (Object)e);
            return null;
        }
    }

    private DeferredClass<?> cloneImplementation(String implementation) {
        if (null == this.cloningClassSpace) {
            this.cloningClassSpace = new URLClassSpace(AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return new CloningClassLoader(PlexusTypeRegistry.this.space);
                }
            }), null);
        }
        return this.cloningClassSpace.deferLoadClass(CloningClassLoader.proxyName(implementation, ++this.cloneCounter));
    }
}

