/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.ClassTranslator;
import org.jetbrains.kotlin.js.translate.declaration.DefaultPropertyTranslator;
import org.jetbrains.kotlin.js.translate.declaration.PropertyTranslatorKt;
import org.jetbrains.kotlin.js.translate.expression.FunctionTranslatorKt;
import org.jetbrains.kotlin.js.translate.general.TranslatorVisitor;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH$J\"\u0010\r\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\fH$J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u000eH$J \u0010\u0015\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0013H\u0016R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/js/translate/declaration/AbstractDeclarationVisitor;", "Lorg/jetbrains/kotlin/js/translate/general/TranslatorVisitor;", "", "()V", "enumInitializerName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "getEnumInitializerName", "()Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "addFunction", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "expression", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "addProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getter", "setter", "emptyResult", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "getBackingFieldReference", "translateFunction", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "visitClassOrObject", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitNamedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "data", "kotlin-compiler"})
public abstract class AbstractDeclarationVisitor
extends TranslatorVisitor<Unit> {
    @Override
    protected void emptyResult(@NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
    }

    @Nullable
    public JsName getEnumInitializerName() {
        return null;
    }

    @Override
    public void visitClassOrObject(@NotNull KtClassOrObject classOrObject, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(classOrObject, "classOrObject");
        Intrinsics.checkParameterIsNotNull(context, "context");
        ClassTranslator.Companion.translate(classOrObject, context, this.getEnumInitializerName());
        ClassDescriptor descriptor2 = BindingUtils.getClassDescriptor(context.bindingContext(), classOrObject);
        context.export(descriptor2);
    }

    @Override
    public void visitProperty(@NotNull KtProperty expression2, @NotNull TranslationContext context) {
        JsExpression setterExpr;
        JsExpression jsExpression;
        JsExpression getterExpr;
        JsExpression jsExpression2;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        PropertyDescriptor descriptor2 = BindingUtils.getPropertyDescriptor(context.bindingContext(), expression2);
        if (descriptor2.getModality() == Modality.ABSTRACT) {
            return;
        }
        TranslationContext propertyContext = context.newDeclaration(descriptor2);
        PropertyDescriptor propertyDescriptor = descriptor2;
        Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor, "descriptor");
        VariableDescriptorWithAccessors variableDescriptorWithAccessors = propertyDescriptor;
        PropertyDescriptor propertyDescriptor2 = descriptor2;
        Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor2, "descriptor");
        DefaultPropertyTranslator defaultTranslator = new DefaultPropertyTranslator(variableDescriptorWithAccessors, context, this.getBackingFieldReference(propertyDescriptor2));
        PropertyGetterDescriptor propertyGetterDescriptor = descriptor2.getGetter();
        if (propertyGetterDescriptor == null) {
            Intrinsics.throwNpe();
        }
        PropertyGetterDescriptor getter2 = propertyGetterDescriptor;
        if (PropertyTranslatorKt.hasCustomGetter(expression2)) {
            PropertyGetterDescriptor propertyGetterDescriptor2 = getter2;
            Intrinsics.checkExpressionValueIsNotNull(propertyGetterDescriptor2, "getter");
            FunctionDescriptor functionDescriptor = propertyGetterDescriptor2;
            KtPropertyAccessor ktPropertyAccessor = expression2.getGetter();
            if (ktPropertyAccessor == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(ktPropertyAccessor, "expression.getter!!");
            KtDeclarationWithBody ktDeclarationWithBody = ktPropertyAccessor;
            TranslationContext translationContext = propertyContext;
            Intrinsics.checkExpressionValueIsNotNull(translationContext, "propertyContext");
            jsExpression2 = this.translateFunction(functionDescriptor, ktDeclarationWithBody, translationContext);
        } else {
            JsFunction function2 = context.getFunctionObject(getter2);
            PropertyGetterDescriptor propertyGetterDescriptor3 = getter2;
            Intrinsics.checkExpressionValueIsNotNull(propertyGetterDescriptor3, "getter");
            VariableAccessorDescriptor variableAccessorDescriptor = propertyGetterDescriptor3;
            JsFunction jsFunction = function2;
            Intrinsics.checkExpressionValueIsNotNull(jsFunction, "function");
            defaultTranslator.generateDefaultGetterFunction(variableAccessorDescriptor, jsFunction);
            JsFunction jsFunction2 = function2;
            Intrinsics.checkExpressionValueIsNotNull(jsFunction2, "function");
            jsExpression2 = getterExpr = (JsExpression)jsFunction2;
        }
        if (descriptor2.isVar()) {
            PropertySetterDescriptor propertySetterDescriptor = descriptor2.getSetter();
            if (propertySetterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            PropertySetterDescriptor setter2 = propertySetterDescriptor;
            if (PropertyTranslatorKt.hasCustomSetter(expression2)) {
                PropertySetterDescriptor propertySetterDescriptor2 = setter2;
                Intrinsics.checkExpressionValueIsNotNull(propertySetterDescriptor2, "setter");
                FunctionDescriptor functionDescriptor = propertySetterDescriptor2;
                KtPropertyAccessor ktPropertyAccessor = expression2.getSetter();
                if (ktPropertyAccessor == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(ktPropertyAccessor, "expression.setter!!");
                KtDeclarationWithBody ktDeclarationWithBody = ktPropertyAccessor;
                TranslationContext translationContext = propertyContext;
                Intrinsics.checkExpressionValueIsNotNull(translationContext, "propertyContext");
                jsExpression = this.translateFunction(functionDescriptor, ktDeclarationWithBody, translationContext);
            } else {
                JsFunction function3 = context.getFunctionObject(setter2);
                PropertySetterDescriptor propertySetterDescriptor3 = setter2;
                Intrinsics.checkExpressionValueIsNotNull(propertySetterDescriptor3, "setter");
                VariableAccessorDescriptor variableAccessorDescriptor = propertySetterDescriptor3;
                JsFunction jsFunction = function3;
                Intrinsics.checkExpressionValueIsNotNull(jsFunction, "function");
                defaultTranslator.generateDefaultSetterFunction(variableAccessorDescriptor, jsFunction);
                JsFunction jsFunction3 = function3;
                Intrinsics.checkExpressionValueIsNotNull(jsFunction3, "function");
                jsExpression = jsFunction3;
            }
        } else {
            jsExpression = setterExpr = null;
        }
        if (TranslationUtils.shouldAccessViaFunctions((CallableDescriptor)descriptor2) || DescriptorUtilsKt.isExtensionProperty(descriptor2)) {
            PropertyGetterDescriptor propertyGetterDescriptor4 = descriptor2.getGetter();
            if (propertyGetterDescriptor4 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(propertyGetterDescriptor4, "descriptor.getter!!");
            this.addFunction(propertyGetterDescriptor4, getterExpr);
            PropertySetterDescriptor propertySetterDescriptor = descriptor2.getSetter();
            if (propertySetterDescriptor != null) {
                PropertySetterDescriptor propertySetterDescriptor4;
                PropertySetterDescriptor it;
                PropertySetterDescriptor propertySetterDescriptor5 = it = (propertySetterDescriptor4 = propertySetterDescriptor);
                Intrinsics.checkExpressionValueIsNotNull(propertySetterDescriptor5, "it");
                FunctionDescriptor functionDescriptor = propertySetterDescriptor5;
                JsExpression jsExpression3 = setterExpr;
                if (jsExpression3 == null) {
                    Intrinsics.throwNpe();
                }
                this.addFunction(functionDescriptor, jsExpression3);
            }
        } else {
            PropertyDescriptor propertyDescriptor3 = descriptor2;
            Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor3, "descriptor");
            this.addProperty(propertyDescriptor3, getterExpr, setterExpr);
        }
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction expression2, @NotNull TranslationContext context) {
        JsExpression jsExpression;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        FunctionDescriptor descriptor2 = BindingUtils.getFunctionDescriptor(context.bindingContext(), expression2);
        if (Intrinsics.areEqual((Object)descriptor2.getModality(), (Object)Modality.ABSTRACT) ^ true) {
            FunctionDescriptor functionDescriptor = descriptor2;
            Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "descriptor");
            jsExpression = this.translateFunction(functionDescriptor, expression2, context);
        } else {
            jsExpression = null;
        }
        JsExpression jsFunction = jsExpression;
        FunctionDescriptor functionDescriptor = descriptor2;
        Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "descriptor");
        this.addFunction(functionDescriptor, jsFunction);
    }

    @Override
    public void visitTypeAlias(@NotNull KtTypeAlias typeAlias, @Nullable TranslationContext data2) {
        Intrinsics.checkParameterIsNotNull(typeAlias, "typeAlias");
    }

    private final JsExpression translateFunction(FunctionDescriptor descriptor2, KtDeclarationWithBody expression2, TranslationContext context) {
        JsFunction function2 = context.getFunctionObject(descriptor2);
        TranslationContext translationContext = context.newDeclaration(descriptor2);
        List<JsParameter> list2 = function2.getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "function.parameters");
        TranslationContext innerContext = FunctionTranslatorKt.translateAndAliasParameters(translationContext, descriptor2, list2);
        if (descriptor2.isSuspend() && UtilsKt.requiresStateMachineTransformation(descriptor2, context)) {
            UtilsKt.fillCoroutineMetadata(function2, context, descriptor2, false);
        }
        if (!ModalityKt.isOverridable(descriptor2)) {
            Collection collection = function2.getBody().getStatements();
            List<JsStatement> list3 = FunctionBodyTranslator.setDefaultValueForArguments(descriptor2, innerContext);
            Intrinsics.checkExpressionValueIsNotNull(list3, "FunctionBodyTranslator.s\u2026descriptor, innerContext)");
            Iterable iterable = list3;
            CollectionsKt.addAll(collection, iterable);
        }
        JsFunction jsFunction = function2;
        Intrinsics.checkExpressionValueIsNotNull(jsFunction, "function");
        FunctionTranslatorKt.translateFunction(innerContext, expression2, jsFunction);
        JsFunction jsFunction2 = function2;
        Intrinsics.checkExpressionValueIsNotNull(jsFunction2, "function");
        return FunctionTranslatorKt.wrapWithInlineMetadata(innerContext, jsFunction2, descriptor2);
    }

    protected abstract void addFunction(@NotNull FunctionDescriptor var1, @Nullable JsExpression var2);

    protected abstract void addProperty(@NotNull PropertyDescriptor var1, @NotNull JsExpression var2, @Nullable JsExpression var3);

    @NotNull
    protected abstract JsExpression getBackingFieldReference(@NotNull PropertyDescriptor var1);
}

