/*
 * Decompiled with CFR 0.152.
 */
package kotlin.jvm.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class SpreadBuilder {
    private final ArrayList<Object> list;

    public SpreadBuilder(int size) {
        this.list = new ArrayList(size);
    }

    public void addSpread(Object container2) {
        if (container2 == null) {
            return;
        }
        if (container2 instanceof Object[]) {
            Object[] array = (Object[])container2;
            if (array.length > 0) {
                this.list.ensureCapacity(this.list.size() + array.length);
                for (Object element : array) {
                    this.list.add(element);
                }
            }
        } else if (container2 instanceof Collection) {
            this.list.addAll((Collection)container2);
        } else if (container2 instanceof Iterable) {
            for (Object element : (Iterable)container2) {
                this.list.add(element);
            }
        } else if (container2 instanceof Iterator) {
            Iterator iterator2 = (Iterator)container2;
            while (iterator2.hasNext()) {
                this.list.add(iterator2.next());
            }
        } else {
            throw new UnsupportedOperationException("Don't know how to spread " + container2.getClass());
        }
    }

    public int size() {
        return this.list.size();
    }

    public void add(Object element) {
        this.list.add(element);
    }

    public Object[] toArray(Object[] a) {
        return this.list.toArray(a);
    }
}

