/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class HierarchicalMethodSignatureImpl
extends HierarchicalMethodSignature {
    private List<HierarchicalMethodSignature> mySupers;
    private List<HierarchicalMethodSignature> myInaccessibleSupers;

    public HierarchicalMethodSignatureImpl(@NotNull MethodSignatureBackedByPsiMethod signature2) {
        if (signature2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/psi/impl/source/HierarchicalMethodSignatureImpl", "<init>"));
        }
        super(signature2);
    }

    public void addSuperSignature(@NotNull HierarchicalMethodSignature superSignatureHierarchical) {
        if (superSignatureHierarchical == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superSignatureHierarchical", "com/intellij/psi/impl/source/HierarchicalMethodSignatureImpl", "addSuperSignature"));
        }
        PsiMethod superMethod = superSignatureHierarchical.getMethod();
        PsiMethod method = this.getMethod();
        if (PsiUtil.isAccessible(method.getProject(), superMethod, method, null)) {
            if (this.mySupers == null) {
                this.mySupers = new SmartList<HierarchicalMethodSignature>();
            }
            this.mySupers.add(superSignatureHierarchical);
        } else {
            if (this.myInaccessibleSupers == null) {
                this.myInaccessibleSupers = new SmartList<HierarchicalMethodSignature>();
            }
            this.myInaccessibleSupers.add(superSignatureHierarchical);
        }
    }

    @Override
    @NotNull
    public List<HierarchicalMethodSignature> getSuperSignatures() {
        List<Object> list2 = this.mySupers == null ? Collections.emptyList() : this.mySupers;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/HierarchicalMethodSignatureImpl", "getSuperSignatures"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<HierarchicalMethodSignature> getInaccessibleSuperSignatures() {
        List<HierarchicalMethodSignature> list2 = this.myInaccessibleSupers == null ? super.getInaccessibleSuperSignatures() : this.myInaccessibleSupers;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/HierarchicalMethodSignatureImpl", "getInaccessibleSuperSignatures"));
        }
        return list2;
    }
}

