/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf.context;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.h2.bnf.context.DbContents;

public class DbColumn {
    private final String name;
    private final String quotedName;
    private final String dataType;
    private int position;

    private DbColumn(DbContents dbContents, ResultSet resultSet, boolean bl) throws SQLException {
        this.name = resultSet.getString("COLUMN_NAME");
        this.quotedName = dbContents.quoteIdentifier(this.name);
        String string = resultSet.getString("TYPE_NAME");
        String string2 = bl ? "PRECISION" : "COLUMN_SIZE";
        int n = resultSet.getInt(string2);
        this.position = resultSet.getInt("ORDINAL_POSITION");
        boolean bl2 = dbContents.isSQLite();
        if (n > 0 && !bl2) {
            string = string + "(" + n;
            String string3 = bl ? "SCALE" : "DECIMAL_DIGITS";
            int n2 = resultSet.getInt(string3);
            if (n2 > 0) {
                string = string + ", " + n2;
            }
            string = string + ")";
        }
        if (resultSet.getInt("NULLABLE") == 0) {
            string = string + " NOT NULL";
        }
        this.dataType = string;
    }

    public static DbColumn getProcedureColumn(DbContents dbContents, ResultSet resultSet) throws SQLException {
        return new DbColumn(dbContents, resultSet, true);
    }

    public static DbColumn getColumn(DbContents dbContents, ResultSet resultSet) throws SQLException {
        return new DbColumn(dbContents, resultSet, false);
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getName() {
        return this.name;
    }

    public String getQuotedName() {
        return this.quotedName;
    }

    public int getPosition() {
        return this.position;
    }
}

