/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.intrinsics;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicCallable;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\\\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032,\u0010\u0007\u001a(\u0012\u0004\u0012\u00020\u0001\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\b\u00a2\u0006\u0002\b\u000e\u001a<\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112,\u0010\u0012\u001a(\u0012\u0004\u0012\u00020\u0001\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\b\u00a2\u0006\u0002\b\u000e\u001a^\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00032,\u0010\u0012\u001a(\u0012\u0004\u0012\u00020\u0001\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\b\u00a2\u0006\u0002\b\u000e\u00a8\u0006\u0018"}, d2={"createBinaryIntrinsicCallable", "Lorg/jetbrains/kotlin/codegen/intrinsics/IntrinsicCallable;", "returnType", "Lorg/jetbrains/org/objectweb/asm/Type;", "valueParameterType", "thisType", "receiverType", "lambda", "Lkotlin/Function2;", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "Lkotlin/ParameterName;", "name", "v", "", "Lkotlin/ExtensionFunctionType;", "createIntrinsicCallable", "callable", "Lorg/jetbrains/kotlin/codegen/CallableMethod;", "invoke", "createUnaryIntrinsicCallable", "newReturnType", "needPrimitiveCheck", "", "newThisType", "kotlin-compiler"})
public final class IntrinsicCallableKt {
    @NotNull
    public static final IntrinsicCallable createBinaryIntrinsicCallable(@NotNull Type returnType, @NotNull Type valueParameterType, @Nullable Type thisType, @Nullable Type receiverType, @NotNull Function2<? super IntrinsicCallable, ? super InstructionAdapter, Unit> lambda2) {
        Intrinsics.checkParameterIsNotNull(returnType, "returnType");
        Intrinsics.checkParameterIsNotNull(valueParameterType, "valueParameterType");
        Intrinsics.checkParameterIsNotNull(lambda2, "lambda");
        boolean bl = AsmUtil.isPrimitive(returnType);
        if (_Assertions.ENABLED && !bl) {
            String string = "Return type of BinaryOp intrinsic should be of primitive type: " + returnType;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return new IntrinsicCallable(lambda2, returnType, valueParameterType, thisType, receiverType, returnType, CollectionsKt.listOf(valueParameterType), thisType, receiverType){
            final /* synthetic */ Function2 $lambda;
            final /* synthetic */ Type $returnType;
            final /* synthetic */ Type $valueParameterType;
            final /* synthetic */ Type $thisType;
            final /* synthetic */ Type $receiverType;

            public void invokeIntrinsic(@NotNull InstructionAdapter v) {
                Intrinsics.checkParameterIsNotNull(v, "v");
                this.$lambda.invoke(this, v);
            }
            {
                this.$lambda = $captured_local_variable$0;
                this.$returnType = $captured_local_variable$1;
                this.$valueParameterType = $captured_local_variable$2;
                this.$thisType = $captured_local_variable$3;
                this.$receiverType = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7, $super_call_param$8, null, 16, null);
            }
        };
    }

    @NotNull
    public static /* bridge */ /* synthetic */ IntrinsicCallable createBinaryIntrinsicCallable$default(Type type2, Type type3, Type type4, Type type5, Function2 function2, int n, Object object) {
        if ((n & 4) != 0) {
            type4 = null;
        }
        if ((n & 8) != 0) {
            type5 = null;
        }
        return IntrinsicCallableKt.createBinaryIntrinsicCallable(type2, type3, type4, type5, function2);
    }

    @NotNull
    public static final IntrinsicCallable createUnaryIntrinsicCallable(@NotNull CallableMethod callable, @Nullable Type newReturnType, boolean needPrimitiveCheck, @Nullable Type newThisType, @NotNull Function2<? super IntrinsicCallable, ? super InstructionAdapter, Unit> invoke2) {
        Intrinsics.checkParameterIsNotNull(callable, "callable");
        Intrinsics.checkParameterIsNotNull(invoke2, "invoke");
        Type type2 = newReturnType;
        if (type2 == null) {
            type2 = callable.getReturnType();
        }
        List<Type> list2 = callable.getValueParameterTypes();
        Type type3 = newThisType;
        if (type3 == null) {
            type3 = callable.getDispatchReceiverType();
        }
        IntrinsicCallable intrinsic = new IntrinsicCallable(type2, list2, type3, callable.getExtensionReceiverType(), invoke2);
        boolean bl = intrinsic.getValueParameterTypes().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Unary operation should not have any parameters";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (needPrimitiveCheck) {
            bl = AsmUtil.isPrimitive(intrinsic.getReturnType());
            if (_Assertions.ENABLED && !bl) {
                String string = "Return type of UnaryPlus intrinsic should be of primitive type: " + intrinsic.getReturnType();
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
        return intrinsic;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ IntrinsicCallable createUnaryIntrinsicCallable$default(CallableMethod callableMethod, Type type2, boolean bl, Type type3, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            type2 = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            type3 = null;
        }
        return IntrinsicCallableKt.createUnaryIntrinsicCallable(callableMethod, type2, bl, type3, function2);
    }

    @NotNull
    public static final IntrinsicCallable createIntrinsicCallable(@NotNull CallableMethod callable, @NotNull Function2<? super IntrinsicCallable, ? super InstructionAdapter, Unit> invoke2) {
        Intrinsics.checkParameterIsNotNull(callable, "callable");
        Intrinsics.checkParameterIsNotNull(invoke2, "invoke");
        return new IntrinsicCallable(callable, invoke2);
    }
}

