/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public abstract class WritingAccessProvider {
    public static final ExtensionPointName<WritingAccessProvider> EP_NAME = ExtensionPointName.create("com.intellij.writingAccessProvider");

    public abstract boolean isPotentiallyWritable(@NotNull VirtualFile var1);

    public static WritingAccessProvider[] getProvidersForProject(Project project) {
        return project == null || project.isDefault() ? new WritingAccessProvider[]{} : Extensions.getExtensions(EP_NAME, (AreaInstance)project);
    }

    public static boolean isPotentiallyWritable(VirtualFile file2, Project project) {
        WritingAccessProvider[] providers;
        for (WritingAccessProvider provider : providers = WritingAccessProvider.getProvidersForProject(project)) {
            if (provider.isPotentiallyWritable(file2)) continue;
            return false;
        }
        return true;
    }
}

