/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTreeUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.util.PsiTreeUtil");
    private static final Key<Integer> INDEX = Key.create("PsiTreeUtil.copyElements.INDEX");
    private static final Key<Object> MARKER = Key.create("PsiTreeUtil.copyElements.MARKER");

    @Contract(value="null, _, _ -> false")
    public static boolean isAncestor(@Nullable PsiElement ancestor, @NotNull PsiElement element, boolean strict) {
        PsiElement parent2;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/PsiTreeUtil", "isAncestor"));
        }
        if (ancestor == null) {
            return false;
        }
        if ((ancestor instanceof StubBasedPsiElement && ((StubBasedPsiElement)ancestor).getStub() != null || element instanceof StubBasedPsiElement && ((StubBasedPsiElement)element).getStub() != null) && ancestor.getContainingFile() != element.getContainingFile()) {
            return false;
        }
        boolean stopAtFileLevel = !(ancestor instanceof PsiFile) && !(ancestor instanceof PsiDirectory);
        PsiElement psiElement = parent2 = strict ? element.getParent() : element;
        while (parent2 != null) {
            if (parent2.equals(ancestor)) {
                return true;
            }
            if (stopAtFileLevel && parent2 instanceof PsiFile) {
                return false;
            }
            parent2 = parent2.getParent();
        }
        return false;
    }

    @Contract(value="null, _, _ -> false")
    public static boolean isContextAncestor(@Nullable PsiElement ancestor, @NotNull PsiElement element, boolean strict) {
        PsiElement parent2;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/PsiTreeUtil", "isContextAncestor"));
        }
        if (ancestor == null) {
            return false;
        }
        boolean stopAtFileLevel = !(ancestor instanceof PsiFile) && !(ancestor instanceof PsiDirectory);
        PsiElement psiElement = parent2 = strict ? element.getContext() : element;
        while (parent2 != null) {
            PsiElement context;
            if (parent2.equals(ancestor)) {
                return true;
            }
            if (stopAtFileLevel && parent2 instanceof PsiFile && (context = parent2.getContext()) == null) {
                return false;
            }
            parent2 = parent2.getContext();
        }
        return false;
    }

    @Nullable
    public static PsiElement findCommonParent(@NotNull List<? extends PsiElement> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/psi/util/PsiTreeUtil", "findCommonParent"));
        }
        if (elements.isEmpty()) {
            return null;
        }
        PsiElement toReturn = null;
        for (PsiElement psiElement : elements) {
            if (psiElement == null || (toReturn = toReturn == null ? psiElement : PsiTreeUtil.findCommonParent(toReturn, psiElement)) != null) continue;
            return null;
        }
        return toReturn;
    }

    @Nullable
    public static PsiElement findCommonParent(PsiElement ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/psi/util/PsiTreeUtil", "findCommonParent"));
        }
        if (elements.length == 0) {
            return null;
        }
        PsiElement toReturn = null;
        for (PsiElement element : elements) {
            if (element == null) continue;
            PsiElement psiElement = toReturn = toReturn == null ? element : PsiTreeUtil.findCommonParent(toReturn, element);
            if (toReturn != null) continue;
            return null;
        }
        return toReturn;
    }

    @Nullable
    public static PsiElement findCommonParent(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        int depth1;
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "com/intellij/psi/util/PsiTreeUtil", "findCommonParent"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "com/intellij/psi/util/PsiTreeUtil", "findCommonParent"));
        }
        if (element1 == element2) {
            return element1;
        }
        PsiFile containingFile = element1.getContainingFile();
        PsiFile topLevel = containingFile == element2.getContainingFile() ? containingFile : null;
        int depth2 = PsiTreeUtil.getDepth(element2, topLevel);
        PsiElement parent1 = element1;
        PsiElement parent2 = element2;
        for (depth1 = PsiTreeUtil.getDepth(element1, topLevel); depth1 > depth2; --depth1) {
            parent1 = parent1.getParent();
        }
        while (depth2 > depth1) {
            parent2 = parent2.getParent();
            --depth2;
        }
        while (parent1 != null && parent2 != null && !parent1.equals(parent2)) {
            parent1 = parent1.getParent();
            parent2 = parent2.getParent();
        }
        return parent1;
    }

    @Contract(pure=true)
    private static int getDepth(@NotNull PsiElement element, @Nullable PsiElement topLevel) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/PsiTreeUtil", "getDepth"));
        }
        int depth = 0;
        for (PsiElement parent2 = element; parent2 != topLevel && parent2 != null; parent2 = parent2.getParent()) {
            ++depth;
        }
        return depth;
    }

    @Nullable
    public static PsiElement findCommonContext(@NotNull Collection<? extends PsiElement> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/psi/util/PsiTreeUtil", "findCommonContext"));
        }
        if (elements.isEmpty()) {
            return null;
        }
        PsiElement toReturn = null;
        for (PsiElement psiElement : elements) {
            if (psiElement == null || (toReturn = toReturn == null ? psiElement : PsiTreeUtil.findCommonContext(toReturn, psiElement)) != null) continue;
            return null;
        }
        return toReturn;
    }

    @Nullable
    public static PsiElement findCommonContext(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        PsiElement parent1;
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "com/intellij/psi/util/PsiTreeUtil", "findCommonContext"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "com/intellij/psi/util/PsiTreeUtil", "findCommonContext"));
        }
        if (element1 == element2) {
            return element1;
        }
        PsiFile containingFile = element1.getContainingFile();
        PsiFile topLevel = containingFile == element2.getContainingFile() ? containingFile : null;
        int depth1 = PsiTreeUtil.getContextDepth(element1, topLevel);
        int depth2 = PsiTreeUtil.getContextDepth(element2, topLevel);
        PsiElement parent2 = element2;
        for (parent1 = element1; depth1 > depth2 && parent1 != null; parent1 = parent1.getContext(), --depth1) {
        }
        while (depth2 > depth1 && parent2 != null) {
            parent2 = parent2.getContext();
            --depth2;
        }
        while (parent1 != null && parent2 != null && !parent1.equals(parent2)) {
            parent1 = parent1.getContext();
            parent2 = parent2.getContext();
        }
        return parent1;
    }

    private static int getContextDepth(@NotNull PsiElement element, @Nullable PsiElement topLevel) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/PsiTreeUtil", "getContextDepth"));
        }
        int depth = 0;
        for (PsiElement parent2 = element; parent2 != topLevel && parent2 != null; parent2 = parent2.getContext()) {
            ++depth;
        }
        return depth;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T findChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/PsiTreeUtil", "findChildOfType"));
        }
        return PsiTreeUtil.findChildOfAnyType(element, true, aClass2);
    }

    @Nullable
    @Contract(value="null, _, _ -> null")
    public static <T extends PsiElement> T findChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2, boolean strict) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/PsiTreeUtil", "findChildOfType"));
        }
        return PsiTreeUtil.findChildOfAnyType(element, strict, aClass2);
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T findChildOfAnyType(@Nullable PsiElement element, Class<? extends T> ... classes2) {
        if (classes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/psi/util/PsiTreeUtil", "findChildOfAnyType"));
        }
        return PsiTreeUtil.findChildOfAnyType(element, true, classes2);
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _, _ -> null")
    public static <T extends PsiElement> T findChildOfAnyType(final @Nullable PsiElement element, final boolean strict, final Class<? extends T> ... classes2) {
        if (classes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/psi/util/PsiTreeUtil", "findChildOfAnyType"));
        }
        PsiElementProcessor.FindElement<PsiElement> processor = new PsiElementProcessor.FindElement<PsiElement>(){

            @Override
            public boolean execute(@NotNull PsiElement each) {
                if (each == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/psi/util/PsiTreeUtil$1", "execute"));
                }
                if (strict && each == element) {
                    return true;
                }
                if (PsiTreeUtil.instanceOf(each, classes2)) {
                    return this.setFound(each);
                }
                return true;
            }
        };
        PsiTreeUtil.processElements(element, processor);
        return processor.getFoundElement();
    }

    @NotNull
    public static <T extends PsiElement> Collection<T> findChildrenOfType(@Nullable PsiElement element, @NotNull Class<? extends T> aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/PsiTreeUtil", "findChildrenOfType"));
        }
        Collection<T> collection = PsiTreeUtil.findChildrenOfAnyType(element, aClass2);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiTreeUtil", "findChildrenOfType"));
        }
        return collection;
    }

    @SafeVarargs
    @NotNull
    public static <T extends PsiElement> Collection<T> findChildrenOfAnyType(final @Nullable PsiElement element, final Class<? extends T> ... classes2) {
        if (classes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/psi/util/PsiTreeUtil", "findChildrenOfAnyType"));
        }
        if (element == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiTreeUtil", "findChildrenOfAnyType"));
            }
            return list2;
        }
        PsiElementProcessor.CollectElements processor = new PsiElementProcessor.CollectElements<T>(){

            @Override
            public boolean execute(@NotNull T each) {
                if (each == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/psi/util/PsiTreeUtil$2", "execute"));
                }
                if (each == element) {
                    return true;
                }
                if (PsiTreeUtil.instanceOf(each, classes2)) {
                    return super.execute(each);
                }
                return true;
            }
        };
        PsiTreeUtil.processElements(element, processor);
        Collection collection = processor.getCollection();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiTreeUtil", "findChildrenOfAnyType"));
        }
        return collection;
    }

    @Nullable
    public static <T extends PsiElement> T getChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/PsiTreeUtil", "getChildOfType"));
        }
        if (element == null) {
            return null;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!aClass2.isInstance(child)) continue;
            return (T)child;
        }
        return null;
    }

    @Nullable
    public static PsiElement findFirstParent(@Nullable PsiElement element, Condition<PsiElement> condition) {
        return PsiTreeUtil.findFirstParent(element, false, condition);
    }

    @Nullable
    public static PsiElement findFirstParent(@Nullable PsiElement element, boolean strict, Condition<PsiElement> condition) {
        if (strict && element != null) {
            element = element.getParent();
        }
        while (element != null) {
            if (condition.value(element)) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    @Nullable
    public static PsiElement findFirstContext(@Nullable PsiElement element, boolean strict, Condition<PsiElement> condition) {
        if (strict && element != null) {
            element = element.getContext();
        }
        while (element != null) {
            if (condition.value(element)) {
                return element;
            }
            element = element.getContext();
        }
        return null;
    }

    @NotNull
    public static <T extends PsiElement> T getRequiredChildOfType(@NotNull PsiElement element, @NotNull Class<T> aClass2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/PsiTreeUtil", "getRequiredChildOfType"));
        }
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/PsiTreeUtil", "getRequiredChildOfType"));
        }
        T child = PsiTreeUtil.getChildOfType(element, aClass2);
        assert (child != null) : "Missing required child of type " + aClass2.getName();
        T t = child;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiTreeUtil", "getRequiredChildOfType"));
        }
        return t;
    }

    @Nullable
    public static <T extends PsiElement> T[] getChildrenOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/PsiTreeUtil", "getChildrenOfType"));
        }
        if (element == null) {
            return null;
        }
        SmartList<PsiElement> result2 = null;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!aClass2.isInstance(child)) continue;
            if (result2 == null) {
                result2 = new SmartList<PsiElement>();
            }
            result2.add(child);
        }
        return result2 == null ? null : (PsiElement[])ArrayUtil.toObjectArray(result2, aClass2);
    }

    @SafeVarargs
    @NotNull
    public static <T extends PsiElement> List<T> getChildrenOfAnyType(@Nullable PsiElement element, Class<? extends T> ... classes2) {
        if (classes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/psi/util/PsiTreeUtil", "getChildrenOfAnyType"));
        }
        if (element == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiTreeUtil", "getChildrenOfAnyType"));
            }
            return list2;
        }
        List result2 = null;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!PsiTreeUtil.instanceOf(child, classes2)) continue;
            if (result2 == null) {
                result2 = ContainerUtil.newSmartList();
            }
            result2.add(child);
        }
        if (result2 == null) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiTreeUtil", "getChildrenOfAnyType"));
            }
            return list3;
        }
        List list4 = result2;
        if (list4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiTreeUtil", "getChildrenOfAnyType"));
        }
        return list4;
    }

    @NotNull
    public static <T extends PsiElement> List<T> getChildrenOfTypeAsList(@Nullable PsiElement element, @NotNull Class<T> aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/PsiTreeUtil", "getChildrenOfTypeAsList"));
        }
        if (element == null) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiTreeUtil", "getChildrenOfTypeAsList"));
            }
            return list2;
        }
        SmartList<PsiElement> result2 = new SmartList<PsiElement>();
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!aClass2.isInstance(child)) continue;
            result2.add(child);
        }
        SmartList<PsiElement> smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiTreeUtil", "getChildrenOfTypeAsList"));
        }
        return smartList;
    }

    @Nullable
    public static <T extends PsiElement> T getStubChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2) {
        StubElement stub;
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/PsiTreeUtil", "getStubChildOfType"));
        }
        if (element == null) {
            return null;
        }
        StubElement stubElement = stub = element instanceof StubBasedPsiElement ? (StubElement)((StubBasedPsiElement)element).getStub() : null;
        if (stub == null) {
            return PsiTreeUtil.getChildOfType(element, aClass2);
        }
        for (StubElement childStub : stub.getChildrenStubs()) {
            Object child = childStub.getPsi();
            if (!aClass2.isInstance(child)) continue;
            return child;
        }
        return null;
    }

    @NotNull
    public static <T extends PsiElement> List<T> getStubChildrenOfTypeAsList(@Nullable PsiElement element, @NotNull Class<T> aClass2) {
        StubElement stub;
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/PsiTreeUtil", "getStubChildrenOfTypeAsList"));
        }
        if (element == null) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiTreeUtil", "getStubChildrenOfTypeAsList"));
            }
            return list2;
        }
        StubElement stubElement = stub = element instanceof StubBasedPsiElement ? (StubElement)((StubBasedPsiElement)element).getStub() : null;
        if (stub == null) {
            List<T> list3 = PsiTreeUtil.getChildrenOfTypeAsList(element, aClass2);
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiTreeUtil", "getStubChildrenOfTypeAsList"));
            }
            return list3;
        }
        SmartList result2 = new SmartList();
        for (StubElement childStub : stub.getChildrenStubs()) {
            Object child = childStub.getPsi();
            if (!aClass2.isInstance(child)) continue;
            result2.add(child);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiTreeUtil", "getStubChildrenOfTypeAsList"));
        }
        return smartList;
    }

    public static boolean instanceOf(Object object, Class<?> ... classes2) {
        if (classes2 != null) {
            for (Class<?> c : classes2) {
                if (!c.isInstance(object)) continue;
                return true;
            }
        }
        return false;
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getChildOfAnyType(@Nullable PsiElement element, Class<? extends T> ... classes2) {
        if (classes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/psi/util/PsiTreeUtil", "getChildOfAnyType"));
        }
        if (element == null) {
            return null;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            for (Class<T> clazz : classes2) {
                if (!clazz.isInstance(child)) continue;
                return (T)child;
            }
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getNextSiblingOfType(@Nullable PsiElement sibling, @NotNull Class<T> aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/PsiTreeUtil", "getNextSiblingOfType"));
        }
        if (sibling == null) {
            return null;
        }
        for (PsiElement child = sibling.getNextSibling(); child != null; child = child.getNextSibling()) {
            if (!aClass2.isInstance(child)) continue;
            return (T)child;
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getPrevSiblingOfType(@Nullable PsiElement sibling, @NotNull Class<T> aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/PsiTreeUtil", "getPrevSiblingOfType"));
        }
        if (sibling == null) {
            return null;
        }
        for (PsiElement child = sibling.getPrevSibling(); child != null; child = child.getPrevSibling()) {
            if (!aClass2.isInstance(child)) continue;
            return (T)child;
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getTopmostParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2) {
        T next;
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/PsiTreeUtil", "getTopmostParentOfType"));
        }
        T answer = PsiTreeUtil.getParentOfType(element, aClass2);
        while ((next = PsiTreeUtil.getParentOfType(answer, aClass2)) != null) {
            answer = next;
        }
        return answer;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/PsiTreeUtil", "getParentOfType"));
        }
        return PsiTreeUtil.getParentOfType(element, aClass2, true);
    }

    @Nullable
    @Contract(value="null -> null")
    public static PsiElement getStubOrPsiParent(@Nullable PsiElement element) {
        StubBase stub;
        if (element instanceof StubBasedPsiElement && (stub = (StubBase)((StubBasedPsiElement)element).getStub()) != null) {
            StubElement parentStub = stub.getParentStub();
            return parentStub != null ? (PsiElement)parentStub.getPsi() : null;
        }
        return element != null ? element.getParent() : null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <E extends PsiElement> E getStubOrPsiParentOfType(@Nullable PsiElement element, @NotNull Class<E> parentClass) {
        StubBase stub;
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "com/intellij/psi/util/PsiTreeUtil", "getStubOrPsiParentOfType"));
        }
        if (element instanceof StubBasedPsiElement && (stub = (StubBase)((StubBasedPsiElement)element).getStub()) != null) {
            return stub.getParentStubOfType(parentClass);
        }
        return PsiTreeUtil.getParentOfType(element, parentClass);
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _, _, _ -> null")
    public static <T extends PsiElement> T getContextOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2, boolean strict, Class<? extends PsiElement> ... stopAt) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/PsiTreeUtil", "getContextOfType"));
        }
        if (element == null) {
            return null;
        }
        if (strict) {
            element = element.getContext();
        }
        while (element != null && !aClass2.isInstance(element)) {
            if (PsiTreeUtil.instanceOf(element, stopAt)) {
                return null;
            }
            element = element.getContext();
        }
        return (T)element;
    }

    @Nullable
    @Contract(value="null, _, _ -> null")
    public static <T extends PsiElement> T getContextOfType(@Nullable PsiElement element, @NotNull Class<? extends T> aClass2, boolean strict) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/PsiTreeUtil", "getContextOfType"));
        }
        return PsiTreeUtil.getContextOfType(element, strict, aClass2);
    }

    @SafeVarargs
    @Nullable
    public static <T extends PsiElement> T getContextOfType(@Nullable PsiElement element, Class<? extends T> ... classes2) {
        if (classes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/psi/util/PsiTreeUtil", "getContextOfType"));
        }
        return PsiTreeUtil.getContextOfType(element, true, classes2);
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _, _ -> null")
    public static <T extends PsiElement> T getContextOfType(@Nullable PsiElement element, boolean strict, Class<? extends T> ... classes2) {
        if (classes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/psi/util/PsiTreeUtil", "getContextOfType"));
        }
        if (element == null) {
            return null;
        }
        if (strict) {
            element = element.getContext();
        }
        while (element != null && !PsiTreeUtil.instanceOf(element, classes2)) {
            element = element.getContext();
        }
        return (T)element;
    }

    @Nullable
    @Contract(value="null, _, _ -> null")
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2, boolean strict) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/PsiTreeUtil", "getParentOfType"));
        }
        return PsiTreeUtil.getParentOfType(element, aClass2, strict, -1);
    }

    @Contract(value="null, _, _, _ -> null")
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2, boolean strict, int minStartOffset) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/PsiTreeUtil", "getParentOfType"));
        }
        if (element == null) {
            return null;
        }
        if (strict) {
            if (element instanceof PsiFile) {
                return null;
            }
            element = element.getParent();
        }
        while (element != null && (minStartOffset == -1 || element.getNode().getStartOffset() >= minStartOffset)) {
            if (aClass2.isInstance(element)) {
                return (T)element;
            }
            if (element instanceof PsiFile) {
                return null;
            }
            element = element.getParent();
        }
        return null;
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _, _, _ -> null")
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2, boolean strict, Class<? extends PsiElement> ... stopAt) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/PsiTreeUtil", "getParentOfType"));
        }
        if (stopAt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stopAt", "com/intellij/psi/util/PsiTreeUtil", "getParentOfType"));
        }
        if (element == null) {
            return null;
        }
        if (strict) {
            if (element instanceof PsiFile) {
                return null;
            }
            element = element.getParent();
        }
        while (element != null && !aClass2.isInstance(element)) {
            if (PsiTreeUtil.instanceOf(element, stopAt)) {
                return null;
            }
            if (element instanceof PsiFile) {
                return null;
            }
            element = element.getParent();
        }
        return (T)element;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static PsiElement skipSiblingsForward(@Nullable PsiElement element, Class ... elementClasses) {
        if (elementClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementClasses", "com/intellij/psi/util/PsiTreeUtil", "skipSiblingsForward"));
        }
        if (element == null) {
            return null;
        }
        for (PsiElement e = element.getNextSibling(); e != null; e = e.getNextSibling()) {
            if (PsiTreeUtil.instanceOf(e, elementClasses)) continue;
            return e;
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static PsiElement skipSiblingsBackward(@Nullable PsiElement element, Class ... elementClasses) {
        if (elementClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementClasses", "com/intellij/psi/util/PsiTreeUtil", "skipSiblingsBackward"));
        }
        if (element == null) {
            return null;
        }
        for (PsiElement e = element.getPrevSibling(); e != null; e = e.getPrevSibling()) {
            if (PsiTreeUtil.instanceOf(e, elementClasses)) continue;
            return e;
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static PsiElement skipParentsOfType(@Nullable PsiElement element, Class ... parentClasses) {
        if (parentClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClasses", "com/intellij/psi/util/PsiTreeUtil", "skipParentsOfType"));
        }
        if (element == null) {
            return null;
        }
        for (PsiElement e = element.getParent(); e != null; e = e.getParent()) {
            if (PsiTreeUtil.instanceOf(e, parentClasses)) continue;
            return e;
        }
        return null;
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, Class<? extends T> ... classes2) {
        if (classes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/psi/util/PsiTreeUtil", "getParentOfType"));
        }
        if (element == null || element instanceof PsiFile) {
            return null;
        }
        PsiElement parent2 = element.getParent();
        if (parent2 == null) {
            return null;
        }
        return PsiTreeUtil.getNonStrictParentOfType(parent2, classes2);
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T getNonStrictParentOfType(@Nullable PsiElement element, Class<? extends T> ... classes2) {
        if (classes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/psi/util/PsiTreeUtil", "getNonStrictParentOfType"));
        }
        for (PsiElement run2 = element; run2 != null; run2 = run2.getParent()) {
            if (PsiTreeUtil.instanceOf(run2, classes2)) {
                return (T)run2;
            }
            if (run2 instanceof PsiFile) break;
        }
        return null;
    }

    @NotNull
    public static PsiElement[] collectElements(@Nullable PsiElement element, @NotNull PsiElementFilter filter2) {
        if (filter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/psi/util/PsiTreeUtil", "collectElements"));
        }
        PsiElementProcessor.CollectFilteredElements processor = new PsiElementProcessor.CollectFilteredElements(filter2);
        PsiTreeUtil.processElements(element, processor);
        PsiElement[] psiElementArray = processor.toArray();
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiTreeUtil", "collectElements"));
        }
        return psiElementArray;
    }

    @SafeVarargs
    @NotNull
    public static <T extends PsiElement> Collection<T> collectElementsOfType(@Nullable PsiElement element, Class<T> ... classes2) {
        if (classes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/psi/util/PsiTreeUtil", "collectElementsOfType"));
        }
        PsiElementProcessor.CollectFilteredElements processor = new PsiElementProcessor.CollectFilteredElements(element1 -> {
            if (classes2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/psi/util/PsiTreeUtil", "lambda$collectElementsOfType$0"));
            }
            for (Class clazz : classes2) {
                if (!clazz.isInstance(element1)) continue;
                return true;
            }
            return false;
        });
        PsiTreeUtil.processElements(element, processor);
        Collection collection = processor.getCollection();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiTreeUtil", "collectElementsOfType"));
        }
        return collection;
    }

    @Contract(value="null, _ -> true")
    public static boolean processElements(@Nullable PsiElement element, final @NotNull PsiElementProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/util/PsiTreeUtil", "processElements"));
        }
        if (element == null) {
            return true;
        }
        if (element instanceof PsiCompiledElement || !element.isPhysical()) {
            if (!processor.execute(element)) {
                return false;
            }
            for (PsiElement child : element.getChildren()) {
                if (PsiTreeUtil.processElements(child, processor)) continue;
                return false;
            }
            return true;
        }
        final boolean[] result2 = new boolean[]{true};
        element.accept(new PsiRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                if (processor.execute(element)) {
                    super.visitElement(element);
                } else {
                    this.stopWalking();
                    result2[0] = false;
                }
            }
        });
        return result2[0];
    }

    public static boolean processElements(@NotNull PsiElementProcessor processor, PsiElement ... elements) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/util/PsiTreeUtil", "processElements"));
        }
        if (elements == null || elements.length == 0) {
            return true;
        }
        for (PsiElement element : elements) {
            if (PsiTreeUtil.processElements(element, processor)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static PsiElement[] copyElements(@NotNull PsiElement[] elements) {
        int i;
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/psi/util/PsiTreeUtil", "copyElements"));
        }
        ArrayList<PsiElement> roots2 = new ArrayList<PsiElement>();
        for (i = 0; i < elements.length; ++i) {
            PsiElement rootCandidate = elements[i];
            boolean failed = false;
            for (int j = 0; j < elements.length; ++j) {
                PsiElement element = elements[j];
                if (i == j || !PsiTreeUtil.isAncestor(element, rootCandidate, true)) continue;
                failed = true;
                break;
            }
            if (failed) continue;
            roots2.add(rootCandidate);
        }
        for (i = 0; i < elements.length; ++i) {
            PsiElement element = elements[i];
            element.putCopyableUserData(INDEX, i);
        }
        PsiElement[] newRoots = new PsiElement[roots2.size()];
        for (int i2 = 0; i2 < roots2.size(); ++i2) {
            PsiElement root = (PsiElement)roots2.get(i2);
            newRoots[i2] = root.copy();
        }
        PsiElement[] result2 = new PsiElement[elements.length];
        for (PsiElement newRoot : newRoots) {
            PsiTreeUtil.decodeIndices(newRoot, result2);
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiTreeUtil", "copyElements"));
        }
        return result2;
    }

    private static void decodeIndices(@NotNull PsiElement element, @NotNull PsiElement[] result2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/PsiTreeUtil", "decodeIndices"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/util/PsiTreeUtil", "decodeIndices"));
        }
        Integer data2 = element.getCopyableUserData(INDEX);
        if (data2 != null) {
            element.putCopyableUserData(INDEX, null);
            int index2 = data2;
            result2[index2] = element;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            PsiTreeUtil.decodeIndices(child, result2);
        }
    }

    public static void mark(@NotNull PsiElement element, @NotNull Object marker) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/PsiTreeUtil", "mark"));
        }
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/psi/util/PsiTreeUtil", "mark"));
        }
        element.putCopyableUserData(MARKER, marker);
    }

    @Nullable
    public static PsiElement releaseMark(@NotNull PsiElement root, @NotNull Object marker) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/util/PsiTreeUtil", "releaseMark"));
        }
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/psi/util/PsiTreeUtil", "releaseMark"));
        }
        if (marker.equals(root.getCopyableUserData(MARKER))) {
            root.putCopyableUserData(MARKER, null);
            return root;
        }
        for (PsiElement child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            PsiElement result2 = PsiTreeUtil.releaseMark(child, marker);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    public static <T extends PsiElement> T findElementOfClassAtOffset(@NotNull PsiFile file2, int offset2, @NotNull Class<T> clazz, boolean strictStart) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/util/PsiTreeUtil", "findElementOfClassAtOffset"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/psi/util/PsiTreeUtil", "findElementOfClassAtOffset"));
        }
        List<PsiFile> psiRoots = file2.getViewProvider().getAllFiles();
        PsiElement result2 = null;
        for (PsiElement psiElement : psiRoots) {
            T parent2;
            PsiElement elementAt2 = psiElement.findElementAt(offset2);
            if (elementAt2 == null || (parent2 = PsiTreeUtil.getParentOfType(elementAt2, clazz, strictStart)) == null) continue;
            TextRange range = parent2.getTextRange();
            if (strictStart && range.getStartOffset() != offset2 || result2 != null && result2.getTextRange().getEndOffset() <= range.getEndOffset()) continue;
            result2 = parent2;
        }
        return (T)result2;
    }

    @SafeVarargs
    @Nullable
    public static <T extends PsiElement> T findElementOfClassAtOffsetWithStopSet(@NotNull PsiFile file2, int offset2, @NotNull Class<T> clazz, boolean strictStart, Class<? extends PsiElement> ... stopAt) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/util/PsiTreeUtil", "findElementOfClassAtOffsetWithStopSet"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/psi/util/PsiTreeUtil", "findElementOfClassAtOffsetWithStopSet"));
        }
        if (stopAt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stopAt", "com/intellij/psi/util/PsiTreeUtil", "findElementOfClassAtOffsetWithStopSet"));
        }
        List<PsiFile> psiRoots = file2.getViewProvider().getAllFiles();
        PsiElement result2 = null;
        for (PsiElement psiElement : psiRoots) {
            T parent2;
            PsiElement elementAt2 = psiElement.findElementAt(offset2);
            if (elementAt2 == null || (parent2 = PsiTreeUtil.getParentOfType(elementAt2, clazz, strictStart, stopAt)) == null) continue;
            TextRange range = parent2.getTextRange();
            if (strictStart && range.getStartOffset() != offset2 || result2 != null && result2.getTextRange().getEndOffset() <= range.getEndOffset()) continue;
            result2 = parent2;
        }
        return (T)result2;
    }

    @Nullable
    public static <T extends PsiElement> T findElementOfClassAtRange(@NotNull PsiFile file2, int startOffset, int endOffset, @NotNull Class<T> clazz) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/util/PsiTreeUtil", "findElementOfClassAtRange"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/psi/util/PsiTreeUtil", "findElementOfClassAtRange"));
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        PsiElement result2 = null;
        for (Language lang : viewProvider.getLanguages()) {
            T run2;
            PsiElement elementAt2 = viewProvider.findElementAt(startOffset, lang);
            T prev = run2 = PsiTreeUtil.getParentOfType(elementAt2, clazz, false);
            while (run2 != null && run2.getTextRange().getStartOffset() == startOffset && run2.getTextRange().getEndOffset() <= endOffset) {
                prev = run2;
                run2 = PsiTreeUtil.getParentOfType(run2, clazz);
            }
            if (prev == null) continue;
            int elementStartOffset = prev.getTextRange().getStartOffset();
            int elementEndOffset = prev.getTextRange().getEndOffset();
            if (elementStartOffset != startOffset || elementEndOffset > endOffset || result2 != null && result2.getTextRange().getEndOffset() >= elementEndOffset) continue;
            result2 = prev;
        }
        return (T)result2;
    }

    @NotNull
    public static PsiElement getDeepestFirst(@NotNull PsiElement elt) {
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "com/intellij/psi/util/PsiTreeUtil", "getDeepestFirst"));
        }
        PsiElement res2 = elt;
        while (true) {
            PsiElement firstChild;
            if ((firstChild = res2.getFirstChild()) == null) {
                PsiElement psiElement = res2;
                if (psiElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiTreeUtil", "getDeepestFirst"));
                }
                return psiElement;
            }
            res2 = firstChild;
        }
    }

    @NotNull
    public static PsiElement getDeepestLast(@NotNull PsiElement elt) {
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "com/intellij/psi/util/PsiTreeUtil", "getDeepestLast"));
        }
        PsiElement res2 = elt;
        while (true) {
            PsiElement lastChild;
            if ((lastChild = res2.getLastChild()) == null) {
                PsiElement psiElement = res2;
                if (psiElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiTreeUtil", "getDeepestLast"));
                }
                return psiElement;
            }
            res2 = lastChild;
        }
    }

    @Nullable
    public static PsiElement prevLeaf(@NotNull PsiElement current) {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/psi/util/PsiTreeUtil", "prevLeaf"));
        }
        PsiElement prevSibling = current.getPrevSibling();
        if (prevSibling != null) {
            return PsiTreeUtil.lastChild(prevSibling);
        }
        PsiElement parent2 = current.getParent();
        if (parent2 == null || parent2 instanceof PsiFile) {
            return null;
        }
        return PsiTreeUtil.prevLeaf(parent2);
    }

    @Nullable
    public static PsiElement nextLeaf(@NotNull PsiElement current) {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/psi/util/PsiTreeUtil", "nextLeaf"));
        }
        PsiElement nextSibling = current.getNextSibling();
        if (nextSibling != null) {
            return PsiTreeUtil.firstChild(nextSibling);
        }
        PsiElement parent2 = current.getParent();
        if (parent2 == null || parent2 instanceof PsiFile) {
            return null;
        }
        return PsiTreeUtil.nextLeaf(parent2);
    }

    public static PsiElement lastChild(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/PsiTreeUtil", "lastChild"));
        }
        PsiElement lastChild = element.getLastChild();
        if (lastChild != null) {
            return PsiTreeUtil.lastChild(lastChild);
        }
        return element;
    }

    public static PsiElement firstChild(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/PsiTreeUtil", "firstChild"));
        }
        PsiElement child = element.getFirstChild();
        if (child != null) {
            return PsiTreeUtil.firstChild(child);
        }
        return element;
    }

    @Nullable
    public static PsiElement prevLeaf(@NotNull PsiElement element, boolean skipEmptyElements) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/PsiTreeUtil", "prevLeaf"));
        }
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf(element);
        while (skipEmptyElements && prevLeaf != null && prevLeaf.getTextLength() == 0) {
            prevLeaf = PsiTreeUtil.prevLeaf(prevLeaf);
        }
        return prevLeaf;
    }

    @Nullable
    public static PsiElement prevVisibleLeaf(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/PsiTreeUtil", "prevVisibleLeaf"));
        }
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf(element, true);
        while (prevLeaf != null && StringUtil.isEmptyOrSpaces(prevLeaf.getText())) {
            prevLeaf = PsiTreeUtil.prevLeaf(prevLeaf, true);
        }
        return prevLeaf;
    }

    @Nullable
    public static PsiElement nextVisibleLeaf(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/PsiTreeUtil", "nextVisibleLeaf"));
        }
        PsiElement nextLeaf = PsiTreeUtil.nextLeaf(element, true);
        while (nextLeaf != null && StringUtil.isEmptyOrSpaces(nextLeaf.getText())) {
            nextLeaf = PsiTreeUtil.nextLeaf(nextLeaf, true);
        }
        return nextLeaf;
    }

    @Nullable
    public static PsiElement nextLeaf(PsiElement element, boolean skipEmptyElements) {
        PsiElement nextLeaf = PsiTreeUtil.nextLeaf(element);
        while (skipEmptyElements && nextLeaf != null && nextLeaf.getTextLength() == 0) {
            nextLeaf = PsiTreeUtil.nextLeaf(nextLeaf);
        }
        return nextLeaf;
    }

    public static boolean hasErrorElements(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/PsiTreeUtil", "hasErrorElements"));
        }
        return !SyntaxTraverser.psiTraverser(element).traverse().filter(PsiErrorElement.class).isEmpty();
    }

    @NotNull
    public static PsiElement[] filterAncestors(@NotNull PsiElement[] elements) {
        int previousSize;
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/psi/util/PsiTreeUtil", "filterAncestors"));
        }
        if (LOG.isDebugEnabled()) {
            for (PsiElement element : elements) {
                LOG.debug("element = " + element);
            }
        }
        ArrayList filteredElements = new ArrayList();
        ContainerUtil.addAll(filteredElements, elements);
        block1: do {
            previousSize = filteredElements.size();
            for (PsiElement element : filteredElements) {
                for (PsiElement element2 : filteredElements) {
                    if (element == element2 || !PsiTreeUtil.isAncestor(element, element2, false)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("removing " + element2);
                    }
                    filteredElements.remove(element2);
                    continue block1;
                }
            }
        } while (filteredElements.size() != previousSize);
        if (LOG.isDebugEnabled()) {
            for (PsiElement element : filteredElements) {
                LOG.debug("filtered element = " + element);
            }
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(filteredElements);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiTreeUtil", "filterAncestors"));
        }
        return psiElementArray;
    }

    public static boolean treeWalkUp(@NotNull PsiScopeProcessor processor, @NotNull PsiElement entrance, @Nullable PsiElement maxScope, @NotNull ResolveState state2) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/util/PsiTreeUtil", "treeWalkUp"));
        }
        if (entrance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entrance", "com/intellij/psi/util/PsiTreeUtil", "treeWalkUp"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/util/PsiTreeUtil", "treeWalkUp"));
        }
        PsiElement prevParent = entrance;
        PsiElement scope = entrance;
        while (scope != null) {
            if (!scope.processDeclarations(processor, state2, prevParent, entrance)) {
                return false;
            }
            if (scope == maxScope) break;
            prevParent = scope;
            scope = prevParent.getContext();
        }
        return true;
    }

    public static boolean treeWalkUp(@NotNull PsiElement entrance, @Nullable PsiElement maxScope, PairProcessor<PsiElement, PsiElement> eachScopeAndLastParent) {
        if (entrance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entrance", "com/intellij/psi/util/PsiTreeUtil", "treeWalkUp"));
        }
        PsiElement prevParent = null;
        PsiElement scope = entrance;
        while (scope != null) {
            if (!eachScopeAndLastParent.process(scope, prevParent)) {
                return false;
            }
            if (scope == maxScope) break;
            prevParent = scope;
            scope = prevParent.getContext();
        }
        return true;
    }

    @NotNull
    public static PsiElement findPrevParent(@NotNull PsiElement ancestor, @NotNull PsiElement descendant) {
        if (ancestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestor", "com/intellij/psi/util/PsiTreeUtil", "findPrevParent"));
        }
        if (descendant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descendant", "com/intellij/psi/util/PsiTreeUtil", "findPrevParent"));
        }
        PsiElement cur = descendant;
        while (cur != null) {
            PsiElement parent2 = cur.getParent();
            if (parent2 == ancestor) {
                PsiElement psiElement = cur;
                if (psiElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiTreeUtil", "findPrevParent"));
                }
                return psiElement;
            }
            cur = parent2;
        }
        throw new AssertionError((Object)(descendant + " is not a descendant of " + ancestor));
    }

    public static List<PsiElement> getInjectedElements(@NotNull OuterLanguageElement outerLanguageElement) {
        if (outerLanguageElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerLanguageElement", "com/intellij/psi/util/PsiTreeUtil", "getInjectedElements"));
        }
        PsiFile psi = outerLanguageElement.getContainingFile().getViewProvider().getPsi(outerLanguageElement.getLanguage());
        TextRange injectionRange = outerLanguageElement.getTextRange();
        ArrayList<PsiElement> res2 = ContainerUtil.newArrayList();
        assert (psi != null) : outerLanguageElement;
        for (PsiElement element = psi.findElementAt(injectionRange.getStartOffset()); element != null && injectionRange.intersectsStrict(element.getTextRange()); element = element.getNextSibling()) {
            res2.add(element);
        }
        return res2;
    }

    @NotNull
    public static <T extends PsiElement> Iterator<T> childIterator(final @NotNull PsiElement element, final @NotNull Class<T> aClass2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/PsiTreeUtil", "childIterator"));
        }
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/PsiTreeUtil", "childIterator"));
        }
        Iterator iterator2 = new Iterator<T>(){
            private T next;
            {
                this.next = PsiTreeUtil.getChildOfType(element, aClass2);
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public T next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object current = this.next;
                this.next = PsiTreeUtil.getNextSiblingOfType(current, aClass2);
                return current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        if (iterator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiTreeUtil", "childIterator"));
        }
        return iterator2;
    }
}

