/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiPrimitiveType
extends PsiType.Stub {
    private static final Map<String, PsiPrimitiveType> ourQNameToUnboxed = new THashMap<String, PsiPrimitiveType>();
    private static final Map<PsiPrimitiveType, String> ourUnboxedToQName = new THashMap<PsiPrimitiveType, String>();
    private final String myName;

    PsiPrimitiveType(@NotNull String name, String boxedName) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/PsiPrimitiveType", "<init>"));
        }
        this(name, TypeAnnotationProvider.EMPTY);
        if (boxedName != null) {
            ourQNameToUnboxed.put(boxedName, this);
            ourUnboxedToQName.put(this, boxedName);
        }
    }

    public PsiPrimitiveType(@NotNull String name, @NotNull PsiAnnotation[] annotations2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/PsiPrimitiveType", "<init>"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/psi/PsiPrimitiveType", "<init>"));
        }
        super(annotations2);
        this.myName = name;
    }

    public PsiPrimitiveType(@NotNull String name, @NotNull TypeAnnotationProvider provider) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/PsiPrimitiveType", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/PsiPrimitiveType", "<init>"));
        }
        super(provider);
        this.myName = name;
    }

    @Override
    @NotNull
    public PsiPrimitiveType annotate(@NotNull TypeAnnotationProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/PsiPrimitiveType", "annotate"));
        }
        PsiPrimitiveType psiPrimitiveType = (PsiPrimitiveType)super.annotate(provider);
        if (psiPrimitiveType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiPrimitiveType", "annotate"));
        }
        return psiPrimitiveType;
    }

    @Override
    @NotNull
    public String getPresentableText(boolean annotated) {
        String string = this.getText(false, annotated);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiPrimitiveType", "getPresentableText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string = this.getText(true, annotated);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiPrimitiveType", "getCanonicalText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string = this.getCanonicalText(true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiPrimitiveType", "getInternalCanonicalText"));
        }
        return string;
    }

    private String getText(boolean qualified, boolean annotated) {
        PsiAnnotation[] annotations2;
        PsiAnnotation[] psiAnnotationArray = annotations2 = annotated ? this.getAnnotations() : PsiAnnotation.EMPTY_ARRAY;
        if (annotations2.length == 0) {
            return this.myName;
        }
        StringBuilder sb = new StringBuilder();
        PsiNameHelper.appendAnnotations(sb, annotations2, qualified);
        sb.append(this.myName);
        return sb.toString();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean equalsToText(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/PsiPrimitiveType", "equalsToText"));
        }
        return this.myName.equals(text2);
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/PsiPrimitiveType", "accept"));
        }
        return visitor2.visitPrimitiveType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return null;
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiPrimitiveType", "getSuperTypes"));
        }
        return EMPTY_ARRAY;
    }

    @Nullable
    public static PsiPrimitiveType getUnboxedType(PsiType type2) {
        if (!(type2 instanceof PsiClassType)) {
            return null;
        }
        PsiUtil.ensureValidType(type2);
        LanguageLevel languageLevel = ((PsiClassType)type2).getLanguageLevel();
        if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
            return null;
        }
        PsiClass psiClass = ((PsiClassType)type2).resolve();
        if (psiClass == null) {
            return null;
        }
        PsiPrimitiveType unboxed = ourQNameToUnboxed.get(psiClass.getQualifiedName());
        if (unboxed == null) {
            return null;
        }
        return unboxed.annotate(type2.getAnnotationProvider());
    }

    public String getBoxedTypeName() {
        return ourUnboxedToQName.get(this);
    }

    @Nullable
    public PsiClassType getBoxedType(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/PsiPrimitiveType", "getBoxedType"));
        }
        PsiFile file2 = context.getContainingFile();
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel(file2);
        if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
            return null;
        }
        String boxedQName = this.getBoxedTypeName();
        if (boxedQName == null) {
            return null;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance(file2.getProject());
        PsiClass aClass2 = facade.findClass(boxedQName, file2.getResolveScope());
        if (aClass2 == null) {
            return null;
        }
        PsiElementFactory factory2 = facade.getElementFactory();
        return factory2.createType(aClass2, PsiSubstitutor.EMPTY, languageLevel).annotate(this.getAnnotationProvider());
    }

    @Nullable
    public PsiClassType getBoxedType(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/PsiPrimitiveType", "getBoxedType"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "com/intellij/psi/PsiPrimitiveType", "getBoxedType"));
        }
        String boxedQName = this.getBoxedTypeName();
        if (boxedQName == null) {
            return null;
        }
        PsiClass aClass2 = JavaPsiFacade.getInstance(manager.getProject()).findClass(boxedQName, resolveScope);
        if (aClass2 == null) {
            return null;
        }
        return JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createType(aClass2);
    }

    public static Collection<String> getAllBoxedTypeNames() {
        return Collections.unmodifiableCollection(ourQNameToUnboxed.keySet());
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof PsiPrimitiveType && this.myName.equals(((PsiPrimitiveType)obj).myName);
    }
}

